/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaConnectS2IList;
import io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.KafkaConnectS2I;
import io.strimzi.api.kafka.model.KafkaConnectS2IBuilder;
import io.strimzi.api.kafka.model.KafkaConnectS2IFluent;
import io.strimzi.api.kafka.model.KafkaConnectS2IResources;
import io.strimzi.api.kafka.model.KafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.Environment;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.KubernetesResource;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.TestUtils;
import java.util.function.Consumer;

public class KafkaConnectS2IResource {
    public static MixedOperation<KafkaConnectS2I, KafkaConnectS2IList, Resource<KafkaConnectS2I>> kafkaConnectS2IClient() {
        return Crds.kafkaConnectS2iOperation((KubernetesClient)ResourceManager.kubeClient().getClient());
    }

    public static KafkaConnectS2IBuilder kafkaConnectS2I(String name, String clusterName, int kafkaConnectS2IReplicas) {
        KafkaConnectS2I kafkaConnectS2I = KafkaConnectS2IResource.getKafkaConnectS2IFromYaml(Constants.PATH_TO_KAFKA_CONNECT_S2I_CONFIG);
        return KafkaConnectS2IResource.defaultKafkaConnectS2I(kafkaConnectS2I, name, clusterName, kafkaConnectS2IReplicas);
    }

    public static KafkaConnectS2IBuilder defaultKafkaConnectS2I(KafkaConnectS2I kafkaConnectS2I, String name, String kafkaClusterName, int kafkaConnectReplicas) {
        return (KafkaConnectS2IBuilder)((KafkaConnectS2IFluent.SpecNested)((AbstractKafkaConnectSpecFluent.InlineLoggingNested)((KafkaConnectS2IFluent.SpecNested)((KafkaConnectS2IFluent.SpecNested)((KafkaConnectSpecFluent.TlsNested)((KafkaConnectS2IFluent.SpecNested)((KafkaConnectS2IFluent.SpecNested)((KafkaConnectS2IFluent.SpecNested)((KafkaConnectS2IBuilder)((KafkaConnectS2IFluent.MetadataNested)((KafkaConnectS2IFluent.MetadataNested)((KafkaConnectS2IFluent.MetadataNested)new KafkaConnectS2IBuilder(kafkaConnectS2I).withNewMetadata().withName(name)).withNamespace(ResourceManager.kubeClient().getNamespace())).withClusterName(kafkaClusterName)).endMetadata()).editSpec().withVersion(Environment.ST_KAFKA_VERSION)).withBootstrapServers(KafkaResources.tlsBootstrapAddress((String)kafkaClusterName))).withReplicas(Integer.valueOf(kafkaConnectReplicas))).withNewTls().withTrustedCertificates(new CertSecretSource[]{((CertSecretSourceBuilder)((CertSecretSourceBuilder)new CertSecretSourceBuilder().withNewSecretName(kafkaClusterName + "-cluster-ca-cert")).withCertificate("ca.crt")).build()})).endTls()).withInsecureSourceRepository(true)).withNewInlineLogging().addToLoggers("connect.root.logger.level", "DEBUG")).endInlineLogging()).endSpec();
    }

    public static KafkaConnectS2I createAndWaitForReadiness(KafkaConnectS2I kafkaConnectS2I) {
        KubernetesResource.allowNetworkPolicySettingsForResource((HasMetadata)kafkaConnectS2I, KafkaConnectS2IResources.deploymentName((String)kafkaConnectS2I.getMetadata().getName()));
        TestUtils.waitFor((String)"KafkaConnect creation", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_CREATION, (long)ResourceManager.CR_CREATION_TIMEOUT, () -> {
            try {
                ((NonNamespaceOperation)KafkaConnectS2IResource.kafkaConnectS2IClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaConnectS2I[]{kafkaConnectS2I});
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getMessage().contains("object is being deleted")) {
                    return false;
                }
                throw e;
            }
        });
        return KafkaConnectS2IResource.waitFor(KafkaConnectS2IResource.deleteLater(kafkaConnectS2I));
    }

    public static KafkaConnectS2I kafkaConnectS2IWithoutWait(KafkaConnectS2I kafkaConnectS2I) {
        ((NonNamespaceOperation)KafkaConnectS2IResource.kafkaConnectS2IClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaConnectS2I[]{kafkaConnectS2I});
        return kafkaConnectS2I;
    }

    public static void deleteKafkaConnectS2IWithoutWait(String resourceName) {
        ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)KafkaConnectS2IResource.kafkaConnectS2IClient().inNamespace(ResourceManager.kubeClient().getNamespace())).withName(resourceName)).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
    }

    private static KafkaConnectS2I getKafkaConnectS2IFromYaml(String yamlPath) {
        return (KafkaConnectS2I)TestUtils.configFromYaml((String)yamlPath, KafkaConnectS2I.class);
    }

    private static KafkaConnectS2I waitFor(KafkaConnectS2I kafkaConnectS2I) {
        return ResourceManager.waitForResourceStatus(KafkaConnectS2IResource.kafkaConnectS2IClient(), kafkaConnectS2I, CustomResourceStatus.Ready);
    }

    private static KafkaConnectS2I deleteLater(KafkaConnectS2I kafkaConnectS2I) {
        return ResourceManager.deleteLater(KafkaConnectS2IResource.kafkaConnectS2IClient(), kafkaConnectS2I);
    }

    public static void replaceConnectS2IResource(String resourceName, Consumer<KafkaConnectS2I> editor) {
        ResourceManager.replaceCrdResource(KafkaConnectS2I.class, KafkaConnectS2IList.class, resourceName, editor);
    }
}

