/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaMirrorMaker2List;
import io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2Builder;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluent;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2Fluent;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.Environment;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.function.Consumer;

public class KafkaMirrorMaker2Resource {
    public static final String PATH_TO_KAFKA_MIRROR_MAKER_2_CONFIG = TestUtils.USER_PATH + "/../examples/mirror-maker/kafka-mirror-maker-2.yaml";

    public static MixedOperation<KafkaMirrorMaker2, KafkaMirrorMaker2List, Resource<KafkaMirrorMaker2>> kafkaMirrorMaker2Client() {
        return Crds.kafkaMirrorMaker2Operation((KubernetesClient)ResourceManager.kubeClient().getClient());
    }

    public static KafkaMirrorMaker2Builder kafkaMirrorMaker2(String name, String targetClusterName, String sourceClusterName, int kafkaMirrorMaker2Replicas, boolean tlsListener) {
        KafkaMirrorMaker2 kafkaMirrorMaker2 = KafkaMirrorMaker2Resource.getKafkaMirrorMaker2FromYaml(PATH_TO_KAFKA_MIRROR_MAKER_2_CONFIG);
        return KafkaMirrorMaker2Resource.defaultKafkaMirrorMaker2(kafkaMirrorMaker2, name, targetClusterName, sourceClusterName, kafkaMirrorMaker2Replicas, tlsListener);
    }

    public static KafkaMirrorMaker2Builder kafkaMirrorMaker2WithMetrics(String name, String targetClusterName, String sourceClusterName, int kafkaMirrorMaker2Replicas) {
        KafkaMirrorMaker2 kafkaMirrorMaker2 = KafkaMirrorMaker2Resource.getKafkaMirrorMaker2FromYaml(Constants.PATH_TO_KAFKA_MIRROR_MAKER_2_METRICS_CONFIG);
        ConfigMap metricsCm = TestUtils.configMapFromYaml((String)Constants.PATH_TO_KAFKA_MIRROR_MAKER_2_METRICS_CONFIG, (String)"mirror-maker-2-metrics");
        ((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().configMaps().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new ConfigMap[]{metricsCm});
        return KafkaMirrorMaker2Resource.defaultKafkaMirrorMaker2(kafkaMirrorMaker2, name, targetClusterName, sourceClusterName, kafkaMirrorMaker2Replicas, false);
    }

    private static KafkaMirrorMaker2Builder defaultKafkaMirrorMaker2(KafkaMirrorMaker2 kafkaMirrorMaker2, String name, String kafkaTargetClusterName, String kafkaSourceClusterName, int kafkaMirrorMaker2Replicas, boolean tlsListener) {
        KafkaMirrorMaker2ClusterSpec targetClusterSpec = ((KafkaMirrorMaker2ClusterSpecBuilder)((KafkaMirrorMaker2ClusterSpecBuilder)((KafkaMirrorMaker2ClusterSpecBuilder)((KafkaMirrorMaker2ClusterSpecBuilder)((KafkaMirrorMaker2ClusterSpecBuilder)new KafkaMirrorMaker2ClusterSpecBuilder().withAlias(kafkaTargetClusterName)).withBootstrapServers(KafkaResources.plainBootstrapAddress((String)kafkaTargetClusterName))).addToConfig("config.storage.replication.factor", (Object)1)).addToConfig("offset.storage.replication.factor", (Object)1)).addToConfig("status.storage.replication.factor", (Object)1)).build();
        KafkaMirrorMaker2ClusterSpec sourceClusterSpec = ((KafkaMirrorMaker2ClusterSpecBuilder)((KafkaMirrorMaker2ClusterSpecBuilder)new KafkaMirrorMaker2ClusterSpecBuilder().withAlias(kafkaSourceClusterName)).withBootstrapServers(KafkaResources.plainBootstrapAddress((String)kafkaSourceClusterName))).build();
        if (tlsListener) {
            targetClusterSpec = ((KafkaMirrorMaker2ClusterSpecBuilder)((KafkaMirrorMaker2ClusterSpecFluent.TlsNested)((KafkaMirrorMaker2ClusterSpecBuilder)new KafkaMirrorMaker2ClusterSpecBuilder(targetClusterSpec).withBootstrapServers(KafkaResources.tlsBootstrapAddress((String)kafkaTargetClusterName))).withNewTls().withTrustedCertificates(new CertSecretSource[]{((CertSecretSourceBuilder)((CertSecretSourceBuilder)new CertSecretSourceBuilder().withNewSecretName(KafkaResources.clusterCaCertificateSecretName((String)kafkaTargetClusterName))).withCertificate("ca.crt")).build()})).endTls()).build();
            sourceClusterSpec = ((KafkaMirrorMaker2ClusterSpecBuilder)((KafkaMirrorMaker2ClusterSpecFluent.TlsNested)((KafkaMirrorMaker2ClusterSpecBuilder)new KafkaMirrorMaker2ClusterSpecBuilder(sourceClusterSpec).withBootstrapServers(KafkaResources.tlsBootstrapAddress((String)kafkaSourceClusterName))).withNewTls().withTrustedCertificates(new CertSecretSource[]{((CertSecretSourceBuilder)((CertSecretSourceBuilder)new CertSecretSourceBuilder().withNewSecretName(KafkaResources.clusterCaCertificateSecretName((String)kafkaSourceClusterName))).withCertificate("ca.crt")).build()})).endTls()).build();
        }
        return (KafkaMirrorMaker2Builder)((KafkaMirrorMaker2Fluent.SpecNested)((AbstractKafkaConnectSpecFluent.InlineLoggingNested)((KafkaMirrorMaker2Fluent.SpecNested)((KafkaMirrorMaker2SpecFluent.MirrorsNested)((KafkaMirrorMaker2SpecFluent.MirrorsNested)((KafkaMirrorMaker2Fluent.SpecNested)((KafkaMirrorMaker2Fluent.SpecNested)((KafkaMirrorMaker2Fluent.SpecNested)((KafkaMirrorMaker2Fluent.SpecNested)((KafkaMirrorMaker2Builder)((KafkaMirrorMaker2Fluent.MetadataNested)((KafkaMirrorMaker2Fluent.MetadataNested)((KafkaMirrorMaker2Fluent.MetadataNested)new KafkaMirrorMaker2Builder(kafkaMirrorMaker2).withNewMetadata().withName(name)).withNamespace(ResourceManager.kubeClient().getNamespace())).withClusterName(kafkaTargetClusterName)).endMetadata()).editOrNewSpec().withVersion(Environment.ST_KAFKA_VERSION)).withReplicas(Integer.valueOf(kafkaMirrorMaker2Replicas))).withConnectCluster(kafkaTargetClusterName)).withClusters(new KafkaMirrorMaker2ClusterSpec[]{targetClusterSpec, sourceClusterSpec})).editFirstMirror().withSourceCluster(kafkaSourceClusterName)).withTargetCluster(kafkaTargetClusterName)).endMirror()).withNewInlineLogging().addToLoggers("connect.root.logger.level", "DEBUG")).endInlineLogging()).endSpec();
    }

    public static KafkaMirrorMaker2 createAndWaitForReadiness(KafkaMirrorMaker2 kafkaMirrorMaker2) {
        TestUtils.waitFor((String)"KafkaMirrorMaker2 creation", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_CREATION, (long)ResourceManager.CR_CREATION_TIMEOUT, () -> {
            try {
                ((NonNamespaceOperation)KafkaMirrorMaker2Resource.kafkaMirrorMaker2Client().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaMirrorMaker2[]{kafkaMirrorMaker2});
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getMessage().contains("object is being deleted")) {
                    return false;
                }
                throw e;
            }
        });
        return KafkaMirrorMaker2Resource.waitFor(KafkaMirrorMaker2Resource.deleteLater(kafkaMirrorMaker2));
    }

    public static KafkaMirrorMaker2 kafkaMirrorMaker2WithoutWait(KafkaMirrorMaker2 kafkaMirrorMaker2) {
        ((NonNamespaceOperation)KafkaMirrorMaker2Resource.kafkaMirrorMaker2Client().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaMirrorMaker2[]{kafkaMirrorMaker2});
        return kafkaMirrorMaker2;
    }

    public static void deleteKafkaMirrorMaker2WithoutWait(String resourceName) {
        ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)KafkaMirrorMaker2Resource.kafkaMirrorMaker2Client().inNamespace(ResourceManager.kubeClient().getNamespace())).withName(resourceName)).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
    }

    private static KafkaMirrorMaker2 getKafkaMirrorMaker2FromYaml(String yamlPath) {
        return (KafkaMirrorMaker2)TestUtils.configFromYaml((String)yamlPath, KafkaMirrorMaker2.class);
    }

    private static KafkaMirrorMaker2 waitFor(KafkaMirrorMaker2 kafkaMirrorMaker2) {
        return ResourceManager.waitForResourceStatus(KafkaMirrorMaker2Resource.kafkaMirrorMaker2Client(), kafkaMirrorMaker2, CustomResourceStatus.Ready);
    }

    private static KafkaMirrorMaker2 deleteLater(KafkaMirrorMaker2 kafkaMirrorMaker2) {
        return ResourceManager.deleteLater(KafkaMirrorMaker2Resource.kafkaMirrorMaker2Client(), kafkaMirrorMaker2);
    }

    public static void replaceKafkaMirrorMaker2Resource(String resourceName, Consumer<KafkaMirrorMaker2> editor) {
        ResourceManager.replaceCrdResource(KafkaMirrorMaker2.class, KafkaMirrorMaker2List.class, resourceName, editor);
    }
}

