/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaMirrorMakerList;
import io.strimzi.api.kafka.model.KafkaMirrorMaker;
import io.strimzi.api.kafka.model.KafkaMirrorMakerBuilder;
import io.strimzi.api.kafka.model.KafkaMirrorMakerFluent;
import io.strimzi.api.kafka.model.KafkaMirrorMakerSpecFluent;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.Environment;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.TestUtils;
import java.util.function.Consumer;

public class KafkaMirrorMakerResource {
    public static final String PATH_TO_KAFKA_MIRROR_MAKER_CONFIG = TestUtils.USER_PATH + "/../examples/mirror-maker/kafka-mirror-maker.yaml";

    public static MixedOperation<KafkaMirrorMaker, KafkaMirrorMakerList, Resource<KafkaMirrorMaker>> kafkaMirrorMakerClient() {
        return Crds.mirrorMakerOperation((KubernetesClient)ResourceManager.kubeClient().getClient());
    }

    public static KafkaMirrorMakerBuilder kafkaMirrorMaker(String name, String sourceBootstrapServer, String targetBootstrapServer, String groupId, int mirrorMakerReplicas, boolean tlsListener) {
        KafkaMirrorMaker kafkaMirrorMaker = KafkaMirrorMakerResource.getKafkaMirrorMakerFromYaml(PATH_TO_KAFKA_MIRROR_MAKER_CONFIG);
        return KafkaMirrorMakerResource.defaultKafkaMirrorMaker(kafkaMirrorMaker, name, sourceBootstrapServer, targetBootstrapServer, groupId, mirrorMakerReplicas, tlsListener);
    }

    private static KafkaMirrorMakerBuilder defaultKafkaMirrorMaker(KafkaMirrorMaker kafkaMirrorMaker, String name, String sourceBootstrapServer, String targetBootstrapServer, String groupId, int kafkaMirrorMakerReplicas, boolean tlsListener) {
        return (KafkaMirrorMakerBuilder)((KafkaMirrorMakerFluent.SpecNested)((KafkaMirrorMakerSpecFluent.InlineLoggingNested)((KafkaMirrorMakerFluent.SpecNested)((KafkaMirrorMakerFluent.SpecNested)((KafkaMirrorMakerFluent.SpecNested)((KafkaMirrorMakerSpecFluent.ProducerNested)((KafkaMirrorMakerSpecFluent.ProducerNested)((KafkaMirrorMakerFluent.SpecNested)((KafkaMirrorMakerSpecFluent.ConsumerNested)((KafkaMirrorMakerSpecFluent.ConsumerNested)((KafkaMirrorMakerSpecFluent.ConsumerNested)((KafkaMirrorMakerFluent.SpecNested)((KafkaMirrorMakerBuilder)((KafkaMirrorMakerFluent.MetadataNested)((KafkaMirrorMakerFluent.MetadataNested)new KafkaMirrorMakerBuilder(kafkaMirrorMaker).withNewMetadata().withName(name)).withNamespace(ResourceManager.kubeClient().getNamespace())).endMetadata()).editSpec().withVersion(Environment.ST_KAFKA_VERSION)).withNewConsumer().withBootstrapServers(tlsListener ? KafkaResources.tlsBootstrapAddress((String)sourceBootstrapServer) : KafkaResources.plainBootstrapAddress((String)sourceBootstrapServer))).withGroupId(groupId)).addToConfig("auto.offset.reset", (Object)"earliest")).endConsumer()).withNewProducer().withBootstrapServers(tlsListener ? KafkaResources.tlsBootstrapAddress((String)targetBootstrapServer) : KafkaResources.plainBootstrapAddress((String)targetBootstrapServer))).addToConfig("acks", (Object)"all")).endProducer()).withReplicas(kafkaMirrorMakerReplicas)).withWhitelist(".*")).withNewInlineLogging().addToLoggers("mirrormaker.root.logger", "DEBUG")).endInlineLogging()).endSpec();
    }

    public static KafkaMirrorMaker createAndWaitForReadiness(KafkaMirrorMaker kafkaMirrorMaker) {
        TestUtils.waitFor((String)"KafkaMirrorMaker creation", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_CREATION, (long)ResourceManager.CR_CREATION_TIMEOUT, () -> {
            try {
                ((NonNamespaceOperation)KafkaMirrorMakerResource.kafkaMirrorMakerClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaMirrorMaker[]{kafkaMirrorMaker});
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getMessage().contains("object is being deleted")) {
                    return false;
                }
                throw e;
            }
        });
        return KafkaMirrorMakerResource.waitFor(KafkaMirrorMakerResource.deleteLater(kafkaMirrorMaker));
    }

    public static KafkaMirrorMaker kafkaMirrorMakerWithoutWait(KafkaMirrorMaker kafkaMirrorMaker) {
        ((NonNamespaceOperation)KafkaMirrorMakerResource.kafkaMirrorMakerClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaMirrorMaker[]{kafkaMirrorMaker});
        return kafkaMirrorMaker;
    }

    public static void deleteKafkaMirrorMakerWithoutWait(String resourceName) {
        ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)KafkaMirrorMakerResource.kafkaMirrorMakerClient().inNamespace(ResourceManager.kubeClient().getNamespace())).withName(resourceName)).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
    }

    private static KafkaMirrorMaker getKafkaMirrorMakerFromYaml(String yamlPath) {
        return (KafkaMirrorMaker)TestUtils.configFromYaml((String)yamlPath, KafkaMirrorMaker.class);
    }

    private static KafkaMirrorMaker waitFor(KafkaMirrorMaker kafkaMirrorMaker) {
        return ResourceManager.waitForResourceStatus(KafkaMirrorMakerResource.kafkaMirrorMakerClient(), kafkaMirrorMaker, CustomResourceStatus.Ready);
    }

    private static KafkaMirrorMaker deleteLater(KafkaMirrorMaker kafkaMirrorMaker) {
        return ResourceManager.deleteLater(KafkaMirrorMakerResource.kafkaMirrorMakerClient(), kafkaMirrorMaker);
    }

    public static void replaceMirrorMakerResource(String resourceName, Consumer<KafkaMirrorMaker> editor) {
        ResourceManager.replaceCrdResource(KafkaMirrorMaker.class, KafkaMirrorMakerList.class, resourceName, editor);
    }
}

