/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelectorBuilder;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaList;
import io.strimzi.api.kafka.model.EntityOperatorSpecFluent;
import io.strimzi.api.kafka.model.EntityTopicOperatorSpecFluent;
import io.strimzi.api.kafka.model.EntityUserOperatorSpecFluent;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluent;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaBuilder;
import io.strimzi.api.kafka.model.KafkaClusterSpecFluent;
import io.strimzi.api.kafka.model.KafkaFluent;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.api.kafka.model.KafkaSpecFluent;
import io.strimzi.api.kafka.model.MetricsConfig;
import io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent;
import io.strimzi.api.kafka.model.listener.arraylistener.ArrayOrObjectKafkaListenersFluent;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType;
import io.strimzi.api.kafka.model.status.KafkaStatus;
import io.strimzi.api.kafka.model.storage.JbodStorage;
import io.strimzi.api.kafka.model.storage.Storage;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.Environment;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.systemtest.utils.TestKafkaVersion;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class KafkaResource {
    private static final String PATH_TO_KAFKA_CRUISE_CONTROL_CONFIG = TestUtils.USER_PATH + "/../examples/cruise-control/kafka-cruise-control.yaml";
    private static final String PATH_TO_KAFKA_EPHEMERAL_CONFIG = TestUtils.USER_PATH + "/../examples/kafka/kafka-ephemeral.yaml";
    private static final String PATH_TO_KAFKA_PERSISTENT_CONFIG = TestUtils.USER_PATH + "/../examples/kafka/kafka-persistent.yaml";

    public static MixedOperation<Kafka, KafkaList, Resource<Kafka>> kafkaClient() {
        return Crds.kafkaOperation((KubernetesClient)ResourceManager.kubeClient().getClient());
    }

    public static KafkaBuilder kafkaEphemeral(String clusterName, int kafkaReplicas) {
        return KafkaResource.kafkaEphemeral(clusterName, kafkaReplicas, Math.min(kafkaReplicas, 3));
    }

    public static KafkaBuilder kafkaEphemeral(String clusterName, int kafkaReplicas, int zookeeperReplicas) {
        return KafkaResource.defaultKafka(KafkaResource.getKafkaFromYaml(PATH_TO_KAFKA_EPHEMERAL_CONFIG), clusterName, kafkaReplicas, zookeeperReplicas);
    }

    public static KafkaBuilder kafkaPersistent(String name, int kafkaReplicas) {
        return KafkaResource.kafkaPersistent(name, kafkaReplicas, Math.min(kafkaReplicas, 3));
    }

    public static KafkaBuilder kafkaPersistent(String clusterName, int kafkaReplicas, int zookeeperReplicas) {
        return (KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((ZookeeperClusterSpecFluent.PersistentClaimStorageNested)((ZookeeperClusterSpecFluent.PersistentClaimStorageNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaClusterSpecFluent.PersistentClaimStorageNested)((KafkaClusterSpecFluent.PersistentClaimStorageNested)KafkaResource.defaultKafka(KafkaResource.getKafkaFromYaml(PATH_TO_KAFKA_PERSISTENT_CONFIG), clusterName, kafkaReplicas, zookeeperReplicas).editSpec().editKafka().withNewPersistentClaimStorage().withNewSize("100")).withDeleteClaim(true)).endPersistentClaimStorage()).endKafka()).editZookeeper().withNewPersistentClaimStorage().withNewSize("100")).withDeleteClaim(true)).endPersistentClaimStorage()).endZookeeper()).endSpec();
    }

    public static KafkaBuilder kafkaJBOD(String name, int kafkaReplicas, JbodStorage jbodStorage) {
        return KafkaResource.kafkaJBOD(name, kafkaReplicas, Math.min(kafkaReplicas, 3), jbodStorage);
    }

    public static KafkaBuilder kafkaJBOD(String name, int kafkaReplicas, int zookeeperReplicas, JbodStorage jbodStorage) {
        return (KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)KafkaResource.kafkaPersistent(name, kafkaReplicas, zookeeperReplicas).editSpec().editKafka().withStorage((Storage)jbodStorage)).endKafka()).endSpec();
    }

    public static KafkaBuilder kafkaWithMetrics(String name, int kafkaReplicas, int zookeeperReplicas) {
        Kafka kafka = KafkaResource.getKafkaFromYaml(Constants.PATH_TO_KAFKA_METRICS_CONFIG);
        KafkaResource.deployMetricsConfigMaps();
        return (KafkaBuilder)((KafkaFluent.SpecNested)KafkaResource.defaultKafka(kafka, name, kafkaReplicas, zookeeperReplicas).editSpec().withNewKafkaExporter().endKafkaExporter()).endSpec();
    }

    public static KafkaBuilder kafkaWithCruiseControl(String name, int kafkaReplicas, int zookeeperReplicas) {
        Kafka kafka = KafkaResource.getKafkaFromYaml(PATH_TO_KAFKA_CRUISE_CONTROL_CONFIG);
        return KafkaResource.defaultKafka(kafka, name, kafkaReplicas, zookeeperReplicas);
    }

    public static KafkaBuilder kafkaAndCruiseControlWithMetrics(String name, int kafkaReplicas, int zookeeperReplicas) {
        Kafka kafka = KafkaResource.getKafkaFromYaml(Constants.PATH_TO_KAFKA_CRUISE_CONTROL_METRICS_CONFIG);
        KafkaResource.deployMetricsConfigMaps();
        ConfigMap ccMetricsCm = TestUtils.configMapFromYaml((String)PATH_TO_KAFKA_CRUISE_CONTROL_CONFIG, (String)"cruise-control-metrics");
        ((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().configMaps().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new ConfigMap[]{ccMetricsCm});
        return KafkaResource.defaultKafka(kafka, name, kafkaReplicas, zookeeperReplicas);
    }

    public static KafkaBuilder kafkaWithMetricsAndCruiseControlWithMetrics(String name, int kafkaReplicas, int zookeeperReplicas) {
        ConfigMap ccCm = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapBuilder)new ConfigMapBuilder().withApiVersion("v1")).withNewMetadata().withName("cruise-control-metrics-test")).withLabels(Collections.singletonMap("app", "strimzi"))).endMetadata()).withData(Collections.singletonMap("metrics-config.yml", "lowercaseOutputName: true\nrules:\n- pattern: kafka.cruisecontrol<name=(.+)><>(\\w+)\n  name: kafka_cruisecontrol_$1_$2\n  type: GAUGE"))).build();
        ((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().configMaps().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new ConfigMap[]{ccCm});
        ConfigMapKeySelector cmks = ((ConfigMapKeySelectorBuilder)((ConfigMapKeySelectorBuilder)new ConfigMapKeySelectorBuilder().withName("cruise-control-metrics-test")).withKey("metrics-config.yml")).build();
        JmxPrometheusExporterMetrics jmxPrometheusExporterMetrics = ((JmxPrometheusExporterMetricsBuilder)((JmxPrometheusExporterMetricsFluent.ValueFromNested)new JmxPrometheusExporterMetricsBuilder().withNewValueFrom().withConfigMapKeyRef(cmks)).endValueFrom()).build();
        return (KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.CruiseControlNested)KafkaResource.kafkaWithMetrics(name, kafkaReplicas, zookeeperReplicas).editSpec().withNewCruiseControl().withMetricsConfig((MetricsConfig)jmxPrometheusExporterMetrics)).endCruiseControl()).endSpec();
    }

    private static void deployMetricsConfigMaps() {
        ConfigMap metricsCm = TestUtils.configMapFromYaml((String)Constants.PATH_TO_KAFKA_METRICS_CONFIG, (String)"kafka-metrics");
        ((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().configMaps().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new ConfigMap[]{metricsCm});
    }

    private static KafkaBuilder defaultKafka(Kafka kafka, String name, int kafkaReplicas, int zookeeperReplicas) {
        return (KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.EntityOperatorNested)((EntityOperatorSpecFluent.TopicOperatorNested)((EntityTopicOperatorSpecFluent.InlineLoggingNested)((KafkaSpecFluent.EntityOperatorNested)((EntityOperatorSpecFluent.UserOperatorNested)((EntityUserOperatorSpecFluent.InlineLoggingNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((ZookeeperClusterSpecFluent.InlineLoggingNested)((KafkaSpecFluent.ZookeeperNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaClusterSpecFluent.InlineLoggingNested)((KafkaSpecFluent.KafkaNested)((KafkaClusterSpecFluent.ListenersNested)((ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested)((ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested)((ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested)((ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested)((KafkaClusterSpecFluent.ListenersNested)((ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested)((ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested)((ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested)((ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaBuilder)((KafkaFluent.MetadataNested)((KafkaFluent.MetadataNested)new KafkaBuilder(kafka).withNewMetadata().withName(name)).withNamespace(ResourceManager.kubeClient().getNamespace())).endMetadata()).editSpec().editKafka().withVersion(Environment.ST_KAFKA_VERSION)).withReplicas(kafkaReplicas)).addToConfig("log.message.format.version", (Object)TestKafkaVersion.getKafkaVersionsInMap().get(Environment.ST_KAFKA_VERSION).protocolVersion())).addToConfig("inter.broker.protocol.version", (Object)TestKafkaVersion.getKafkaVersionsInMap().get(Environment.ST_KAFKA_VERSION).protocolVersion())).addToConfig("offsets.topic.replication.factor", (Object)Math.min(kafkaReplicas, 3))).addToConfig("transaction.state.log.min.isr", (Object)Math.min(kafkaReplicas, 2))).addToConfig("transaction.state.log.replication.factor", (Object)Math.min(kafkaReplicas, 3))).withNewListeners().addNewGenericKafkaListener().withName("plain")).withPort(9092)).withType(KafkaListenerType.INTERNAL)).withTls(false)).endGenericKafkaListener()).addNewGenericKafkaListener().withName("tls")).withPort(9093)).withType(KafkaListenerType.INTERNAL)).withTls(true)).endGenericKafkaListener()).endListeners()).withNewInlineLogging().addToLoggers("kafka.root.logger.level", "DEBUG")).endInlineLogging()).endKafka()).editZookeeper().withReplicas(zookeeperReplicas)).withNewInlineLogging().addToLoggers("zookeeper.root.logger", "DEBUG")).endInlineLogging()).endZookeeper()).editEntityOperator().editUserOperator().withNewInlineLogging().addToLoggers("rootLogger.level", "DEBUG")).endInlineLogging()).endUserOperator()).editTopicOperator().withNewInlineLogging().addToLoggers("rootLogger.level", "DEBUG")).endInlineLogging()).endTopicOperator()).endEntityOperator()).endSpec();
    }

    public static KafkaBuilder kafkaFromYaml(File yamlFile, String clusterName, int kafkaReplicas, int zookeeperReplicas) {
        Kafka kafka = KafkaResource.getKafkaFromYaml(yamlFile);
        return (KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaBuilder)((KafkaFluent.MetadataNested)((KafkaFluent.MetadataNested)new KafkaBuilder(kafka).withNewMetadata().withName(clusterName)).withNamespace(ResourceManager.kubeClient().getNamespace())).endMetadata()).editOrNewSpec().editKafka().withReplicas(kafkaReplicas)).endKafka()).editZookeeper().withReplicas(zookeeperReplicas)).endZookeeper()).endSpec();
    }

    public static Kafka createAndWaitForReadiness(Kafka kafka) {
        TestUtils.waitFor((String)"Kafka creation", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_CREATION, (long)ResourceManager.CR_CREATION_TIMEOUT, () -> {
            try {
                ((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new Kafka[]{kafka});
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getMessage().contains("object is being deleted")) {
                    return false;
                }
                throw e;
            }
        });
        return KafkaResource.waitFor(KafkaResource.deleteLater(kafka));
    }

    public static Kafka kafkaWithoutWait(Kafka kafka) {
        ((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new Kafka[]{kafka});
        return kafka;
    }

    public static Kafka kafkaWithCruiseControlWithoutWait(String name, int kafkaReplicas, int zookeeperReplicas) {
        return (Kafka)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new Kafka[]{KafkaResource.kafkaWithCruiseControl(name, kafkaReplicas, zookeeperReplicas).build()});
    }

    public static void deleteKafkaWithoutWait(String resourceName) {
        ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(ResourceManager.kubeClient().getNamespace())).withName(resourceName)).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
    }

    private static Kafka getKafkaFromYaml(String yamlPath) {
        return (Kafka)TestUtils.configFromYaml((String)yamlPath, Kafka.class);
    }

    private static Kafka getKafkaFromYaml(File yamlFile) {
        return (Kafka)TestUtils.configFromYaml((File)yamlFile, Kafka.class);
    }

    private static Kafka waitFor(Kafka kafka) {
        long timeout = ResourceOperation.getTimeoutForResourceReadiness(kafka.getKind());
        if (kafka.getSpec().getKafkaExporter() != null) {
            timeout += ResourceOperation.getTimeoutForResourceReadiness("KafkaWithExporter");
        }
        if (kafka.getSpec().getCruiseControl() != null) {
            timeout += ResourceOperation.getTimeoutForResourceReadiness("KafkaWithCruiseControl");
        }
        return ResourceManager.waitForResourceStatus(KafkaResource.kafkaClient(), kafka, CustomResourceStatus.Ready, timeout);
    }

    private static Kafka deleteLater(Kafka kafka) {
        return ResourceManager.deleteLater(KafkaResource.kafkaClient(), kafka);
    }

    public static void replaceKafkaResource(String resourceName, Consumer<Kafka> editor) {
        ResourceManager.replaceCrdResource(Kafka.class, KafkaList.class, resourceName, editor);
    }

    public static String getKafkaTlsListenerCaCertName(String namespace, String clusterName, String listenerName) {
        List listeners = ((Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(namespace)).withName(clusterName)).get()).getSpec().getKafka().getListeners().newOrConverted();
        GenericKafkaListener tlsListener = listenerName == null || listenerName.isEmpty() ? listeners.stream().filter(listener -> "tls".equals(listener.getName())).findFirst().orElseThrow(RuntimeException::new) : listeners.stream().filter(listener -> listenerName.equals(listener.getName())).findFirst().orElseThrow(RuntimeException::new);
        return tlsListener.getConfiguration() == null ? KafkaResources.clusterCaCertificateSecretName((String)clusterName) : tlsListener.getConfiguration().getBrokerCertChainAndKey().getSecretName();
    }

    public static String getKafkaExternalListenerCaCertName(String namespace, String clusterName, String listenerName) {
        List listeners = ((Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(namespace)).withName(clusterName)).get()).getSpec().getKafka().getListeners().newOrConverted();
        GenericKafkaListener external = listenerName == null || listenerName.isEmpty() ? listeners.stream().filter(listener -> "external".equals(listener.getName())).findFirst().orElseThrow(RuntimeException::new) : listeners.stream().filter(listener -> listenerName.equals(listener.getName())).findFirst().orElseThrow(RuntimeException::new);
        return external.getConfiguration() == null ? KafkaResources.clusterCaCertificateSecretName((String)clusterName) : external.getConfiguration().getBrokerCertChainAndKey().getSecretName();
    }

    public static KafkaStatus getKafkaStatus(String clusterName, String namespace) {
        return ((Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(namespace)).withName(clusterName)).get()).getStatus();
    }
}

