/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaTopicList;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.api.kafka.model.KafkaTopicBuilder;
import io.strimzi.api.kafka.model.KafkaTopicFluent;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.TestUtils;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaTopicResource {
    private static final Logger LOGGER = LogManager.getLogger(KafkaTopicResource.class);
    public static final String PATH_TO_KAFKA_TOPIC_CONFIG = TestUtils.USER_PATH + "/../examples/topic/kafka-topic.yaml";

    public static MixedOperation<KafkaTopic, KafkaTopicList, Resource<KafkaTopic>> kafkaTopicClient() {
        return Crds.topicOperation((KubernetesClient)ResourceManager.kubeClient().getClient());
    }

    public static KafkaTopicBuilder topic(String clusterName, String topicName) {
        return KafkaTopicResource.defaultTopic(clusterName, topicName, 1, 1, 1);
    }

    public static KafkaTopicBuilder topic(String clusterName, String topicName, int partitions) {
        return KafkaTopicResource.defaultTopic(clusterName, topicName, partitions, 1, 1);
    }

    public static KafkaTopicBuilder topic(String clusterName, String topicName, int partitions, int replicas) {
        return KafkaTopicResource.defaultTopic(clusterName, topicName, partitions, replicas, replicas);
    }

    public static KafkaTopicBuilder topic(String clusterName, String topicName, int partitions, int replicas, int minIsr) {
        return KafkaTopicResource.defaultTopic(clusterName, topicName, partitions, replicas, minIsr);
    }

    public static KafkaTopicBuilder defaultTopic(String clusterName, String topicName, int partitions, int replicas, int minIsr) {
        KafkaTopic kafkaTopic = KafkaTopicResource.getKafkaTopicFromYaml(PATH_TO_KAFKA_TOPIC_CONFIG);
        return (KafkaTopicBuilder)((KafkaTopicFluent.SpecNested)((KafkaTopicFluent.SpecNested)((KafkaTopicFluent.SpecNested)((KafkaTopicBuilder)((KafkaTopicFluent.MetadataNested)((KafkaTopicFluent.MetadataNested)((KafkaTopicFluent.MetadataNested)new KafkaTopicBuilder(kafkaTopic).withNewMetadata().withName(topicName)).withNamespace(ResourceManager.kubeClient().getNamespace())).addToLabels("strimzi.io/cluster", clusterName)).endMetadata()).editSpec().withPartitions(Integer.valueOf(partitions))).withReplicas(Integer.valueOf(replicas))).addToConfig("min.insync.replicas", (Object)minIsr)).endSpec();
    }

    public static KafkaTopic createAndWaitForReadiness(KafkaTopic topic) {
        ((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(topic.getMetadata().getNamespace())).createOrReplace((Object[])new KafkaTopic[]{topic});
        LOGGER.info("Created KafkaTopic {}", (Object)topic.getMetadata().getName());
        return KafkaTopicResource.waitFor(KafkaTopicResource.deleteLater(topic));
    }

    public static KafkaTopic topicWithoutWait(KafkaTopic kafkaTopic) {
        ((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaTopic[]{kafkaTopic});
        return kafkaTopic;
    }

    private static KafkaTopic getKafkaTopicFromYaml(String yamlPath) {
        return (KafkaTopic)TestUtils.configFromYaml((String)yamlPath, KafkaTopic.class);
    }

    private static KafkaTopic waitFor(KafkaTopic kafkaTopic) {
        return ResourceManager.waitForResourceStatus(KafkaTopicResource.kafkaTopicClient(), kafkaTopic, CustomResourceStatus.Ready);
    }

    private static KafkaTopic deleteLater(KafkaTopic kafkaTopic) {
        return ResourceManager.deleteLater(KafkaTopicResource.kafkaTopicClient(), kafkaTopic);
    }

    public static void replaceTopicResource(String resourceName, Consumer<KafkaTopic> editor) {
        ResourceManager.replaceCrdResource(KafkaTopic.class, KafkaTopicList.class, resourceName, editor);
    }
}

