/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaUserList;
import io.strimzi.api.kafka.model.KafkaUser;
import io.strimzi.api.kafka.model.KafkaUserBuilder;
import io.strimzi.api.kafka.model.KafkaUserFluent;
import io.strimzi.api.kafka.model.KafkaUserSpecFluent;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.ResourceManager;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaUserResource {
    private static final Logger LOGGER = LogManager.getLogger(KafkaUserResource.class);

    public static MixedOperation<KafkaUser, KafkaUserList, Resource<KafkaUser>> kafkaUserClient() {
        return Crds.kafkaUserOperation((KubernetesClient)ResourceManager.kubeClient().getClient());
    }

    public static KafkaUserBuilder tlsUser(String clusterName, String name) {
        return (KafkaUserBuilder)((KafkaUserFluent.SpecNested)KafkaUserResource.defaultUser(clusterName, name).withNewSpec().withNewKafkaUserTlsClientAuthentication().endKafkaUserTlsClientAuthentication()).endSpec();
    }

    public static KafkaUserBuilder scramShaUser(String clusterName, String name) {
        return (KafkaUserBuilder)((KafkaUserFluent.SpecNested)KafkaUserResource.defaultUser(clusterName, name).withNewSpec().withNewKafkaUserScramSha512ClientAuthentication().endKafkaUserScramSha512ClientAuthentication()).endSpec();
    }

    public static KafkaUserBuilder defaultUser(String clusterName, String name) {
        return (KafkaUserBuilder)((KafkaUserFluent.MetadataNested)((KafkaUserFluent.MetadataNested)((KafkaUserFluent.MetadataNested)((KafkaUserFluent.MetadataNested)new KafkaUserBuilder().withNewMetadata().withClusterName(clusterName)).withName(name)).withNamespace(ResourceManager.kubeClient().getNamespace())).addToLabels("strimzi.io/cluster", clusterName)).endMetadata();
    }

    public static KafkaUser createAndWaitForReadiness(KafkaUser user) {
        ((NonNamespaceOperation)KafkaUserResource.kafkaUserClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaUser[]{user});
        LOGGER.info("Created KafkaUser {}", (Object)user.getMetadata().getName());
        return KafkaUserResource.waitFor(KafkaUserResource.deleteLater(user));
    }

    public static KafkaUser kafkaUserWithoutWait(KafkaUser user) {
        ((NonNamespaceOperation)KafkaUserResource.kafkaUserClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaUser[]{user});
        return user;
    }

    private static KafkaUser waitFor(KafkaUser kafkaUser) {
        return ResourceManager.waitForResourceStatus(KafkaUserResource.kafkaUserClient(), kafkaUser, CustomResourceStatus.Ready);
    }

    private static KafkaUser deleteLater(KafkaUser kafkaUser) {
        return ResourceManager.deleteLater(KafkaUserResource.kafkaUserClient(), kafkaUser);
    }

    public static KafkaUserBuilder userWithQuota(KafkaUser user, Integer prodRate, Integer consRate, Integer requestPerc) {
        return (KafkaUserBuilder)((KafkaUserFluent.SpecNested)((KafkaUserSpecFluent.QuotasNested)((KafkaUserSpecFluent.QuotasNested)((KafkaUserSpecFluent.QuotasNested)new KafkaUserBuilder(user).editSpec().withNewQuotas().withConsumerByteRate(consRate)).withProducerByteRate(prodRate)).withRequestPercentage(requestPerc)).endQuotas()).endSpec();
    }

    public static void replaceUserResource(String resourceName, Consumer<KafkaUser> editor) {
        ResourceManager.replaceCrdResource(KafkaUser.class, KafkaUserList.class, resourceName, editor);
    }
}

