/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd.kafkaclients;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.kubernetes.api.model.batch.JobSpecFluent;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.crd.kafkaclients.KafkaBasicExampleClients;
import java.util.HashMap;

public class KafkaBridgeExampleClients
extends KafkaBasicExampleClients {
    private final int port;
    private final int pollInterval;

    public int getPollInterval() {
        return this.pollInterval;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    protected Builder newBuilder() {
        return new Builder();
    }

    protected Builder updateBuilder(Builder builder) {
        super.updateBuilder(builder);
        return builder.withPort(this.getPort()).withPollInterval(this.getPollInterval());
    }

    @Override
    public Builder toBuilder() {
        return this.updateBuilder(this.newBuilder());
    }

    private KafkaBridgeExampleClients(Builder builder) {
        super(builder);
        this.port = builder.port;
        this.pollInterval = builder.pollInterval;
    }

    public JobBuilder producerStrimziBridge() {
        HashMap<String, String> producerLabels = new HashMap<String, String>();
        producerLabels.put("app", this.producerName);
        producerLabels.put("user-test-app", "kafka-clients");
        return (JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((JobFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withNamespace(ResourceManager.kubeClient().getNamespace())).withLabels(producerLabels)).withName(this.producerName)).endMetadata()).withNewSpec().withBackoffLimit(Integer.valueOf(0))).withNewTemplate().withNewMetadata().withLabels(producerLabels)).endMetadata()).withNewSpec().withRestartPolicy("OnFailure")).withContainers(new Container[0])).addNewContainer().withName(this.producerName)).withImagePullPolicy("IfNotPresent")).withImage("strimzi/kafka-http-producer:latest")).addNewEnv().withName("HOSTNAME")).withValue(this.bootstrapAddress)).endEnv()).addNewEnv().withName("PORT")).withValue(Integer.toString(this.port))).endEnv()).addNewEnv().withName("TOPIC")).withValue(this.topicName)).endEnv()).addNewEnv().withName("SEND_INTERVAL")).withValue(String.valueOf(this.delayMs))).endEnv()).addNewEnv().withName("MESSAGE_COUNT")).withValue(Integer.toString(this.messageCount))).endEnv()).endContainer()).endSpec()).endTemplate()).endSpec();
    }

    public JobBuilder consumerStrimziBridge() {
        HashMap<String, String> consumerLabels = new HashMap<String, String>();
        consumerLabels.put("app", this.consumerName);
        consumerLabels.put("user-test-app", "kafka-clients");
        return (JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((JobFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withNamespace(ResourceManager.kubeClient().getNamespace())).withLabels(consumerLabels)).withName(this.consumerName)).endMetadata()).withNewSpec().withBackoffLimit(Integer.valueOf(0))).withNewTemplate().withNewMetadata().withLabels(consumerLabels)).endMetadata()).withNewSpec().withRestartPolicy("OnFailure")).withContainers(new Container[0])).addNewContainer().withName(this.consumerName)).withImagePullPolicy("IfNotPresent")).withImage("strimzi/kafka-http-consumer:latest")).addNewEnv().withName("HOSTNAME")).withValue(this.bootstrapAddress)).endEnv()).addNewEnv().withName("PORT")).withValue(Integer.toString(this.port))).endEnv()).addNewEnv().withName("TOPIC")).withValue(this.topicName)).endEnv()).addNewEnv().withName("POLL_INTERVAL")).withValue(Integer.toString(this.pollInterval))).endEnv()).addNewEnv().withName("MESSAGE_COUNT")).withValue(Integer.toString(this.messageCount))).endEnv()).addNewEnv().withName("GROUP_ID")).withValue(this.consumerGroup)).endEnv()).endContainer()).endSpec()).endTemplate()).endSpec();
    }

    public static class Builder
    extends KafkaBasicExampleClients.Builder {
        private int port;
        private int pollInterval;

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withPollInterval(int pollInterval) {
            this.pollInterval = pollInterval;
            return this;
        }

        @Override
        public Builder withProducerName(String producerName) {
            return (Builder)super.withProducerName(producerName);
        }

        @Override
        public Builder withConsumerName(String consumerName) {
            return (Builder)super.withConsumerName(consumerName);
        }

        @Override
        public Builder withBootstrapAddress(String bootstrapAddress) {
            return (Builder)super.withBootstrapAddress(bootstrapAddress);
        }

        @Override
        public Builder withTopicName(String topicName) {
            return (Builder)super.withTopicName(topicName);
        }

        @Override
        public Builder withMessageCount(int messageCount) {
            return (Builder)super.withMessageCount(messageCount);
        }

        @Override
        public Builder withAdditionalConfig(String additionalConfig) {
            return (Builder)super.withAdditionalConfig(additionalConfig);
        }

        @Override
        public Builder withConsumerGroup(String consumerGroup) {
            return (Builder)super.withConsumerGroup(consumerGroup);
        }

        @Override
        public Builder withDelayMs(long delayMs) {
            return (Builder)super.withDelayMs(delayMs);
        }

        @Override
        public KafkaBridgeExampleClients build() {
            return new KafkaBridgeExampleClients(this);
        }
    }
}

