/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd.kafkaclients;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.kubernetes.api.model.batch.JobSpecFluent;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.systemtest.resources.crd.kafkaclients.KafkaBasicExampleClients;
import java.security.InvalidParameterException;

public class KafkaOauthExampleClients
extends KafkaBasicExampleClients {
    private final String oauthClientId;
    private final String oauthClientSecret;
    private final String oauthTokenEndpointUri;
    private final String userName;

    protected KafkaOauthExampleClients(Builder builder) {
        super(builder);
        if (builder.oauthClientId == null || builder.oauthClientId.isEmpty()) {
            throw new InvalidParameterException("OAuth client id is not set.");
        }
        if (builder.oauthClientSecret == null || builder.oauthClientSecret.isEmpty()) {
            throw new InvalidParameterException("OAuth client secret is not set.");
        }
        if (builder.oauthTokenEndpointUri == null || builder.oauthTokenEndpointUri.isEmpty()) {
            throw new InvalidParameterException("OAuth token endpoint url is not set.");
        }
        if (builder.userName == null || builder.userName.isEmpty()) {
            builder.userName = builder.oauthClientId;
        }
        this.oauthClientId = builder.oauthClientId;
        this.oauthClientSecret = builder.oauthClientSecret;
        this.oauthTokenEndpointUri = builder.oauthTokenEndpointUri;
        this.userName = builder.userName;
    }

    @Override
    protected Builder newBuilder() {
        return new Builder();
    }

    protected Builder updateBuilder(Builder builder) {
        super.updateBuilder(builder);
        return builder.withOAuthClientId(this.getOauthClientId()).withOAuthClientSecret(this.getOauthClientSecret()).withOAuthTokenEndpointUri(this.getOauthTokenEndpointUri()).withUserName(this.getClientUserName());
    }

    @Override
    public Builder toBuilder() {
        return this.updateBuilder(this.newBuilder());
    }

    public String getOauthClientId() {
        return this.oauthClientId;
    }

    public String getOauthClientSecret() {
        return this.oauthClientSecret;
    }

    public String getOauthTokenEndpointUri() {
        return this.oauthTokenEndpointUri;
    }

    public String getClientUserName() {
        return this.userName;
    }

    public JobBuilder producerStrimziOauthPlain() {
        return this.defaultProducerStrimziOauthPlain();
    }

    private JobBuilder defaultProducerStrimziOauthPlain() {
        return (JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarSourceFluent.SecretKeyRefNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarSourceFluent.SecretKeyRefNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)this.defaultProducerStrimzi().editSpec().editTemplate().editSpec().editFirstContainer().addNewEnv().withName("OAUTH_CLIENT_ID")).withValue(this.oauthClientId)).endEnv()).addNewEnv().withName("OAUTH_CLIENT_SECRET")).editOrNewValueFrom().withNewSecretKeyRef().withName(this.oauthClientSecret)).withKey("clientSecret")).endSecretKeyRef()).endValueFrom()).endEnv()).addNewEnv().withName("OAUTH_TOKEN_ENDPOINT_URI")).withValue(this.oauthTokenEndpointUri)).endEnv()).addNewEnv().withName("OAUTH_CRT")).editOrNewValueFrom().withNewSecretKeyRef().withName("sso-x509-https-secret")).withKey("tls.crt")).endSecretKeyRef()).endValueFrom()).endEnv()).endContainer()).endSpec()).endTemplate()).endSpec();
    }

    public JobBuilder producerStrimziOauthTls(String clusterName) {
        return (JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarSourceFluent.SecretKeyRefNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarSourceFluent.SecretKeyRefNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarSourceFluent.SecretKeyRefNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)this.defaultProducerStrimziOauthPlain().editSpec().editTemplate().editSpec().editFirstContainer().addNewEnv().withName("OAUTH_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM")).withValue("")).endEnv()).addNewEnv().withName("CA_CRT")).withNewValueFrom().withNewSecretKeyRef().withName(KafkaResources.clusterCaCertificateSecretName((String)clusterName))).withKey("ca.crt")).endSecretKeyRef()).endValueFrom()).endEnv()).addNewEnv().withName("USER_CRT")).withNewValueFrom().withNewSecretKeyRef().withName(this.userName)).withKey("user.crt")).endSecretKeyRef()).endValueFrom()).endEnv()).addNewEnv().withName("USER_KEY")).withNewValueFrom().withNewSecretKeyRef().withName(this.userName)).withKey("user.key")).endSecretKeyRef()).endValueFrom()).endEnv()).endContainer()).endSpec()).endTemplate()).endSpec();
    }

    public JobBuilder consumerStrimziOauthPlain() {
        return this.defaultConsumerStrimziOauth();
    }

    private JobBuilder defaultConsumerStrimziOauth() {
        return (JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarSourceFluent.SecretKeyRefNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarSourceFluent.SecretKeyRefNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)this.defaultConsumerStrimzi().editSpec().editTemplate().editSpec().editFirstContainer().addNewEnv().withName("OAUTH_CLIENT_ID")).withValue(this.oauthClientId)).endEnv()).addNewEnv().withName("OAUTH_CLIENT_SECRET")).editOrNewValueFrom().withNewSecretKeyRef().withName(this.oauthClientSecret)).withKey("clientSecret")).endSecretKeyRef()).endValueFrom()).endEnv()).addNewEnv().withName("OAUTH_TOKEN_ENDPOINT_URI")).withValue(this.oauthTokenEndpointUri)).endEnv()).addNewEnv().withName("OAUTH_CRT")).editOrNewValueFrom().withNewSecretKeyRef().withName("sso-x509-https-secret")).withKey("tls.crt")).endSecretKeyRef()).endValueFrom()).endEnv()).addNewEnv().withName("LOG_LEVEL")).withValue("DEBUG")).endEnv()).endContainer()).endSpec()).endTemplate()).endSpec();
    }

    public JobBuilder consumerStrimziOauthTls(String clusterName) {
        return (JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarSourceFluent.SecretKeyRefNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarSourceFluent.SecretKeyRefNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarSourceFluent.SecretKeyRefNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)this.defaultConsumerStrimziOauth().editSpec().editTemplate().editSpec().editFirstContainer().addNewEnv().withName("OAUTH_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM")).withValue("")).endEnv()).addNewEnv().withName("CA_CRT")).withNewValueFrom().withNewSecretKeyRef().withName(KafkaResources.clusterCaCertificateSecretName((String)clusterName))).withKey("ca.crt")).endSecretKeyRef()).endValueFrom()).endEnv()).addNewEnv().withName("USER_CRT")).withNewValueFrom().withNewSecretKeyRef().withName(this.userName)).withKey("user.crt")).endSecretKeyRef()).endValueFrom()).endEnv()).addNewEnv().withName("USER_KEY")).withNewValueFrom().withNewSecretKeyRef().withName(this.userName)).withKey("user.key")).endSecretKeyRef()).endValueFrom()).endEnv()).endContainer()).endSpec()).endTemplate()).endSpec();
    }

    public static class Builder
    extends KafkaBasicExampleClients.Builder {
        private String oauthClientId;
        private String oauthClientSecret;
        private String oauthTokenEndpointUri;
        private String userName;

        public Builder withOAuthClientId(String oauthClientId) {
            this.oauthClientId = oauthClientId;
            return this;
        }

        public Builder withOAuthClientSecret(String oauthClientSecret) {
            this.oauthClientSecret = oauthClientSecret;
            return this;
        }

        public Builder withOAuthTokenEndpointUri(String oauthTokenEndpointUri) {
            this.oauthTokenEndpointUri = oauthTokenEndpointUri;
            return this;
        }

        public Builder withUserName(String userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public Builder withProducerName(String producerName) {
            return (Builder)super.withProducerName(producerName);
        }

        @Override
        public Builder withConsumerName(String consumerName) {
            return (Builder)super.withConsumerName(consumerName);
        }

        @Override
        public Builder withBootstrapAddress(String bootstrapAddress) {
            return (Builder)super.withBootstrapAddress(bootstrapAddress);
        }

        @Override
        public Builder withTopicName(String topicName) {
            return (Builder)super.withTopicName(topicName);
        }

        @Override
        public Builder withMessageCount(int messageCount) {
            return (Builder)super.withMessageCount(messageCount);
        }

        @Override
        public Builder withAdditionalConfig(String additionalConfig) {
            return (Builder)super.withAdditionalConfig(additionalConfig);
        }

        @Override
        public Builder withConsumerGroup(String consumerGroup) {
            return (Builder)super.withConsumerGroup(consumerGroup);
        }

        @Override
        public Builder withDelayMs(long delayMs) {
            return (Builder)super.withDelayMs(delayMs);
        }

        @Override
        public KafkaOauthExampleClients build() {
            return new KafkaOauthExampleClients(this);
        }
    }
}

