/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd.kafkaclients;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.strimzi.systemtest.resources.KubernetesResource;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.crd.kafkaclients.KafkaBasicExampleClients;
import java.util.HashMap;

public class KafkaTracingExampleClients
extends KafkaBasicExampleClients {
    private static final String JAEGER_AGENT_HOST = "my-jaeger-agent";
    private static final String JAEGER_SAMPLER_TYPE = "const";
    private static final String JAEGER_SAMPLER_PARAM = "1";
    private final String jaegerServiceProducerName;
    private final String jaegerServiceConsumerName;
    private final String jaegerServiceStreamsName;

    public String getJaegerServiceConsumerName() {
        return this.jaegerServiceConsumerName;
    }

    public String getJaegerServiceProducerName() {
        return this.jaegerServiceProducerName;
    }

    public String getJaegerServiceStreamsName() {
        return this.jaegerServiceStreamsName;
    }

    @Override
    protected Builder newBuilder() {
        return new Builder();
    }

    protected Builder updateBuilder(Builder builder) {
        super.updateBuilder(builder);
        return builder.withJaegerServiceProducerName(this.getJaegerServiceProducerName()).withJaegerServiceConsumerName(this.getJaegerServiceConsumerName()).withJaegerServiceStreamsName(this.getJaegerServiceStreamsName());
    }

    @Override
    public Builder toBuilder() {
        return this.updateBuilder(this.newBuilder());
    }

    public KafkaTracingExampleClients(Builder builder) {
        super(builder);
        this.jaegerServiceProducerName = builder.jaegerServiceProducerName;
        this.jaegerServiceConsumerName = builder.jaegerServiceConsumerName;
        this.jaegerServiceStreamsName = builder.jaegerServiceStreamsName;
    }

    public DeploymentBuilder consumerWithTracing() {
        String consumerName = "hello-world-consumer";
        HashMap<String, String> consumerLabels = new HashMap<String, String>();
        consumerLabels.put("app", consumerName);
        return (DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withNamespace(ResourceManager.kubeClient().getNamespace())).withLabels(consumerLabels)).withName(consumerName)).endMetadata()).withNewSpec().withNewSelector().withMatchLabels(consumerLabels)).endSelector()).withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().withLabels(consumerLabels)).endMetadata()).withNewSpec().withContainers(new Container[0])).addNewContainer().withName(consumerName)).withImage("quay.io/strimzi-examples/java-kafka-consumer:latest")).addNewEnv().withName("BOOTSTRAP_SERVERS")).withValue(this.bootstrapAddress)).endEnv()).addNewEnv().withName("TOPIC")).withValue(this.topicName)).endEnv()).addNewEnv().withName("GROUP_ID")).withValue("my-" + consumerName)).endEnv()).addNewEnv().withName("DELAY_MS")).withValue("1000")).endEnv()).addNewEnv().withName("LOG_LEVEL")).withValue("INFO")).endEnv()).addNewEnv().withName("MESSAGE_COUNT")).withValue(String.valueOf(this.messageCount))).endEnv()).addNewEnv().withName("JAEGER_SERVICE_NAME")).withValue(this.jaegerServiceConsumerName)).endEnv()).addNewEnv().withName("JAEGER_AGENT_HOST")).withValue(JAEGER_AGENT_HOST)).endEnv()).addNewEnv().withName("JAEGER_SAMPLER_TYPE")).withValue(JAEGER_SAMPLER_TYPE)).endEnv()).addNewEnv().withName("JAEGER_SAMPLER_PARAM")).withValue(JAEGER_SAMPLER_PARAM)).endEnv()).endContainer()).endSpec()).endTemplate()).endSpec();
    }

    public DeploymentBuilder producerWithTracing() {
        String producerName = "hello-world-producer";
        HashMap<String, String> producerLabels = new HashMap<String, String>();
        producerLabels.put("app", producerName);
        return (DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withNamespace(ResourceManager.kubeClient().getNamespace())).withLabels(producerLabels)).withName(producerName)).endMetadata()).withNewSpec().withNewSelector().withMatchLabels(producerLabels)).endSelector()).withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().withLabels(producerLabels)).endMetadata()).withNewSpec().withContainers(new Container[0])).addNewContainer().withName(producerName)).withImage("quay.io/strimzi-examples/java-kafka-producer:latest")).addNewEnv().withName("BOOTSTRAP_SERVERS")).withValue(this.bootstrapAddress)).endEnv()).addNewEnv().withName("TOPIC")).withValue("my-topic")).endEnv()).addNewEnv().withName("DELAY_MS")).withValue("1000")).endEnv()).addNewEnv().withName("LOG_LEVEL")).withValue("INFO")).endEnv()).addNewEnv().withName("MESSAGE_COUNT")).withValue(String.valueOf(this.messageCount))).endEnv()).addNewEnv().withName("JAEGER_SERVICE_NAME")).withValue(this.jaegerServiceProducerName)).endEnv()).addNewEnv().withName("JAEGER_AGENT_HOST")).withValue(JAEGER_AGENT_HOST)).endEnv()).addNewEnv().withName("JAEGER_SAMPLER_TYPE")).withValue(JAEGER_SAMPLER_TYPE)).endEnv()).addNewEnv().withName("JAEGER_SAMPLER_PARAM")).withValue(JAEGER_SAMPLER_PARAM)).endEnv()).endContainer()).endSpec()).endTemplate()).endSpec();
    }

    public DeploymentBuilder kafkaStreamsWithTracing() {
        String kafkaStreamsName = "hello-world-streams";
        HashMap<String, String> kafkaStreamLabels = new HashMap<String, String>();
        kafkaStreamLabels.put("app", kafkaStreamsName);
        return (DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withNamespace(ResourceManager.kubeClient().getNamespace())).withLabels(kafkaStreamLabels)).withName(kafkaStreamsName)).endMetadata()).withNewSpec().withNewSelector().withMatchLabels(kafkaStreamLabels)).endSelector()).withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().withLabels(kafkaStreamLabels)).endMetadata()).withNewSpec().withContainers(new Container[0])).addNewContainer().withName(kafkaStreamsName)).withImage("quay.io/strimzi-examples/java-kafka-streams:latest")).addNewEnv().withName("BOOTSTRAP_SERVERS")).withValue(this.bootstrapAddress)).endEnv()).addNewEnv().withName("APPLICATION_ID")).withValue(kafkaStreamsName)).endEnv()).addNewEnv().withName("SOURCE_TOPIC")).withValue("my-topic")).endEnv()).addNewEnv().withName("TARGET_TOPIC")).withValue("cipot-ym")).endEnv()).addNewEnv().withName("LOG_LEVEL")).withValue("INFO")).endEnv()).addNewEnv().withName("JAEGER_SERVICE_NAME")).withValue(this.jaegerServiceStreamsName)).endEnv()).addNewEnv().withName("JAEGER_AGENT_HOST")).withValue(JAEGER_AGENT_HOST)).endEnv()).addNewEnv().withName("JAEGER_SAMPLER_TYPE")).withValue(JAEGER_SAMPLER_TYPE)).endEnv()).addNewEnv().withName("JAEGER_SAMPLER_PARAM")).withValue(JAEGER_SAMPLER_PARAM)).endEnv()).endContainer()).endSpec()).endTemplate()).endSpec();
    }

    public Deployment createAndWaitForReadiness(Deployment deployment) {
        return KubernetesResource.deployNewDeployment(deployment);
    }

    public static class Builder
    extends KafkaBasicExampleClients.Builder {
        private String jaegerServiceProducerName;
        private String jaegerServiceConsumerName;
        private String jaegerServiceStreamsName;

        public Builder withJaegerServiceProducerName(String jaegerServiceProducerName) {
            this.jaegerServiceProducerName = jaegerServiceProducerName;
            return this;
        }

        public Builder withJaegerServiceConsumerName(String jaegerServiceConsumerName) {
            this.jaegerServiceConsumerName = jaegerServiceConsumerName;
            return this;
        }

        public Builder withJaegerServiceStreamsName(String jaegerServiceStreamsName) {
            this.jaegerServiceStreamsName = jaegerServiceStreamsName;
            return this;
        }

        @Override
        public Builder withProducerName(String producerName) {
            return (Builder)super.withProducerName(producerName);
        }

        @Override
        public Builder withConsumerName(String consumerName) {
            return (Builder)super.withConsumerName(consumerName);
        }

        @Override
        public Builder withBootstrapAddress(String bootstrapAddress) {
            return (Builder)super.withBootstrapAddress(bootstrapAddress);
        }

        @Override
        public Builder withTopicName(String topicName) {
            return (Builder)super.withTopicName(topicName);
        }

        @Override
        public Builder withMessageCount(int messageCount) {
            return (Builder)super.withMessageCount(messageCount);
        }

        @Override
        public Builder withAdditionalConfig(String additionalConfig) {
            return (Builder)super.withAdditionalConfig(additionalConfig);
        }

        @Override
        public Builder withConsumerGroup(String consumerGroup) {
            return (Builder)super.withConsumerGroup(consumerGroup);
        }

        @Override
        public Builder withDelayMs(long delayMs) {
            return (Builder)super.withDelayMs(delayMs);
        }

        @Override
        public KafkaTracingExampleClients build() {
            return new KafkaTracingExampleClients(this);
        }
    }
}

