/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.test.TestUtils;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpUtils {
    private static final Logger LOGGER = LogManager.getLogger(HttpUtils.class);
    private static final long READINESS_TIMEOUT = ResourceOperation.getTimeoutForResourceReadiness("Service");

    private HttpUtils() {
    }

    public static void waitUntilServiceWithNameIsReady(String baserURI, String serviceName) {
        LOGGER.info("Wait until Service name {} is present in json", (Object)serviceName);
        TestUtils.waitFor((String)("Service name " + serviceName + " is present in json"), (long)Constants.GLOBAL_TRACING_POLL, (long)READINESS_TIMEOUT, () -> {
            Response response = (Response)RestAssured.given().when().baseUri(baserURI).relaxedHTTPSValidation().contentType("application/json").get("/jaeger/api/services", new Object[0]);
            return response.body().peek().print().contains(serviceName);
        });
        LOGGER.info("Service name {} is present", (Object)serviceName);
    }

    public static void waitUntilServiceWithNameIsReady(String baserURI, String ... serviceNames) {
        for (String serviceName : serviceNames) {
            HttpUtils.waitUntilServiceWithNameIsReady(baserURI, serviceName);
        }
    }

    public static void waitUntilServiceHasSomeTraces(String baseURI, String serviceName) {
        LOGGER.info("Wait untill Service {} has some traces", (Object)serviceName);
        TestUtils.waitFor((String)("Service " + serviceName + " has some traces"), (long)Constants.GLOBAL_TRACING_POLL, (long)READINESS_TIMEOUT, () -> {
            Response response = (Response)RestAssured.given().when().baseUri(baseURI).relaxedHTTPSValidation().contentType("application/json").get("/jaeger/api/traces?service=" + serviceName, new Object[0]);
            JsonPath jsonPathValidator = response.jsonPath();
            Map data = jsonPathValidator.getMap("$");
            return data.size() > 0;
        });
        LOGGER.info("Service {} has traces", (Object)serviceName);
    }

    public static void waitUntilServiceHasSomeTraces(String baseURI, String ... serviceNames) {
        for (String serviceName : serviceNames) {
            HttpUtils.waitUntilServiceHasSomeTraces(baseURI, serviceName);
        }
    }
}

