/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.strimzi.api.kafka.model.ContainerEnvVar;
import io.strimzi.api.kafka.model.ContainerEnvVarBuilder;
import io.strimzi.systemtest.Environment;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.k8s.KubeClusterResource;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StUtils {
    private static final Logger LOGGER = LogManager.getLogger(StUtils.class);
    private static final Pattern KAFKA_COMPONENT_PATTERN = Pattern.compile("([^-|^_]*?)(?<kafka>[-|_]kafka[-|_])(?<version>.*)$");
    private static final Pattern IMAGE_PATTERN_FULL_PATH = Pattern.compile("^(?<registry>[^/]*)/(?<org>[^/]*)/(?<image>[^:]*):(?<tag>.*)$");
    private static final Pattern IMAGE_PATTERN = Pattern.compile("^(?<org>[^/]*)/(?<image>[^:]*):(?<tag>.*)$");
    private static final Pattern VERSION_IMAGE_PATTERN = Pattern.compile("(?<version>[0-9.]+)=(?<image>[^\\s]*)");
    private static final Pattern BETWEEN_JSON_OBJECTS_PATTERN = Pattern.compile("}[\\n\\r]+\\{");
    private static final Pattern ALL_BEFORE_JSON_PATTERN = Pattern.compile("(.*\\s)}, \\{", 32);

    private StUtils() {
    }

    public static boolean isAllowOnCurrentEnvironment(String envVariableForCheck) {
        return System.getenv().get(envVariableForCheck) == null;
    }

    public static String changeOrgAndTag(String image) {
        Matcher m = IMAGE_PATTERN_FULL_PATH.matcher(image);
        if (m.find()) {
            String registry = StUtils.setImageProperties(m.group("registry"), Environment.STRIMZI_REGISTRY, "quay.io");
            String org = StUtils.setImageProperties(m.group("org"), Environment.STRIMZI_ORG, "strimzi");
            return registry + "/" + org + "/" + m.group("image") + ":" + StUtils.buildTag(m.group("tag"));
        }
        m = IMAGE_PATTERN.matcher(image);
        if (m.find()) {
            String org = StUtils.setImageProperties(m.group("org"), Environment.STRIMZI_ORG, "strimzi");
            return Environment.STRIMZI_REGISTRY + "/" + org + "/" + m.group("image") + ":" + StUtils.buildTag(m.group("tag"));
        }
        return image;
    }

    public static String changeOrgAndTagInImageMap(String imageMap) {
        Matcher m = VERSION_IMAGE_PATTERN.matcher(imageMap);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group("version") + "=" + StUtils.changeOrgAndTag(m.group("image")));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String setImageProperties(String current, String envVar, String defaultEnvVar) {
        if (!envVar.equals(defaultEnvVar) && !current.equals(envVar)) {
            return envVar;
        }
        return current;
    }

    private static String buildTag(String currentTag) {
        if (!((String)currentTag).equals(Environment.STRIMZI_TAG) && !"latest".equals(Environment.STRIMZI_TAG)) {
            Matcher t = KAFKA_COMPONENT_PATTERN.matcher((CharSequence)currentTag);
            currentTag = t.find() ? Environment.STRIMZI_TAG + t.group("kafka") + t.group("version") : Environment.STRIMZI_TAG;
        }
        return currentTag;
    }

    public static List<ContainerEnvVar> createContainerEnvVarsFromMap(Map<String, String> envVars) {
        ArrayList<ContainerEnvVar> testEnvs = new ArrayList<ContainerEnvVar>();
        for (Map.Entry<String, String> entry : envVars.entrySet()) {
            testEnvs.add(((ContainerEnvVarBuilder)((ContainerEnvVarBuilder)new ContainerEnvVarBuilder().withName(entry.getKey())).withValue(entry.getValue())).build());
        }
        return testEnvs;
    }

    public static String checkEnvVarInPod(String podName, String envVarName) {
        return ((Container)KubeClusterResource.kubeClient().getPod(podName).getSpec().getContainers().get(0)).getEnv().stream().filter(envVar -> envVar.getName().equals(envVarName)).findFirst().get().getValue();
    }

    public static Map<String, Object> loadProperties(String keyValuePairs) {
        try {
            Properties actual = new Properties();
            actual.load(new StringReader(keyValuePairs));
            return actual;
        }
        catch (IOException e) {
            throw new AssertionError("Invalid Properties definition", e);
        }
    }

    public static Map<String, Object> getPropertiesFromJson(int containerIndex, String json, String envVar) {
        List array = (List)JsonPath.parse((String)json).read(StUtils.globalVariableJsonPathBuilder(containerIndex, envVar), new Predicate[0]);
        return StUtils.loadProperties((String)array.get(0));
    }

    public static String globalVariableJsonPathBuilder(int containerIndex, String envVar) {
        return "$.spec.containers[" + containerIndex + "].env[?(@.name=='" + envVar + "')].value";
    }

    public static Properties stringToProperties(String str) {
        Properties result = new Properties();
        List<String> list = StUtils.getLinesWithoutCommentsAndEmptyLines(str);
        for (String line : list) {
            String[] split = line.split("=");
            result.put(split[0], split.length == 1 ? "" : split[1]);
        }
        return result;
    }

    public static Properties configMap2Properties(ConfigMap cm) {
        return StUtils.stringToProperties((String)cm.getData().get("server.config"));
    }

    public static List<String> getLinesWithoutCommentsAndEmptyLines(String config) {
        List<String> allLines = Arrays.asList(config.split("\\r?\\n"));
        ArrayList<String> validLines = new ArrayList<String>();
        for (String line : allLines) {
            if (line.replace(" ", "").startsWith("#") || line.isEmpty()) continue;
            validLines.add(line.replace(" ", ""));
        }
        return validLines;
    }

    public static JsonArray expectedServiceDiscoveryInfo(int port, String protocol, String auth, boolean tls) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("port", Integer.valueOf(port));
        jsonObject.put("tls", Boolean.valueOf(tls));
        jsonObject.put("protocol", protocol);
        jsonObject.put("auth", auth);
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(jsonObject);
        return jsonArray;
    }

    public static JsonArray expectedServiceDiscoveryInfo(String plainEcryption, String tlsEncryption, boolean plainTlsAuth, boolean tlsTlsAuth) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(StUtils.expectedServiceDiscoveryInfo(9092, "kafka", plainEcryption, plainTlsAuth).getValue(0));
        jsonArray.add(StUtils.expectedServiceDiscoveryInfo(9093, "kafka", tlsEncryption, tlsTlsAuth).getValue(0));
        return jsonArray;
    }

    public static boolean checkLogForJSONFormat(Map<String, String> pods, String containerName) {
        boolean isJSON = false;
        String tail = "--tail=" + (containerName.contains("operator") ? "50" : "10");
        for (String podName : pods.keySet()) {
            Object log = ResourceManager.cmdKubeClient().execInCurrentNamespace(false, new String[]{"logs", podName, "-c", containerName, tail}).out();
            int lastBracket = ((String)log).lastIndexOf("}");
            int firstBracket = ((String)log).indexOf("{");
            if (((String)log).length() >= lastBracket) {
                log = ((String)log).substring(Math.max(0, firstBracket), lastBracket + 1);
            }
            Matcher matcher = BETWEEN_JSON_OBJECTS_PATTERN.matcher((CharSequence)log);
            log = matcher.replaceAll("}, \\{");
            matcher = ALL_BEFORE_JSON_PATTERN.matcher((CharSequence)log);
            log = "[" + matcher.replaceFirst("{") + "]";
            try {
                new JsonArray((String)log);
                LOGGER.info("JSON format logging successfully set for {} - {}", (Object)podName, (Object)containerName);
                isJSON = true;
            }
            catch (Exception e) {
                LOGGER.info((String)log);
                LOGGER.info("Failed to set JSON format logging for {} - {}", (Object)podName, (Object)containerName, (Object)e);
                isJSON = false;
                break;
            }
        }
        return isJSON;
    }

    public static boolean isAllowedOnCurrentK8sVersion(String maxKubernetesVersion) {
        if (maxKubernetesVersion.equals("latest")) {
            return true;
        }
        return Double.parseDouble(KubeClusterResource.kubeClient().clusterKubernetesVersion()) < Double.parseDouble(maxKubernetesVersion);
    }

    public static String getLogFromPodByTime(String podName, String containerName, String timeSince) {
        return ResourceManager.cmdKubeClient().execInCurrentNamespace(new String[]{"logs", podName, "-c", containerName, "--since=" + timeSince}).out();
    }

    public static String changeDeploymentNamespace(File deploymentFile, String namespace) {
        YAMLMapper mapper = new YAMLMapper();
        try {
            JsonNode node = mapper.readTree(deploymentFile);
            ObjectNode containerNode = (ObjectNode)node.at("/spec/template/spec/containers").get(0);
            for (JsonNode envVar : containerNode.get("env")) {
                String varName = envVar.get("name").textValue();
                if (varName.matches("STRIMZI_NAMESPACE")) {
                    ((ObjectNode)envVar).remove("valueFrom");
                    ((ObjectNode)envVar).put("value", namespace);
                }
                if (!varName.matches("STRIMZI_LOG_LEVEL")) continue;
                ((ObjectNode)envVar).put("value", Environment.STRIMZI_LOG_LEVEL);
            }
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode imagePulPolicyEnvVar = objectMapper.createObjectNode();
            imagePulPolicyEnvVar.put("name", "STRIMZI_IMAGE_PULL_POLICY");
            imagePulPolicyEnvVar.put("value", Environment.COMPONENTS_IMAGE_PULL_POLICY);
            ((ArrayNode)containerNode.get("env")).add((JsonNode)imagePulPolicyEnvVar);
            return mapper.writeValueAsString((Object)node);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

