/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TestKafkaVersion
implements Comparable<TestKafkaVersion> {
    private static List<TestKafkaVersion> kafkaVersions;
    @JsonProperty(value="version")
    String version;
    @JsonProperty(value="protocol")
    String protocolVersion;
    @JsonProperty(value="format")
    String messageVersion;
    @JsonProperty(value="zookeeper")
    String zookeeperVersion;
    @JsonProperty(value="default")
    boolean isDefault;
    @JsonProperty(value="supported")
    boolean isSupported;

    public String toString() {
        return "KafkaVersion{version='" + this.version + "', protocolVersion='" + this.protocolVersion + "', messageVersion='" + this.messageVersion + "', zookeeperVersion='" + this.zookeeperVersion + "', isDefault=" + this.isDefault + ", isSupported=" + this.isSupported + "}";
    }

    public String version() {
        return this.version;
    }

    public String protocolVersion() {
        return this.protocolVersion;
    }

    public String messageVersion() {
        return this.messageVersion;
    }

    public String zookeeperVersion() {
        return this.zookeeperVersion;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    @Override
    public int compareTo(TestKafkaVersion o) {
        return this.compareDottedVersions(this.version, o.version);
    }

    public int compareDottedVersions(String version1, String version2) {
        String[] components = version1.split("\\.");
        String[] otherComponents = version2.split("\\.");
        for (int i = 0; i < Math.min(components.length, otherComponents.length); ++i) {
            int y;
            int x = Integer.parseInt(components[i]);
            if (x == (y = Integer.parseInt(otherComponents[i]))) continue;
            if (x < y) {
                return -1;
            }
            return 1;
        }
        return components.length - otherComponents.length;
    }

    public boolean isUpgrade(TestKafkaVersion version) {
        return this.compareTo(version) < 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestKafkaVersion that = (TestKafkaVersion)o;
        return this.version.equals(that.version);
    }

    private static List<TestKafkaVersion> parseKafkaVersions() throws IOException {
        YAMLMapper mapper = new YAMLMapper();
        InputStreamReader versionsFileReader = new InputStreamReader(TestKafkaVersion.class.getResourceAsStream("/kafka-versions.yaml"), StandardCharsets.UTF_8);
        List kafkaVersions = (List)mapper.readValue((Reader)versionsFileReader, (TypeReference)new TypeReference<List<TestKafkaVersion>>(){});
        List<TestKafkaVersion> supportedKafkaVersions = kafkaVersions.stream().filter(TestKafkaVersion::isSupported).collect(Collectors.toList());
        Collections.sort(supportedKafkaVersions);
        return supportedKafkaVersions;
    }

    public static List<TestKafkaVersion> getKafkaVersions() {
        return kafkaVersions;
    }

    public static Map<String, TestKafkaVersion> getKafkaVersionsInMap() {
        return kafkaVersions.stream().collect(Collectors.toMap(TestKafkaVersion::version, i -> i));
    }

    static {
        try {
            kafkaVersions = TestKafkaVersion.parseKafkaVersions();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

