/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kafkaUtils;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.strimzi.api.kafka.model.KafkaBridge;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.KubernetesResource;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.crd.KafkaBridgeResource;
import io.strimzi.test.k8s.KubeClusterResource;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class KafkaBridgeUtils {
    private static final Logger LOGGER = LogManager.getLogger(KafkaBridgeUtils.class);

    private KafkaBridgeUtils() {
    }

    public static int getBridgeNodePort(String namespace, String bridgeExternalService) {
        Service extBootstrapService = (Service)((ServiceResource)((NonNamespaceOperation)KubeClusterResource.kubeClient((String)namespace).getClient().services().inNamespace(namespace)).withName(bridgeExternalService)).get();
        return ((ServicePort)extBootstrapService.getSpec().getPorts().get(0)).getNodePort();
    }

    public static Service createBridgeNodePortService(String clusterName, String namespace, String serviceName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("strimzi.io/cluster", clusterName);
        map.put("strimzi.io/kind", "KafkaBridge");
        map.put("strimzi.io/name", clusterName + "-bridge");
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)KubernetesResource.getSystemtestsServiceResource(serviceName, 8080, namespace, "TCP").editSpec().withType("NodePort")).withSelector(map)).endSpec()).build();
    }

    public static void checkSendResponse(JsonObject response, int messageCount) {
        JsonArray offsets = response.getJsonArray("offsets");
        MatcherAssert.assertThat((Object)offsets.size(), (Matcher)CoreMatchers.is((Object)messageCount));
        for (int i = 0; i < messageCount; ++i) {
            JsonObject metadata = offsets.getJsonObject(i);
            MatcherAssert.assertThat((Object)metadata.getInteger("partition"), (Matcher)CoreMatchers.is((Object)0));
            MatcherAssert.assertThat((Object)metadata.getInteger("offset"), (Matcher)CoreMatchers.is((Object)i));
            LOGGER.debug("offset size: {}, partition: {}, offset size: {}", (Object)offsets.size(), (Object)metadata.getInteger("partition"), (Object)metadata.getLong("offset"));
        }
    }

    public static void waitForKafkaBridgeStatus(String clusterName, Enum<?> state) {
        KafkaBridge kafkaBridge = (KafkaBridge)((Resource)((NonNamespaceOperation)KafkaBridgeResource.kafkaBridgeClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(clusterName)).get();
        ResourceManager.waitForResourceStatus(KafkaBridgeResource.kafkaBridgeClient(), kafkaBridge, state);
    }

    public static void waitForKafkaBridgeReady(String clusterName) {
        KafkaBridgeUtils.waitForKafkaBridgeStatus(clusterName, CustomResourceStatus.Ready);
    }

    public static void waitForKafkaBridgeNotReady(String clusterName) {
        KafkaBridgeUtils.waitForKafkaBridgeStatus(clusterName, CustomResourceStatus.NotReady);
    }
}

