/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kafkaUtils;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnectResources;
import io.strimzi.api.kafka.model.status.Condition;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.kafkaclients.internalClients.InternalKafkaClient;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.crd.KafkaConnectResource;
import io.strimzi.systemtest.utils.kafkaUtils.KafkaConnectorUtils;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaConnectUtils {
    private static final Logger LOGGER = LogManager.getLogger(KafkaConnectUtils.class);

    private KafkaConnectUtils() {
    }

    public static void waitForConnectStatus(String clusterName, Enum<?> status) {
        KafkaConnect kafkaConnect = (KafkaConnect)((Resource)((NonNamespaceOperation)KafkaConnectResource.kafkaConnectClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(clusterName)).get();
        ResourceManager.waitForResourceStatus(KafkaConnectResource.kafkaConnectClient(), kafkaConnect, status);
    }

    public static void waitForConnectReady(String clusterName) {
        KafkaConnectUtils.waitForConnectStatus(clusterName, CustomResourceStatus.Ready);
    }

    public static void waitForConnectNotReady(String clusterName) {
        KafkaConnectUtils.waitForConnectStatus(clusterName, CustomResourceStatus.NotReady);
    }

    public static void waitUntilKafkaConnectRestApiIsAvailable(String podNamePrefix) {
        LOGGER.info("Waiting until KafkaConnect API is available");
        TestUtils.waitFor((String)"Waiting until KafkaConnect API is available", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_STATUS_TIMEOUT, () -> KubeClusterResource.cmdKubeClient().execInPod(podNamePrefix, new String[]{"/bin/bash", "-c", "curl -I http://localhost:8083/connectors"}).out().contains("HTTP/1.1 200 OK\n"));
        LOGGER.info("KafkaConnect API is available");
    }

    public static void waitForMessagesInKafkaConnectFileSink(String kafkaConnectPodName, String sinkFileName, String message) {
        LOGGER.info("Waiting for messages in file sink on {}", (Object)kafkaConnectPodName);
        TestUtils.waitFor((String)"messages in file sink", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.TIMEOUT_FOR_SEND_RECEIVE_MSG, () -> KubeClusterResource.cmdKubeClient().execInPod(kafkaConnectPodName, new String[]{"/bin/bash", "-c", "cat " + sinkFileName}).out().contains(message));
        LOGGER.info("Expected messages are in file sink on {}", (Object)kafkaConnectPodName);
    }

    public static void waitForMessagesInKafkaConnectFileSink(String kafkaConnectPodName, String sinkFileName) {
        KafkaConnectUtils.waitForMessagesInKafkaConnectFileSink(kafkaConnectPodName, sinkFileName, "\"Hello-world - 99\"");
    }

    public static void waitForKafkaConnectConfigChange(String propertyKey, String propertyValue, String namespace, String clusterName) {
        LOGGER.info("Waiting for Kafka Connect property {} -> {} change", (Object)propertyKey, (Object)propertyValue);
        TestUtils.waitFor((String)("Waiting for Kafka Connect config " + propertyKey + " -> " + propertyValue), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> {
            String propertyValueFromKafkaConnect = (String)((KafkaConnect)((Resource)((NonNamespaceOperation)KafkaConnectResource.kafkaConnectClient().inNamespace(namespace)).withName(clusterName)).get()).getSpec().getConfig().get(propertyKey);
            LOGGER.debug("Property key -> {}, Current property value -> {}", (Object)propertyKey, (Object)propertyValueFromKafkaConnect);
            LOGGER.debug(propertyValueFromKafkaConnect + " == " + propertyValue);
            return propertyValueFromKafkaConnect.equals(propertyValue);
        });
        LOGGER.info("Kafka Connect property {} -> {} change", (Object)propertyKey, (Object)propertyValue);
    }

    public static void waitForKafkaConnectCondition(String conditionReason, String conditionType, String namespace, String clusterName) {
        TestUtils.waitFor((String)("Wait for KafkaConnect '" + conditionReason + "' condition with type '" + conditionType + "'."), (long)Constants.GLOBAL_POLL_INTERVAL, (long)(Constants.CO_OPERATION_TIMEOUT_SHORT * 2L), () -> {
            List conditions = ((KafkaConnect)((Resource)((NonNamespaceOperation)KafkaConnectResource.kafkaConnectClient().inNamespace(namespace)).withName(clusterName)).get()).getStatus().getConditions();
            for (Condition condition : conditions) {
                if (!condition.getReason().matches(conditionReason) || !condition.getType().matches(conditionType)) continue;
                return true;
            }
            return false;
        });
    }

    public static void waitUntilKafkaConnectStatusConditionContainsMessage(String clusterName, String namespace, String message) {
        TestUtils.waitFor((String)("KafkaConnect Status with message [" + message + "]"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> {
            List conditions = ((KafkaConnect)((Resource)((NonNamespaceOperation)KafkaConnectResource.kafkaConnectClient().inNamespace(namespace)).withName(clusterName)).get()).getStatus().getConditions();
            for (Condition condition : conditions) {
                if (!condition.getMessage().matches(message)) continue;
                return true;
            }
            return false;
        });
    }

    public static void sendReceiveMessagesThroughConnect(String connectPodName, String topicName, String kafkaClientsPodName, String namespace, String clusterName) {
        LOGGER.info("Send and receive messages through KafkaConnect");
        KafkaConnectUtils.waitUntilKafkaConnectRestApiIsAvailable(connectPodName);
        KafkaConnectorUtils.createFileSinkConnector(kafkaClientsPodName, topicName, "/tmp/test-file-sink.txt", KafkaConnectResources.url((String)clusterName, (String)namespace, (int)8083));
        InternalKafkaClient internalKafkaClient = ((InternalKafkaClient.Builder)((InternalKafkaClient.Builder)((InternalKafkaClient.Builder)((InternalKafkaClient.Builder)((InternalKafkaClient.Builder)new InternalKafkaClient.Builder().withUsingPodName(kafkaClientsPodName).withTopicName(topicName)).withNamespaceName(namespace)).withClusterName(clusterName)).withMessageCount(100)).withListenerName("plain")).build();
        internalKafkaClient.checkProducedAndConsumedMessages(internalKafkaClient.sendMessagesPlain(), internalKafkaClient.receiveMessagesPlain());
        KafkaConnectUtils.waitForMessagesInKafkaConnectFileSink(connectPodName, "/tmp/test-file-sink.txt", "99");
    }
}

