/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kafkaUtils;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.KafkaTopicList;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.api.kafka.model.status.Condition;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.cli.KafkaCmdClient;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.systemtest.resources.crd.KafkaTopicResource;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaTopicUtils {
    private static final Logger LOGGER = LogManager.getLogger(KafkaTopicUtils.class);
    private static final String TOPIC_NAME_PREFIX = "my-topic-";
    private static final long READINESS_TIMEOUT = ResourceOperation.getTimeoutForResourceReadiness("KafkaTopic");
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    private KafkaTopicUtils() {
    }

    public static String generateRandomNameOfTopic() {
        String salt = new Random().nextInt(Integer.MAX_VALUE) + "-" + new Random().nextInt(Integer.MAX_VALUE);
        return TOPIC_NAME_PREFIX + salt;
    }

    public static String topicSnapshot(String topicName) {
        return ((KafkaTopic)((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(topicName)).get()).getMetadata().getUid();
    }

    public static String waitTopicHasRolled(String topicName, String topicUid) {
        TestUtils.waitFor((String)("Topic " + topicName + " has rolled"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> !topicUid.equals(KafkaTopicUtils.topicSnapshot(topicName)));
        return KafkaTopicUtils.topicSnapshot(topicName);
    }

    public static void waitForKafkaTopicCreation(String topicName) {
        LOGGER.info("Waiting for KafkaTopic {} creation ", (Object)topicName);
        TestUtils.waitFor((String)("KafkaTopic creation " + topicName), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)READINESS_TIMEOUT, () -> ((Condition)((KafkaTopic)((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(topicName)).get()).getStatus().getConditions().get(0)).getType().equals(CustomResourceStatus.Ready.toString()), () -> LOGGER.info(((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(topicName)).get()));
    }

    public static void waitForKafkaTopicCreationByNamePrefix(String topicNamePrefix) {
        LOGGER.info("Waiting for KafkaTopic {} creation", (Object)topicNamePrefix);
        TestUtils.waitFor((String)("KafkaTopic creation " + topicNamePrefix), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)READINESS_TIMEOUT, () -> ((Condition)((KafkaTopicList)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).list()).getItems().stream().filter(topic -> topic.getMetadata().getName().contains(topicNamePrefix)).findFirst().get().getStatus().getConditions().get(0)).getType().equals(CustomResourceStatus.Ready.toString()));
    }

    public static void waitForKafkaTopicDeletion(String topicName) {
        LOGGER.info("Waiting for KafkaTopic {} deletion", (Object)topicName);
        TestUtils.waitFor((String)("KafkaTopic deletion " + topicName), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)DELETION_TIMEOUT, () -> {
            if (((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(topicName)).get() == null) {
                return true;
            }
            LOGGER.warn("KafkaTopic {} is not deleted yet! Triggering force delete by cmd client!", (Object)topicName);
            KubeClusterResource.cmdKubeClient().deleteByName("KafkaTopic", topicName);
            return false;
        }, () -> LOGGER.info(((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(topicName)).get()));
    }

    public static void waitForKafkaTopicPartitionChange(String topicName, int partitions) {
        LOGGER.info("Waiting for KafkaTopic change {}", (Object)topicName);
        TestUtils.waitFor((String)("KafkaTopic change " + topicName), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)Constants.GLOBAL_TIMEOUT, () -> ((KafkaTopic)((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(topicName)).get()).getSpec().getPartitions() == partitions, () -> LOGGER.info(((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(topicName)).get()));
    }

    public static void waitForKafkaTopicStatus(String topicName, Enum<?> state) {
        KafkaTopic kafkaTopic = (KafkaTopic)((Resource)((NonNamespaceOperation)KafkaTopicResource.kafkaTopicClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(topicName)).get();
        ResourceManager.waitForResourceStatus(KafkaTopicResource.kafkaTopicClient(), kafkaTopic, state);
    }

    public static void waitForKafkaTopicReady(String topicName) {
        KafkaTopicUtils.waitForKafkaTopicStatus(topicName, CustomResourceStatus.Ready);
    }

    public static void waitForKafkaTopicNotReady(String topicName) {
        KafkaTopicUtils.waitForKafkaTopicStatus(topicName, CustomResourceStatus.NotReady);
    }

    public static void waitForKafkaTopicsCount(int topicCount, String clusterName) {
        LOGGER.info("Wait until we create {} KafkaTopics", (Object)topicCount);
        TestUtils.waitFor((String)(topicCount + " KafkaTopics creation"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> KafkaCmdClient.listTopicsUsingPodCli(clusterName, 0).size() == topicCount);
        LOGGER.info("{} KafkaTopics were created", (Object)topicCount);
    }
}

