/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kafkaUtils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.api.kafka.model.status.Condition;
import io.strimzi.api.kafka.model.status.ListenerStatus;
import io.strimzi.kafka.config.model.ConfigModel;
import io.strimzi.kafka.config.model.ConfigModels;
import io.strimzi.kafka.config.model.Scope;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.systemtest.resources.crd.KafkaResource;
import io.strimzi.systemtest.utils.kubeUtils.controllers.DeploymentUtils;
import io.strimzi.systemtest.utils.kubeUtils.controllers.StatefulSetUtils;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaUtils {
    private static final Logger LOGGER = LogManager.getLogger(KafkaUtils.class);
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    private KafkaUtils() {
    }

    public static void waitForKafkaReady(String clusterName) {
        KafkaUtils.waitForKafkaStatus(clusterName, CustomResourceStatus.Ready);
    }

    public static void waitForKafkaNotReady(String clusterName) {
        KafkaUtils.waitForKafkaStatus(clusterName, CustomResourceStatus.NotReady);
    }

    public static void waitForKafkaStatus(String clusterName, Enum<?> state) {
        Kafka kafka = (Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(clusterName)).get();
        ResourceManager.waitForResourceStatus(KafkaResource.kafkaClient(), kafka, state);
    }

    public static void waitForKafkaStatusUpdate(String clusterName) {
        LOGGER.info("Waiting for Kafka status to be updated");
        TestUtils.waitFor((String)"KafkaStatus update", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_STATUS_TIMEOUT, () -> {
            Kafka k = (Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(clusterName)).get();
            return k.getMetadata().getGeneration().longValue() == k.getStatus().getObservedGeneration();
        });
    }

    public static void waitUntilKafkaStatusConditionContainsMessage(String clusterName, String namespace, String message, long timeout) {
        TestUtils.waitFor((String)("Kafka Status with message [" + message + "]"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)timeout, () -> {
            List conditions = ((Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(namespace)).withName(clusterName)).get()).getStatus().getConditions();
            for (Condition condition : conditions) {
                if (!condition.getMessage().matches(message)) continue;
                return true;
            }
            return false;
        });
    }

    public static void waitUntilKafkaStatusConditionContainsMessage(String clusterName, String namespace, String message) {
        KafkaUtils.waitUntilKafkaStatusConditionContainsMessage(clusterName, namespace, message, Constants.GLOBAL_STATUS_TIMEOUT);
    }

    public static void waitForZkMntr(String clusterName, Pattern pattern, int ... podIndexes) {
        long timeoutMs = 120000L;
        long pollMs = 1000L;
        for (int podIndex : podIndexes) {
            String zookeeperPod = KafkaResources.zookeeperPodName((String)clusterName, (int)podIndex);
            String zookeeperPort = String.valueOf(12181);
            TestUtils.waitFor((String)"mntr", (long)pollMs, (long)timeoutMs, () -> {
                try {
                    String output = KubeClusterResource.cmdKubeClient().execInPod(zookeeperPod, new String[]{"/bin/bash", "-c", "echo mntr | nc localhost " + zookeeperPort}).out();
                    if (pattern.matcher(output).find()) {
                        return true;
                    }
                }
                catch (KubeClusterException e) {
                    LOGGER.trace("Exception while waiting for ZK to become leader/follower, ignoring", (Throwable)e);
                }
                return false;
            }, () -> LOGGER.info("zookeeper `mntr` output at the point of timeout does not match {}:{}{}", (Object)pattern.pattern(), (Object)System.lineSeparator(), (Object)TestUtils.indent((String)KubeClusterResource.cmdKubeClient().execInPod(zookeeperPod, new String[]{"/bin/bash", "-c", "echo mntr | nc localhost " + zookeeperPort}).out())));
        }
    }

    public static String getKafkaStatusCertificates(String listenerType, String namespace, String clusterName) {
        String certs = "";
        List kafkaListeners = ((Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(namespace)).withName(clusterName)).get()).getStatus().getListeners();
        for (ListenerStatus listener : kafkaListeners) {
            if (!listener.getType().equals(listenerType)) continue;
            certs = listener.getCertificates().toString();
        }
        certs = certs.substring(1, certs.length() - 1);
        return certs;
    }

    public static String getKafkaSecretCertificates(String secretName, String certType) {
        String secretCerts = "";
        secretCerts = (String)KubeClusterResource.kubeClient().getSecret(secretName).getData().get(certType);
        byte[] decodedBytes = Base64.getDecoder().decode(secretCerts);
        secretCerts = new String(decodedBytes, Charset.defaultCharset());
        return secretCerts;
    }

    public static void waitForClusterStability(String clusterName) {
        LOGGER.info("Waiting for cluster stability");
        Map[] zkPods = new Map[1];
        Map[] kafkaPods = new Map[1];
        Map[] eoPods = new Map[1];
        int[] count = new int[]{0};
        zkPods[0] = StatefulSetUtils.ssSnapshot(KafkaResources.zookeeperStatefulSetName((String)clusterName));
        kafkaPods[0] = StatefulSetUtils.ssSnapshot(KafkaResources.kafkaStatefulSetName((String)clusterName));
        eoPods[0] = DeploymentUtils.depSnapshot(KafkaResources.entityOperatorDeploymentName((String)clusterName));
        TestUtils.waitFor((String)"Cluster stable and ready", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.TIMEOUT_FOR_CLUSTER_STABLE, () -> {
            Map<String, String> zkSnapshot = StatefulSetUtils.ssSnapshot(KafkaResources.zookeeperStatefulSetName((String)clusterName));
            Map<String, String> kafkaSnaptop = StatefulSetUtils.ssSnapshot(KafkaResources.kafkaStatefulSetName((String)clusterName));
            Map<String, String> eoSnapshot = DeploymentUtils.depSnapshot(KafkaResources.entityOperatorDeploymentName((String)clusterName));
            boolean zkSameAsLast = zkSnapshot.equals(zkPods[0]);
            boolean kafkaSameAsLast = kafkaSnaptop.equals(kafkaPods[0]);
            boolean eoSameAsLast = eoSnapshot.equals(eoPods[0]);
            if (!zkSameAsLast) {
                LOGGER.info("ZK Cluster not stable");
            }
            if (!kafkaSameAsLast) {
                LOGGER.info("Kafka Cluster not stable");
            }
            if (!eoSameAsLast) {
                LOGGER.info("EO not stable");
            }
            if (zkSameAsLast && kafkaSameAsLast && eoSameAsLast) {
                int n = count[0];
                count[0] = n + 1;
                int c = n;
                LOGGER.info("All stable for {} polls", (Object)c);
                return c > 60;
            }
            zkPods[0] = zkSnapshot;
            kafkaPods[0] = kafkaSnaptop;
            count[0] = 0;
            return false;
        });
    }

    public static void updateSpecificConfiguration(String clusterName, String brokerConfigName, Object value) {
        KafkaResource.replaceKafkaResource(clusterName, kafka -> {
            LOGGER.info("Kafka config before updating '{}'", (Object)kafka.getSpec().getKafka().getConfig().toString());
            Map config = kafka.getSpec().getKafka().getConfig();
            config.put(brokerConfigName, value);
            kafka.getSpec().getKafka().setConfig(config);
            LOGGER.info("Kafka config after updating '{}'", (Object)kafka.getSpec().getKafka().getConfig().toString());
        });
    }

    public static void updateConfigurationWithStabilityWait(String clusterName, String brokerConfigName, Object value) {
        KafkaUtils.updateSpecificConfiguration(clusterName, brokerConfigName, value);
        KafkaUtils.waitForClusterStability(clusterName);
    }

    public static boolean verifyCrDynamicConfiguration(String clusterName, String brokerConfigName, Object value) {
        LOGGER.info("Dynamic Configuration in Kafka CR is {}={} and excepted is {}={}", (Object)brokerConfigName, ((Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(clusterName)).get()).getSpec().getKafka().getConfig().get(brokerConfigName), (Object)brokerConfigName, value);
        return ((Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(clusterName)).get()).getSpec().getKafka().getConfig().get(brokerConfigName).equals(value);
    }

    public static boolean verifyPodDynamicConfiguration(String kafkaPodNamePrefix, String brokerConfigName, Object value) {
        List kafkaPods = KubeClusterResource.kubeClient().listPodsByPrefixInName(kafkaPodNamePrefix);
        for (Pod pod : kafkaPods) {
            TestUtils.waitFor((String)"Wait until dyn.configuration is changed", (long)Constants.GLOBAL_POLL_INTERVAL, (long)(Constants.RECONCILIATION_INTERVAL + Duration.ofSeconds(10L).toMillis()), () -> {
                String result = KubeClusterResource.cmdKubeClient().execInPod(pod.getMetadata().getName(), new String[]{"/bin/bash", "-c", "bin/kafka-configs.sh --bootstrap-server localhost:9092 --entity-type brokers --entity-name 0 --describe"}).out();
                LOGGER.debug("This dyn.configuration {} inside the Kafka pod {}", (Object)result, (Object)pod.getMetadata().getName());
                if (!result.contains(brokerConfigName + "=" + value)) {
                    LOGGER.error("Kafka Pod {} doesn't contain {} with value {}", (Object)pod.getMetadata().getName(), (Object)brokerConfigName, value);
                    LOGGER.error("Kafka configuration {}", (Object)result);
                    return false;
                }
                return true;
            });
        }
        return true;
    }

    public static Map<String, ConfigModel> readConfigModel(String kafkaVersion) {
        Map map;
        String name = TestUtils.USER_PATH + "/../cluster-operator/src/main/resources/kafka-" + kafkaVersion + "-config-model.json";
        FileInputStream in = new FileInputStream(name);
        try {
            ConfigModels configModels = (ConfigModels)new ObjectMapper().readValue((InputStream)in, ConfigModels.class);
            if (!kafkaVersion.equals(configModels.getVersion())) {
                throw new RuntimeException("Incorrect version");
            }
            map = configModels.getConfigs();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading from classpath resource " + name, e);
            }
        }
        ((InputStream)in).close();
        return map;
    }

    public static Map<String, ConfigModel> getDynamicConfigurationProperties(String kafkaVersion) {
        Map<String, ConfigModel> configs = KafkaUtils.readConfigModel(kafkaVersion);
        LOGGER.info("This is configs {}", (Object)configs.toString());
        LOGGER.info("This is all kafka configs with size {}", (Object)configs.size());
        Map<String, ConfigModel> dynamicConfigs = configs.entrySet().stream().filter(a -> {
            boolean isClusterWideOrPerBroker;
            String[] prefixKey = ((String)a.getKey()).split("\\.");
            boolean bl = isClusterWideOrPerBroker = ((ConfigModel)a.getValue()).getScope() == Scope.CLUSTER_WIDE || ((ConfigModel)a.getValue()).getScope() == Scope.PER_BROKER;
            if (prefixKey[0].equals("ssl") || prefixKey[0].equals("sasl") || prefixKey[0].equals("advertised") || prefixKey[0].equals("listeners") || prefixKey[0].equals("listener")) {
                return isClusterWideOrPerBroker && !"listeners, advertised., broker., listener., host.name, port, inter.broker.listener.name, sasl., ssl., security., password., principal.builder.class, log.dir, zookeeper.connect, zookeeper.set.acl, zookeeper.ssl, zookeeper.clientCnxnSocket, authorizer., super.user, cruise.control.metrics.topic, cruise.control.metrics.reporter.bootstrap.servers".contains(prefixKey[0]);
            }
            return isClusterWideOrPerBroker;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        LOGGER.info("This is dynamic-configs size {}", (Object)dynamicConfigs.size());
        Map<String, ConfigModel> forbiddenExceptionsConfigs = configs.entrySet().stream().filter(a -> "zookeeper.connection.timeout.ms, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols,cruise.control.metrics.topic.num.partitions, cruise.control.metrics.topic.replication.factor, cruise.control.metrics.topic.retention.ms,cruise.control.metrics.topic.auto.create.retries, cruise.control.metrics.topic.auto.create.timeout.ms,cruise.control.metrics.topic.min.insync.replicas".contains((CharSequence)a.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        LOGGER.info("This is size of forbidden-exception-configs size {}", (Object)forbiddenExceptionsConfigs.size());
        HashMap<String, ConfigModel> dynamicConfigsWithExceptions = new HashMap<String, ConfigModel>();
        dynamicConfigsWithExceptions.putAll(dynamicConfigs);
        dynamicConfigsWithExceptions.putAll(forbiddenExceptionsConfigs);
        LOGGER.info("This is dynamic-configs with forbidden-exception-configs size {}", (Object)dynamicConfigsWithExceptions.size());
        dynamicConfigsWithExceptions.forEach((key, value) -> LOGGER.info(key + " -> " + value));
        return dynamicConfigsWithExceptions;
    }

    public static String generateRandomNameOfKafka(String clusterName) {
        return clusterName + "-" + new Random().nextInt(Integer.MAX_VALUE);
    }

    public static String getVersionFromKafkaPodLibs(String kafkaPodName) {
        String command = "ls libs | grep -Po 'kafka_\\d+.\\d+-\\K(\\d+.\\d+.\\d+)(?=.*jar)' | head -1 | cut -d \"-\" -f2";
        return KubeClusterResource.cmdKubeClient().execInPodContainer(kafkaPodName, "kafka", new String[]{"/bin/bash", "-c", command}).out().trim();
    }

    public static void waitForKafkaDeletion(String kafkaClusterName) {
        LOGGER.info("Waiting for deletion of Kafka:{}", (Object)kafkaClusterName);
        TestUtils.waitFor((String)("Kafka deletion " + kafkaClusterName), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)DELETION_TIMEOUT, () -> {
            if (((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(kafkaClusterName)).get() == null && KubeClusterResource.kubeClient().getStatefulSet(KafkaResources.kafkaStatefulSetName((String)kafkaClusterName)) == null && KubeClusterResource.kubeClient().getStatefulSet(KafkaResources.zookeeperStatefulSetName((String)kafkaClusterName)) == null && KubeClusterResource.kubeClient().getDeployment(KafkaResources.entityOperatorDeploymentName((String)kafkaClusterName)) == null) {
                return true;
            }
            KubeClusterResource.cmdKubeClient().deleteByName("Kafka", kafkaClusterName);
            return false;
        }, () -> LOGGER.info(((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(kafkaClusterName)).get()));
    }

    public static String changeOrRemoveKafkaVersion(File file, String version) {
        YAMLMapper mapper = new YAMLMapper();
        try {
            JsonNode node = mapper.readTree(file);
            ObjectNode kafkaNode = (ObjectNode)node.at("/spec/kafka");
            if (version == null) {
                kafkaNode.remove("version");
                ((ObjectNode)kafkaNode.get("config")).remove("log.message.format.version");
            } else if (!version.equals("")) {
                kafkaNode.put("version", version);
                ((ObjectNode)kafkaNode.get("config")).put("log.message.format.version", version.substring(0, 3));
            }
            return mapper.writeValueAsString((Object)node);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

