/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kubeUtils.controllers;

import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentCondition;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.systemtest.utils.kubeUtils.objects.PodUtils;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeploymentUtils {
    private static final Logger LOGGER = LogManager.getLogger(DeploymentUtils.class);
    private static final long READINESS_TIMEOUT = ResourceOperation.getTimeoutForResourceReadiness("Deployment");
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    private DeploymentUtils() {
    }

    public static void logCurrentDeploymentStatus(Deployment deployment) {
        if (deployment != null) {
            String kind = deployment.getKind();
            String name = deployment.getMetadata().getName();
            ArrayList<String> log = new ArrayList<String>(Arrays.asList("\n", kind, " status:\n", "\nConditions:\n"));
            for (DeploymentCondition deploymentCondition : deployment.getStatus().getConditions()) {
                log.add("\tType: " + deploymentCondition.getType() + "\n");
                log.add("\tMessage: " + deploymentCondition.getMessage() + "\n");
            }
            if (KubeClusterResource.kubeClient().listPodsByPrefixInName(name).size() != 0) {
                log.add("\nPods with conditions and messages:\n\n");
                for (Pod pod : KubeClusterResource.kubeClient().listPodsByPrefixInName(name)) {
                    log.add(pod.getMetadata().getName() + ":");
                    for (PodCondition podCondition : pod.getStatus().getConditions()) {
                        if (podCondition.getMessage() == null) continue;
                        log.add("\n\tType: " + podCondition.getType() + "\n");
                        log.add("\tMessage: " + podCondition.getMessage() + "\n");
                    }
                    log.add("\n\n");
                }
                LOGGER.info("{}", (Object)String.join((CharSequence)"", log));
            }
            LOGGER.info("{}", (Object)String.join((CharSequence)"", log));
        }
    }

    public static void waitForNoRollingUpdate(String deploymentName, Map<String, String> pods) {
        int[] i = new int[]{0};
        TestUtils.waitFor((String)"stability of rolling update will be not triggered", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> {
            if (!DeploymentUtils.depHasRolled(deploymentName, pods)) {
                LOGGER.info("{} pods not rolling waiting, remaining seconds for stability {}", (Object)pods.toString(), (Object)(Constants.GLOBAL_RECONCILIATION_COUNT - i[0]));
                int n = i[0];
                i[0] = n + 1;
                return n == Constants.GLOBAL_RECONCILIATION_COUNT;
            }
            throw new RuntimeException(pods.toString() + " pods are rolling!");
        });
    }

    public static Map<String, String> depSnapshot(String name) {
        Deployment deployment = KubeClusterResource.kubeClient().getDeployment(name);
        LabelSelector selector = deployment.getSpec().getSelector();
        return PodUtils.podSnapshot(selector);
    }

    public static boolean depHasRolled(String name, Map<String, String> snapshot) {
        LOGGER.debug("Existing snapshot: {}", new TreeMap<String, String>(snapshot));
        Map<String, String> map = PodUtils.podSnapshot(KubeClusterResource.kubeClient().getDeployment(name).getSpec().getSelector());
        LOGGER.debug("Current  snapshot: {}", new TreeMap<String, String>(map));
        int current = map.size();
        map.keySet().retainAll(snapshot.keySet());
        if (current == snapshot.size() && map.isEmpty()) {
            LOGGER.debug("All pods seem to have rolled");
            return true;
        }
        LOGGER.debug("Some pods still need to roll: {}", map);
        return false;
    }

    public static Map<String, String> waitTillDepHasRolled(String name, int expectedPods, Map<String, String> snapshot) {
        LOGGER.info("Waiting for Deployment {} rolling update", (Object)name);
        TestUtils.waitFor((String)("Deployment " + name + " rolling update"), (long)Constants.WAIT_FOR_ROLLING_UPDATE_INTERVAL, (long)ResourceOperation.timeoutForPodsOperation(expectedPods), () -> DeploymentUtils.depHasRolled(name, snapshot));
        DeploymentUtils.waitForDeploymentReady(name);
        PodUtils.waitForPodsReady(KubeClusterResource.kubeClient().getDeployment(name).getSpec().getSelector(), expectedPods, true);
        LOGGER.info("Deployment {} rolling update finished", (Object)name);
        return DeploymentUtils.depSnapshot(name);
    }

    public static void waitForDeploymentRecovery(String name, String deploymentUid) {
        LOGGER.info("Waiting for Deployment {}-{} recovery in namespace {}", (Object)name, (Object)deploymentUid, (Object)KubeClusterResource.kubeClient().getNamespace());
        TestUtils.waitFor((String)("deployment " + name + " to be recovered"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)Constants.TIMEOUT_FOR_RESOURCE_RECOVERY, () -> !KubeClusterResource.kubeClient().getDeploymentUid(name).equals(deploymentUid));
        LOGGER.info("Deployment {} was recovered", (Object)name);
    }

    public static void waitForDeploymentReady(String deploymentName) {
        LOGGER.info("Wait for Deployment: {} will be ready", (Object)deploymentName);
        TestUtils.waitFor((String)String.format("Wait for Deployment: %s will be ready", deploymentName), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)READINESS_TIMEOUT, () -> KubeClusterResource.kubeClient().getDeploymentStatus(deploymentName), () -> DeploymentUtils.logCurrentDeploymentStatus(KubeClusterResource.kubeClient().getDeployment(deploymentName)));
        LOGGER.info("Deployment: {} is ready", (Object)deploymentName);
    }

    public static void waitForDeploymentAndPodsReady(String deploymentName, int expectPods) {
        DeploymentUtils.waitForDeploymentReady(deploymentName);
        LOGGER.info("Waiting for {} Pod(s) of Deployment {} to be ready", (Object)expectPods, (Object)deploymentName);
        PodUtils.waitForPodsReady(KubeClusterResource.kubeClient().getDeploymentSelectors(deploymentName), expectPods, true, () -> DeploymentUtils.logCurrentDeploymentStatus(KubeClusterResource.kubeClient().getDeployment(deploymentName)));
        LOGGER.info("Deployment {} is ready", (Object)deploymentName);
    }

    public static void waitForDeploymentDeletion(String name) {
        LOGGER.debug("Waiting for Deployment {} deletion", (Object)name);
        TestUtils.waitFor((String)("Deployment " + name + " to be deleted"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_DELETION, (long)DELETION_TIMEOUT, () -> {
            if (KubeClusterResource.kubeClient().getDeployment(name) == null) {
                return true;
            }
            LOGGER.warn("Deployment {} is not deleted yet! Triggering force delete by cmd client!", (Object)name);
            KubeClusterResource.cmdKubeClient().deleteByName("deployment", name);
            return false;
        });
        LOGGER.debug("Deployment {} was deleted", (Object)name);
    }
}

