/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kubeUtils.controllers;

import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicaSetUtils {
    private static final Logger LOGGER = LogManager.getLogger(ReplicaSetUtils.class);
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    private ReplicaSetUtils() {
    }

    public static void waitForReplicaSetDeletion(String name) {
        LOGGER.debug("Waiting for ReplicaSet of Deployment {} deletion", (Object)name);
        TestUtils.waitFor((String)("ReplicaSet " + name + " to be deleted"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_DELETION, (long)DELETION_TIMEOUT, () -> {
            if (!KubeClusterResource.kubeClient().replicaSetExists(name)) {
                return true;
            }
            String rsName = KubeClusterResource.kubeClient().getReplicaSetNameByPrefix(name);
            LOGGER.warn("ReplicaSet {} is not deleted yet! Triggering force delete by cmd client!", (Object)rsName);
            KubeClusterResource.cmdKubeClient().deleteByName("replicaset", rsName);
            return false;
        });
        LOGGER.debug("ReplicaSet of Deployment {} was deleted", (Object)name);
    }
}

