/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kubeUtils.controllers;

import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.systemtest.resources.crd.KafkaResource;
import io.strimzi.systemtest.utils.kubeUtils.objects.PodUtils;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatefulSetUtils {
    private static final Logger LOGGER = LogManager.getLogger(StatefulSetUtils.class);
    private static final long READINESS_TIMEOUT = ResourceOperation.getTimeoutForResourceReadiness("StatefulSet");
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion("StatefulSet");

    private StatefulSetUtils() {
    }

    public static Map<String, String> ssSnapshot(String name) {
        StatefulSet statefulSet = KubeClusterResource.kubeClient().getStatefulSet(name);
        LabelSelector selector = statefulSet.getSpec().getSelector();
        return PodUtils.podSnapshot(selector);
    }

    public static boolean ssHasRolled(String name, Map<String, String> snapshot) {
        boolean log = true;
        if (log) {
            LOGGER.debug("Existing snapshot: {}", new TreeMap<String, String>(snapshot));
        }
        LabelSelector selector = null;
        int times = 60;
        do {
            if ((selector = KubeClusterResource.kubeClient().getStatefulSetSelectors(name)) != null) continue;
            if (times-- == 0) {
                throw new RuntimeException("Retry failed");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } while (selector == null);
        Map<String, String> map = PodUtils.podSnapshot(selector);
        if (log) {
            LOGGER.debug("Current snapshot: {}", new TreeMap<String, String>(map));
        }
        map.keySet().retainAll(snapshot.keySet());
        if (log) {
            LOGGER.debug("Pods in common: {}", new TreeMap<String, String>(map));
        }
        for (Map.Entry<String, String> e : map.entrySet()) {
            String currentResourceVersion = e.getValue();
            String resourceName = e.getKey();
            String oldResourceVersion = snapshot.get(resourceName);
            if (!oldResourceVersion.equals(currentResourceVersion)) continue;
            if (log) {
                LOGGER.debug("At least {} hasn't rolled", (Object)resourceName);
            }
            return false;
        }
        if (log) {
            LOGGER.debug("All pods seem to have rolled");
        }
        return true;
    }

    public static Map<String, String> waitTillSsHasRolled(String name, Map<String, String> snapshot) {
        LOGGER.info("Waiting for StatefulSet {} rolling update", (Object)name);
        TestUtils.waitFor((String)("StatefulSet " + name + " rolling update"), (long)Constants.WAIT_FOR_ROLLING_UPDATE_INTERVAL, (long)ResourceOperation.timeoutForPodsOperation(snapshot.size()), () -> {
            try {
                return StatefulSetUtils.ssHasRolled(name, snapshot);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        });
        LOGGER.info("StatefulSet {} rolling update finished", (Object)name);
        return StatefulSetUtils.ssSnapshot(name);
    }

    public static Map<String, String> waitTillSsHasRolled(String name, int expectedPods, Map<String, String> snapshot) {
        StatefulSetUtils.waitTillSsHasRolled(name, snapshot);
        StatefulSetUtils.waitForAllStatefulSetPodsReady(name, expectedPods);
        return StatefulSetUtils.ssSnapshot(name);
    }

    public static void waitForAllStatefulSetPodsReady(String statefulSetName, int expectPods, long timeout) {
        String resourceName = statefulSetName.contains("-kafka") ? statefulSetName.replace("-kafka", "") : statefulSetName.replace("-zookeeper", "");
        LOGGER.info("Waiting for StatefulSet {} to be ready", (Object)statefulSetName);
        TestUtils.waitFor((String)("StatefulSet " + statefulSetName + " to be ready"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)timeout, () -> KubeClusterResource.kubeClient().getStatefulSetStatus(statefulSetName), () -> ResourceManager.logCurrentResourceStatus((Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(resourceName)).get()));
        LOGGER.info("Waiting for {} Pod(s) of StatefulSet {} to be ready", (Object)expectPods, (Object)statefulSetName);
        PodUtils.waitForPodsReady(KubeClusterResource.kubeClient().getStatefulSetSelectors(statefulSetName), expectPods, true, () -> ResourceManager.logCurrentResourceStatus((Kafka)((Resource)((NonNamespaceOperation)KafkaResource.kafkaClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(resourceName)).get()));
        LOGGER.info("StatefulSet {} is ready", (Object)statefulSetName);
    }

    public static void waitForAllStatefulSetPodsReady(String statefulSetName, int expectPods) {
        StatefulSetUtils.waitForAllStatefulSetPodsReady(statefulSetName, expectPods, READINESS_TIMEOUT);
    }

    public static void waitForStatefulSetDeletion(String name) {
        LOGGER.debug("Waiting for StatefulSet {} deletion", (Object)name);
        TestUtils.waitFor((String)("StatefulSet " + name + " to be deleted"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_DELETION, (long)DELETION_TIMEOUT, () -> {
            if (KubeClusterResource.kubeClient().getStatefulSet(name) == null) {
                return true;
            }
            LOGGER.warn("StatefulSet {} is not deleted yet! Triggering force delete by cmd client!", (Object)name);
            KubeClusterResource.cmdKubeClient().deleteByName("statefulset", name);
            return false;
        });
        LOGGER.debug("StatefulSet {} was deleted", (Object)name);
    }

    public static void waitForStatefulSetRecovery(String name, String statefulSetUid) {
        LOGGER.info("Waiting for StatefulSet {}-{} recovery in namespace {}", (Object)name, (Object)statefulSetUid, (Object)KubeClusterResource.kubeClient().getNamespace());
        TestUtils.waitFor((String)("StatefulSet " + name + " to be recovered"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)Constants.TIMEOUT_FOR_RESOURCE_RECOVERY, () -> !KubeClusterResource.kubeClient().getStatefulSetUid(name).equals(statefulSetUid));
        LOGGER.info("StatefulSet {} was recovered", (Object)name);
    }

    public static void waitForStatefulSetLabelsChange(String statefulSetName, Map<String, String> labels) {
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            boolean isK8sTag;
            boolean bl = isK8sTag = entry.getKey().equals("controller-revision-hash") || entry.getKey().equals("statefulset.kubernetes.io/pod-name");
            boolean isStrimziTag = entry.getKey().startsWith("strimzi.io/");
            if (isStrimziTag || isK8sTag) continue;
            LOGGER.info("Waiting for Stateful set label change {} -> {}", (Object)entry.getKey(), (Object)entry.getValue());
            TestUtils.waitFor((String)("Waits for StatefulSet label change " + entry.getKey() + " -> " + entry.getValue()), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)Constants.GLOBAL_TIMEOUT, () -> ((String)KubeClusterResource.kubeClient().getStatefulSet(statefulSetName).getMetadata().getLabels().get(entry.getKey())).equals(entry.getValue()));
        }
    }

    public static void waitForStatefulSetLabelsDeletion(String statefulSetName, String ... labelKeys) {
        for (String labelKey : labelKeys) {
            LOGGER.info("Waiting for StatefulSet label {} change to {}", (Object)labelKey, null);
            TestUtils.waitFor((String)("Waiting for StatefulSet label" + labelKey + " change to null"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)DELETION_TIMEOUT, () -> KubeClusterResource.kubeClient().getStatefulSet(statefulSetName).getMetadata().getLabels().get(labelKey) == null);
            LOGGER.info("StatefulSet label {} change to {}", (Object)labelKey, null);
        }
    }

    public static void waitForNoRollingUpdate(String statefulSetName, Map<String, String> pods) {
        int[] i = new int[]{0};
        TestUtils.waitFor((String)"Waiting for stability of rolling update will be not triggered", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> {
            if (!StatefulSetUtils.ssHasRolled(statefulSetName, pods)) {
                LOGGER.info("{} pods didn't roll. Remaining seconds for stability: {}", (Object)pods.toString(), (Object)(Constants.GLOBAL_RECONCILIATION_COUNT - i[0]));
                int n = i[0];
                i[0] = n + 1;
                return n == Constants.GLOBAL_RECONCILIATION_COUNT;
            }
            throw new RuntimeException(pods.toString() + " pods are rolling!");
        });
    }
}

