/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kubeUtils.objects;

import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NamespaceUtils {
    private static final Logger LOGGER = LogManager.getLogger(NamespaceUtils.class);
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    private NamespaceUtils() {
    }

    public static void waitForNamespaceDeletion(String name) {
        LOGGER.info("Waiting for Namespace {} deletion", (Object)name);
        TestUtils.waitFor((String)("namespace " + name), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)DELETION_TIMEOUT, () -> KubeClusterResource.kubeClient().getNamespace(name) == null);
        LOGGER.info("Namespace {} was deleted", (Object)name);
    }
}

