/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.specific;

import io.fabric8.kubernetes.api.model.LabelSelector;
import io.strimzi.api.kafka.model.KafkaBridgeResources;
import io.strimzi.api.kafka.model.KafkaConnectResources;
import io.strimzi.api.kafka.model.KafkaExporterResources;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2Resources;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.executor.Exec;
import io.strimzi.test.k8s.KubeClusterResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetricsUtils {
    private static final Logger LOGGER = LogManager.getLogger(MetricsUtils.class);
    private static final Object LOCK = new Object();

    private MetricsUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String collectMetrics(String scraperPodName, String metricsPodIp, int port, String metricsPath) throws InterruptedException, ExecutionException, IOException {
        List<String> executableCommand = Arrays.asList(KubeClusterResource.cmdKubeClient().toString(), "exec", scraperPodName, "-n", KubeClusterResource.kubeClient().getNamespace(), "--", "curl", metricsPodIp + ":" + port + metricsPath);
        Exec exec = new Exec();
        int ret = exec.execute(null, executableCommand, 20000L);
        Object object = LOCK;
        synchronized (object) {
            LOGGER.info("Metrics collection for PodIp {} from Pod {} finished with return code: {}", (Object)metricsPodIp, (Object)scraperPodName, (Object)ret);
        }
        return exec.out();
    }

    public static HashMap<String, String> collectKafkaPodsMetrics(String scraperPodName, String clusterName) {
        LabelSelector kafkaSelector = KubeClusterResource.kubeClient().getStatefulSetSelectors(KafkaResources.kafkaStatefulSetName((String)clusterName));
        return MetricsUtils.collectMetricsFromPods(scraperPodName, kafkaSelector, 9404);
    }

    public static HashMap<String, String> collectZookeeperPodsMetrics(String scraperPodName, String clusterName) {
        LabelSelector zookeeperSelector = KubeClusterResource.kubeClient().getStatefulSetSelectors(KafkaResources.zookeeperStatefulSetName((String)clusterName));
        return MetricsUtils.collectMetricsFromPods(scraperPodName, zookeeperSelector, 9404);
    }

    public static HashMap<String, String> collectKafkaConnectPodsMetrics(String scraperPodName, String clusterName) {
        LabelSelector connectSelector = KubeClusterResource.kubeClient().getDeploymentSelectors(KafkaConnectResources.deploymentName((String)clusterName));
        return MetricsUtils.collectMetricsFromPods(scraperPodName, connectSelector, 9404);
    }

    public static HashMap<String, String> collectKafkaExporterPodsMetrics(String scraperPodName, String clusterName) {
        LabelSelector kafkaExporterSelector = KubeClusterResource.kubeClient().getDeploymentSelectors(KafkaExporterResources.deploymentName((String)clusterName));
        return MetricsUtils.collectMetricsFromPods(scraperPodName, kafkaExporterSelector, 9404, "/metrics");
    }

    public static HashMap<String, String> collectKafkaMirrorMaker2PodsMetrics(String scraperPodName, String clusterName) {
        LabelSelector mm2Selector = KubeClusterResource.kubeClient().getDeploymentSelectors(KafkaMirrorMaker2Resources.deploymentName((String)clusterName));
        return MetricsUtils.collectMetricsFromPods(scraperPodName, mm2Selector, 9404);
    }

    public static HashMap<String, String> collectUserOperatorPodMetrics(String scraperPodName, String clusterName) {
        LabelSelector uoSelector = KubeClusterResource.kubeClient().getDeploymentSelectors(KafkaResources.entityOperatorDeploymentName((String)clusterName));
        return MetricsUtils.collectMetricsFromPods(scraperPodName, uoSelector, 8081, "/metrics");
    }

    public static HashMap<String, String> collectTopicOperatorPodMetrics(String scraperPodName, String clusterName) {
        LabelSelector toSelector = KubeClusterResource.kubeClient().getDeploymentSelectors(KafkaResources.entityOperatorDeploymentName((String)clusterName));
        return MetricsUtils.collectMetricsFromPods(scraperPodName, toSelector, 8080, "/metrics");
    }

    public static HashMap<String, String> collectClusterOperatorPodMetrics(String scraperPodName) {
        LabelSelector coSelector = KubeClusterResource.kubeClient().getDeploymentSelectors(ResourceManager.getCoDeploymentName());
        return MetricsUtils.collectMetricsFromPods(scraperPodName, coSelector, 8080, "/metrics");
    }

    public static HashMap<String, String> collectKafkaBridgePodMetrics(String scraperPodName, String clusterName) {
        LabelSelector coSelector = KubeClusterResource.kubeClient().getDeploymentSelectors(KafkaBridgeResources.deploymentName((String)clusterName));
        return MetricsUtils.collectMetricsFromPods(scraperPodName, coSelector, 8080, "/metrics");
    }

    public static ArrayList<Double> collectSpecificMetric(Pattern pattern, HashMap<String, String> data) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            Matcher t = pattern.matcher(entry.getValue());
            if (!t.find()) continue;
            values.add(Double.parseDouble(t.group(1)));
        }
        return values;
    }

    public static HashMap<String, String> collectMetricsFromPods(String scraperPodName, LabelSelector labelSelector, int port) {
        return MetricsUtils.collectMetricsFromPods(scraperPodName, labelSelector, port, "");
    }

    public static HashMap<String, String> collectMetricsFromPods(String scraperPodName, LabelSelector labelSelector, int port, String metricsPath) {
        HashMap<String, String> map = new HashMap<String, String>();
        KubeClusterResource.kubeClient().listPods(labelSelector).forEach(p -> {
            try {
                map.put(p.getMetadata().getName(), MetricsUtils.collectMetrics(scraperPodName, p.getStatus().getPodIP(), port, metricsPath));
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return map;
    }
}

