/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.specific;

import io.strimzi.systemtest.Constants;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TracingUtils {
    private static final Logger LOGGER = LogManager.getLogger(TracingUtils.class);
    private static final String JAEGER_QUERY_SERVICE = "my-jaeger-query";
    private static final String JAEGER_QUERY_SERVICE_ENDPOINT = "/jaeger/api/services";
    private static final String JAEGER_QUERY_SERVICE_TRACES_ENDPOINT = "/jaeger/api/traces";
    private static final String JAEGER_QUERY_SERVICE_PARAM_SERVICE = "?service=";
    private static final String JAEGER_QUERY_SERVICE_PARAM_OPERATION = "&operation=";
    private static final int JAEGER_QUERY_PORT = 16686;

    private TracingUtils() {
    }

    public static void verify(String jaegerServiceName, String clientPodName) {
        TracingUtils.verify(jaegerServiceName, clientPodName, null);
    }

    public static void verify(String jaegerServiceName, String clientPodName, String operation) {
        TracingUtils.verifyThatServiceIsPresent(jaegerServiceName, clientPodName);
        TracingUtils.verifyThatServiceTracesArePresent(jaegerServiceName, clientPodName, operation);
    }

    private static void verifyThatServiceIsPresent(String jaegerServiceName, String clientPodName) {
        TestUtils.waitFor((String)("Service " + jaegerServiceName + " is present"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> {
            JsonObject jaegerServices = new JsonObject(KubeClusterResource.cmdKubeClient().execInPod(clientPodName, new String[]{"/bin/bash", "-c", "curl my-jaeger-query:16686/jaeger/api/services"}).out());
            if (jaegerServices.getJsonArray("data").contains((Object)jaegerServiceName)) {
                LOGGER.info("Jaeger service {} is present", (Object)jaegerServiceName);
                return true;
            }
            LOGGER.info("Jaeger service {} is not present. Present services are {}.", (Object)jaegerServiceName, (Object)jaegerServices.getJsonArray("data"));
            return false;
        });
    }

    private static void verifyThatServiceTracesArePresent(String jaegerServiceName, String clientPodName, String operation) {
        TestUtils.waitFor((String)("Service " + jaegerServiceName + " has some traces"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> {
            String query = operation == null ? "my-jaeger-query:16686/jaeger/api/traces?service=" + jaegerServiceName : "my-jaeger-query:16686/jaeger/api/traces?service=" + jaegerServiceName + JAEGER_QUERY_SERVICE_PARAM_OPERATION + operation;
            JsonObject jaegerServicesTraces = new JsonObject(KubeClusterResource.cmdKubeClient().execInPod(clientPodName, new String[]{"/bin/bash", "-c", "curl " + query}).out());
            JsonArray traces = jaegerServicesTraces.getJsonArray("data");
            if (jaegerServicesTraces.getJsonArray("data").size() <= 0) {
                LOGGER.error("Jaeger service {} does not contain data object", (Object)jaegerServiceName);
                return false;
            }
            for (Object trace : traces) {
                String traceId = ((JsonObject)trace).getString("traceID");
                if (!traceId.matches("^[a-z0-9]+")) {
                    LOGGER.error("Jaeger trace does not have correct trace Id {}", (Object)traceId);
                    return false;
                }
                JsonArray spans = ((JsonObject)trace).getJsonArray("spans");
                if (spans.size() <= 0) {
                    LOGGER.error("Jaeger trace {} does not have more than 0 spans inside trace specifically {} spans", (Object)traceId, (Object)spans.size());
                    return false;
                }
                JsonObject processes = ((JsonObject)trace).getJsonObject("processes");
                if (processes.size() <= 0) {
                    LOGGER.error("Jaeger trace {} does not have more that 0 processes specifically {} processes", (Object)traceId, (Object)processes);
                    return false;
                }
                JsonObject warnings = ((JsonObject)trace).getJsonObject("warnings");
                if (warnings == null) continue;
                LOGGER.error("Jaeger trace {} contain some warnings {}", (Object)traceId, (Object)warnings.toString());
                return false;
            }
            return true;
        });
    }
}

