/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.kafka.metadata.FeatureMap;
import org.apache.kafka.metadata.FeatureMapAndEpoch;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineHashSet;

public class FeatureControlManager {
    private final Map<String, VersionRange> supportedFeatures;
    private final TimelineHashMap<String, VersionRange> finalizedVersions;
    private final TimelineHashSet<Long> epoch;

    FeatureControlManager(Map<String, VersionRange> supportedFeatures, SnapshotRegistry snapshotRegistry) {
        this.supportedFeatures = supportedFeatures;
        this.finalizedVersions = new TimelineHashMap(snapshotRegistry, 0);
        this.epoch = new TimelineHashSet(snapshotRegistry, 0);
    }

    ControllerResult<Map<String, ApiError>> updateFeatures(Map<String, VersionRange> updates, Set<String> downgradeables, Map<Integer, Map<String, VersionRange>> brokerFeatures) {
        TreeMap<String, ApiError> results = new TreeMap<String, ApiError>();
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        for (Map.Entry<String, VersionRange> entry : updates.entrySet()) {
            results.put(entry.getKey(), this.updateFeature(entry.getKey(), entry.getValue(), downgradeables.contains(entry.getKey()), brokerFeatures, records));
        }
        return ControllerResult.atomicOf(records, results);
    }

    private ApiError updateFeature(String featureName, VersionRange newRange, boolean downgradeable, Map<Integer, Map<String, VersionRange>> brokerFeatures, List<ApiMessageAndVersion> records) {
        if (newRange.min() <= 0) {
            return new ApiError(Errors.INVALID_UPDATE_VERSION, "The lower value for the new range cannot be less than 1.");
        }
        if (newRange.max() <= 0) {
            return new ApiError(Errors.INVALID_UPDATE_VERSION, "The upper value for the new range cannot be less than 1.");
        }
        VersionRange localRange = this.supportedFeatures.get(featureName);
        if (localRange == null || !localRange.contains(newRange)) {
            return new ApiError(Errors.INVALID_UPDATE_VERSION, "The controller does not support the given feature range.");
        }
        for (Map.Entry<Integer, Map<String, VersionRange>> brokerEntry : brokerFeatures.entrySet()) {
            VersionRange brokerRange = brokerEntry.getValue().get(featureName);
            if (brokerRange != null && brokerRange.contains(newRange)) continue;
            return new ApiError(Errors.INVALID_UPDATE_VERSION, "Broker " + brokerEntry.getKey() + " does not support the given feature range.");
        }
        VersionRange currentRange = this.finalizedVersions.get(featureName);
        if (currentRange != null && currentRange.max() > newRange.max() && !downgradeable) {
            return new ApiError(Errors.INVALID_UPDATE_VERSION, "Can't downgrade the maximum version of this feature without setting downgradable to true.");
        }
        records.add(new ApiMessageAndVersion(new FeatureLevelRecord().setName(featureName).setMinFeatureLevel(newRange.min()).setMaxFeatureLevel(newRange.max()), 0));
        return ApiError.NONE;
    }

    FeatureMapAndEpoch finalizedFeatures(long lastCommittedOffset) {
        HashMap<String, VersionRange> features = new HashMap<String, VersionRange>();
        for (Map.Entry<String, VersionRange> entry : this.finalizedVersions.entrySet(lastCommittedOffset)) {
            features.put(entry.getKey(), entry.getValue());
        }
        long currentEpoch = -1L;
        Iterator<Long> iterator = this.epoch.iterator(lastCommittedOffset);
        if (iterator.hasNext()) {
            currentEpoch = iterator.next();
        }
        return new FeatureMapAndEpoch(new FeatureMap(features), currentEpoch);
    }

    void replay(FeatureLevelRecord record, long offset) {
        this.finalizedVersions.put(record.name(), new VersionRange(record.minFeatureLevel(), record.maxFeatureLevel()));
        this.epoch.clear();
        this.epoch.add(offset);
    }
}

