/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.controller.ReplicaPlacementPolicy;
import org.apache.kafka.metadata.UsableBroker;

public class SimpleReplicaPlacementPolicy
implements ReplicaPlacementPolicy {
    private final Random random;

    public SimpleReplicaPlacementPolicy(Random random) {
        this.random = random;
    }

    @Override
    public List<List<Integer>> createPlacement(int numPartitions, short numReplicas, Iterator<UsableBroker> iterator) {
        ArrayList<UsableBroker> usable = new ArrayList<UsableBroker>();
        while (iterator.hasNext()) {
            usable.add(iterator.next());
        }
        if (usable.size() < numReplicas) {
            throw new InvalidReplicationFactorException("there are only " + usable.size() + " usable brokers");
        }
        ArrayList<List<Integer>> results = new ArrayList<List<Integer>>();
        for (int p = 0; p < numPartitions; ++p) {
            ArrayList<Integer> choices = new ArrayList<Integer>();
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            int initialIndex = this.random.nextInt(usable.size());
            for (int i = 0; i < numReplicas; ++i) {
                indexes.add((initialIndex + i) % usable.size());
            }
            indexes.sort(Integer::compareTo);
            Iterator iter = usable.iterator();
            int i = 0;
            while (choices.size() < indexes.size()) {
                int brokerId = ((UsableBroker)iter.next()).id();
                if ((Integer)indexes.get(choices.size()) == i) {
                    choices.add(brokerId);
                }
                ++i;
            }
            Collections.shuffle(choices, this.random);
            results.add(choices);
        }
        return results;
    }
}

