/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.pipeliner.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.verifyica.pipeliner.common.Console;
import org.verifyica.pipeliner.common.Stopwatch;
import org.verifyica.pipeliner.core.Executable;
import org.verifyica.pipeliner.core.Job;
import org.verifyica.pipeliner.core.Run;
import org.verifyica.pipeliner.core.ShellType;

public class Step
implements Executable {
    private final Job job;
    private final String reference;
    private String name;
    private String id;
    private final Map<String, String> environmentVariables;
    private final Map<String, String> properties;
    private final Map<String, String> options;
    private boolean enabled;
    private ShellType shellType;
    private String workingDirectory;
    private final List<Run> runs;
    private int exitCode;
    private final Stopwatch stopwatch;

    public Step(Job job, int index) {
        this.job = job;
        this.reference = job.getReference() + "-step-" + index;
        this.enabled = true;
        this.environmentVariables = new LinkedHashMap<String, String>();
        this.properties = new LinkedHashMap<String, String>();
        this.options = new LinkedHashMap<String, String>();
        this.shellType = ShellType.BASH;
        this.workingDirectory = ".";
        this.runs = new ArrayList<Run>();
        this.stopwatch = new Stopwatch();
    }

    public Job getJob() {
        return this.job;
    }

    public String getReference() {
        return this.reference;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name.trim();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setId(String id) {
        if (id != null) {
            this.id = id.trim();
        }
    }

    public String getId() {
        return this.id != null ? this.id : this.reference;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.job.isEnabled();
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setShellType(ShellType shellType) {
        this.shellType = shellType;
    }

    public ShellType getShellType() {
        return this.shellType;
    }

    public void setWorkingDirectory(String workingDirectory) {
        if (workingDirectory != null && !workingDirectory.trim().isEmpty()) {
            this.workingDirectory = workingDirectory.trim();
        }
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public List<Run> getRuns() {
        return this.runs;
    }

    private void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public void execute(Executable.Mode mode, Console console) {
        if (mode == Executable.Mode.ENABLED) {
            this.stopwatch.reset();
            console.log(this);
            if (this.isEnabled()) {
                Iterator<Run> iterator = this.getRuns().iterator();
                while (iterator.hasNext()) {
                    Run run2 = iterator.next();
                    run2.execute(Executable.Mode.ENABLED, console);
                    if (run2.getExitCode() == 0) continue;
                    break;
                }
                while (iterator.hasNext()) {
                    iterator.next().execute(Executable.Mode.SKIPPED_OR_DISABLED, console);
                }
            }
            this.getRuns().stream().filter(run -> run.getExitCode() != 0).findFirst().ifPresent(run -> this.setExitCode(run.getExitCode()));
            if (this.isEnabled()) {
                console.log("%s exit-code=[%d] ms=[%d]", this, this.getExitCode(), this.stopwatch.elapsedTime().toMillis());
            }
        } else {
            console.log("%s", this);
        }
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    public String toString() {
        return String.format("@step name=[%s] id=[%s] ref=[%s]", this.getName() == null ? "" : this.getName(), this.getId(), this.getReference());
    }
}

