/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.pipeliner.core.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.verifyica.pipeliner.common.Console;
import org.verifyica.pipeliner.common.ValidatorException;
import org.verifyica.pipeliner.core.CaptureType;
import org.verifyica.pipeliner.core.Job;
import org.verifyica.pipeliner.core.Run;
import org.verifyica.pipeliner.core.ShellType;
import org.verifyica.pipeliner.core.Step;
import org.verifyica.pipeliner.core.parser.Parser;

public class StepParser
extends Parser {
    public StepParser(Console console) {
        super(console);
    }

    public Step parseStep(Job job, Object root, int index) throws ValidatorException {
        Object value;
        String name;
        Map<String, Object> envMap;
        int subIndex;
        this.console.trace("parsing step[%d] ...", index);
        Step step = new Step(job, index);
        this.validator.isMap(root, "step must be a map");
        Map<String, Object> map = this.converter.toMap(root);
        Object object = map.get("name");
        this.validator.notNull(object, String.format("step[%d] name is required", index)).isString(object, String.format("step[%d] name[%s] is not a string", index, object)).notBlank(this.converter.toString(object), String.format("step[%d] name[%s] is blank", index, object));
        step.setName(this.converter.toString(object));
        object = map.get("id");
        if (object != null) {
            this.validator.isString(object, String.format("step[%d] id is not a string", index)).notBlank(this.converter.toString(object), String.format("step[%d] id is blank", index)).isValidId(this.converter.toString(object), String.format("step[%d] id[%s] is invalid", index, object));
            step.setId(this.converter.toString(object));
        }
        if ((object = map.get("enabled")) != null) {
            this.validator.isString(object, String.format("step[%d] enabled is not a boolean", index)).notBlank(this.converter.toString(object), String.format("step[%d] enabled is blank", index)).isBoolean(object, String.format("step[%d] enabled is not a boolean", index));
            step.setEnabled(this.converter.toBoolean(object));
        }
        if ((object = map.get("env")) != null) {
            this.validator.isMap(object, String.format("step[%d] env is not a map", index));
            subIndex = 1;
            envMap = this.converter.toMap(object);
            for (Map.Entry<String, Object> entry : envMap.entrySet()) {
                name = entry.getKey();
                value = entry.getValue();
                this.validator.notBlank(name, String.format("step[%d] env[%d] is blank", index, subIndex)).notNull((Object)name, String.format("step[%d] env[%s] must be a string", index, name)).isValidEnvironmentVariable(name, String.format("step[%d] env[%s] is invalid", index, name)).isString(value, String.format("step[%d] env[%s] must be a string", index, name));
                this.console.trace("step[%d] environment variable [%s] = [%s]", index, name, value);
                step.getEnvironmentVariables().put(name, this.converter.toString(value));
                ++subIndex;
            }
        }
        if ((object = map.get("with")) != null) {
            this.validator.isMap(object, String.format("step[%d] with is not a map", index));
            subIndex = 1;
            envMap = this.converter.toMap(object);
            for (Map.Entry<String, Object> entry : envMap.entrySet()) {
                name = entry.getKey();
                value = entry.getValue();
                this.validator.notNull((Object)name, String.format("step[%d] with[%s] must be a string", index, name)).notBlank(name, String.format("step[%d] with[%d] is blank", index, subIndex)).isValidProperty(name, String.format("step[%d] with[%s] is invalid", index, name)).isString(value, String.format("step[%d] with[%s] must be a string", index, name));
                this.console.trace("step[%d] property [%s] = [%s]", index, name, value);
                step.getProperties().put(name, this.converter.toString(value));
                step.getProperties().put("INPUT_" + name, this.converter.toString(value));
                ++subIndex;
            }
        }
        if ((object = map.get("opt")) != null) {
            this.validator.isMap(object, String.format("step[%d] opt is not a map", index));
            subIndex = 1;
            envMap = this.converter.toMap(object);
            for (Map.Entry<String, Object> entry : envMap.entrySet()) {
                name = entry.getKey();
                value = entry.getValue();
                this.validator.notNull((Object)name, String.format("step[%d] opt[%s] must be a string", index, name)).notBlank(name, String.format("step[%d] opt[%d] is blank", index, subIndex)).isString(value, String.format("step[%d] opt[%s] must be a string", index, name));
                name = name.trim();
                this.console.trace("step[%d] option [%s] = [%s]", index, name, value);
                step.getOptions().put(name, this.converter.toString(value));
                ++subIndex;
            }
        }
        if ((object = map.get("shell")) != null) {
            this.validator.notNull(object, String.format("step[%d] shell is null", index)).isString(object, String.format("step[%d] shell must be a string", index)).notBlank(this.converter.toString(object), String.format("step[%d] shell is blank", index));
            step.setShellType(this.parseShellType(this.converter.toString(object), index));
        }
        if ((object = map.get("working-directory")) != null) {
            this.validator.notNull(object, String.format("step[%d] working-directory is null", index)).isString(object, String.format("step[%d] working-directory must be a string", index)).notBlank(this.converter.toString(object), String.format("step[%d] working-directory is blank", index));
            step.setWorkingDirectory(this.converter.toString(object));
        } else {
            step.setWorkingDirectory(".");
        }
        object = map.get("run");
        this.validator.notNull(object, String.format("step[%d] run is required", index)).isString(object, String.format("step[%d] run must be a string", index)).notBlank(this.converter.toString(object), String.format("step[%d] run is blank", index));
        String string = this.converter.toString(object).trim();
        int subIndex2 = 1;
        List<String> commands = StepParser.mergeLines(Arrays.asList(string.split("\\R")));
        for (String command : commands) {
            this.validator.notNull((Object)command, String.format("step[%d] run[%d] is null", index, subIndex2)).notBlank(command, String.format("step[%d] run[%d] is blank", index, subIndex2));
            Run run = new Run(step, command);
            CaptureType captureType = this.parseCaptureType(command);
            String captureVariable = this.parseCaptureVariable(command, captureType);
            if (captureType == CaptureType.APPEND || captureType == CaptureType.OVERWRITE) {
                this.validator.notNull((Object)captureVariable, String.format("step[%d] run[%d] capture variable is null", index, subIndex2)).notBlank(captureVariable, String.format("step[%d] run[%d] capture variable is blank", index, subIndex2)).isValidProperty(captureVariable, String.format("step[%d] run[%d] capture variable [%s] is invalid", index, subIndex2, captureVariable));
            }
            run.setCapture(captureType, captureVariable);
            step.getRuns().add(run);
            ++subIndex2;
        }
        return step;
    }

    private static List<String> mergeLines(List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (String str : lines) {
            if (str.endsWith(" \\")) {
                current.append(str.substring(0, str.length() - 2));
                continue;
            }
            if (current.length() > 0) {
                current.append(" ");
                current.append(str.trim());
                result.add(current.toString().trim());
                current.setLength(0);
                continue;
            }
            result.add(str);
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        return result;
    }

    private ShellType parseShellType(String string, int index) throws ValidatorException {
        ShellType shellType;
        if (string == null || string.trim().isEmpty()) {
            shellType = ShellType.UNSPECIFIED;
        } else if (string.trim().equals("bash")) {
            shellType = ShellType.BASH;
        } else if (string.trim().equals("sh")) {
            shellType = ShellType.SH;
        } else {
            throw new ValidatorException(String.format("step[%d] shell[%s] is invalid", index, string.trim()));
        }
        return shellType;
    }

    private CaptureType parseCaptureType(String command) {
        this.console.trace("parseCaptureType command [%s]", command);
        String pattern = ".*>>\\s*\\$[A-Za-z0-9][A-Za-z0-9\\-._]*$";
        CaptureType captureType = command.matches(pattern) ? CaptureType.APPEND : (command.matches(pattern = ".*>\\s*\\$[A-Za-z0-9][A-Za-z0-9\\-._]*$") ? CaptureType.OVERWRITE : CaptureType.NONE);
        this.console.trace("parseCaptureType command [%s] captureType [%s]", new Object[]{command, captureType});
        return captureType;
    }

    private String parseCaptureVariable(String command, CaptureType captureType) {
        String captureVariable;
        this.console.trace("parseCaptureVariable command [%s] captureType [%s]", new Object[]{command, captureType});
        switch (captureType) {
            case APPEND: 
            case OVERWRITE: {
                captureVariable = command.substring(command.lastIndexOf("$") + 1);
                break;
            }
            default: {
                captureVariable = null;
            }
        }
        this.console.trace("parseCaptureVariable command [%s] captureType [%s] captureVariable [%s]", new Object[]{command, captureType, captureVariable});
        return captureVariable;
    }
}

