# **Kafka** 

## Description

These tests validate the core Apache Kafka functionality within the Strimzi ecosystem, ensuring the reliability, scalability, and correctness of Kafka clusters. 
They cover various aspects such as dynamic configuration updates, listener configurations, node pool management, version upgrades, quotas, and tiered storage. 
These tests are crucial to ensure that Kafka clusters can handle production workloads.

<!-- generated part -->
**Tests:**
- [testAdditionalVolumes](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testAdvertisedHostNamesAppearsInBrokerCerts](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCertificateWithNonExistingDataCrt](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCertificateWithNonExistingDataKey](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testChangingInternalToExternalLoggingTriggerRollingUpdate](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testClusterIp](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testClusterIpTls](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testClusterOperatorMetrics](../io.strimzi.systemtest.metrics.MetricsST.md)
- [testCombinationOfEveryKindOfListener](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testCombinationOfInternalAndExternalListeners](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testConnectWithConnectorUsingConfigAndEnvProvider](../io.strimzi.systemtest.kafka.ConfigProviderST.md)
- [testCruiseControlMetrics](../io.strimzi.systemtest.metrics.MetricsST.md)
- [testCustomCertLoadBalancerAndTlsRollingUpdate](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomCertNodePortAndTlsRollingUpdate](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomCertRouteAndTlsRollingUpdate](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomChainCertificatesForLoadBalancer](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomChainCertificatesForNodePort](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomChainCertificatesForRoute](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomSoloCertificatesForLoadBalancer](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomSoloCertificatesForNodePort](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomSoloCertificatesForRoute](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testDeployUnsupportedKafka](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testDynConfiguration](../io.strimzi.systemtest.kafka.dynamicconfiguration.DynamicConfSharedST.md)
- [testDynamicallyAndNonDynamicSetConnectLoggingLevels](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testDynamicallySetBridgeLoggingLevels](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testDynamicallySetClusterOperatorLoggingLevels](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testDynamicallySetEOloggingLevels](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testDynamicallySetKafkaExternalLogging](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testDynamicallySetKafkaLoggingLevels](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testDynamicallySetMM2LoggingLevels](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testDynamicallySetUnknownKafkaLogger](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testDynamicallySetUnknownKafkaLoggerValue](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testJSONFormatLogging](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testJvmAndResources](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testKafkaAndKafkaConnectWithJMX](../io.strimzi.systemtest.metrics.JmxST.md)
- [testKafkaBridgeMetrics](../io.strimzi.systemtest.metrics.MetricsST.md)
- [testKafkaConnectAndConnectorMetrics](../io.strimzi.systemtest.metrics.MetricsST.md)
- [testKafkaExporterDifferentSetting](../io.strimzi.systemtest.metrics.MetricsST.md)
- [testKafkaExporterMetrics](../io.strimzi.systemtest.metrics.MetricsST.md)
- [testKafkaJBODDeleteClaimsTrueFalse](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testKafkaLogSetting](../io.strimzi.systemtest.log.LogSettingST.md)
- [testKafkaMetrics](../io.strimzi.systemtest.metrics.MetricsST.md)
- [testKafkaMetricsSettings](../io.strimzi.systemtest.metrics.MetricsST.md)
- [testKafkaNodePoolBrokerIdsManagementUsingAnnotations](../io.strimzi.systemtest.kafka.KafkaNodePoolST.md)
- [testKafkaQuotasPluginIntegration](../io.strimzi.systemtest.kafka.QuotasST.md)
- [testKafkaQuotasPluginWithBandwidthLimitation](../io.strimzi.systemtest.kafka.QuotasST.md)
- [testKafkaWithVersion](../io.strimzi.systemtest.kafka.KafkaVersionsST.md)
- [testLabelsExistenceAndManipulation](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testLoadBalancer](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testLoadBalancerTls](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testLoggingHierarchy](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testMM2LoggingLevelsHierarchy](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testMessagesAndConsumerOffsetFilesOnDisk](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testMessagesTlsScramShaWithPredefinedPassword](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testMirrorMaker2Metrics](../io.strimzi.systemtest.metrics.MetricsST.md)
- [testMixtureOfExternalListeners](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testMultipleInternal](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testMultipleLoadBalancers](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testMultipleNodePorts](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testMultipleRoutes](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testNodePoolsAdditionAndRemoval](../io.strimzi.systemtest.kafka.KafkaNodePoolST.md)
- [testNodePoolsRolesChanging](../io.strimzi.systemtest.kafka.KafkaNodePoolST.md)
- [testNodePort](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testNodePortTls](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testNonExistingCustomCertificate](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testNotExistingCMSetsDefaultLogging](../io.strimzi.systemtest.log.LoggingChangeST.md)
- [testOverrideNodePortConfiguration](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testReadOnlyRootFileSystem](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testRegenerateCertExternalAddressChange](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testRemoveComponentsFromEntityOperator](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testResizeJbodVolumes](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testSendMessagesCustomListenerTlsScramSha](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testSendMessagesPlainAnonymous](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testSendMessagesPlainScramSha](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testSendMessagesTlsAuthenticated](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testSendMessagesTlsScramSha](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testSimpleDynamicConfiguration](../io.strimzi.systemtest.kafka.dynamicconfiguration.DynamicConfST.md)
- [testTieredStorageWithAivenFileSystemPlugin](../io.strimzi.systemtest.kafka.TieredStorageST.md)
- [testTieredStorageWithAivenS3Plugin](../io.strimzi.systemtest.kafka.TieredStorageST.md)
- [testUpdateToExternalListenerCausesRollingRestart](../io.strimzi.systemtest.kafka.dynamicconfiguration.DynamicConfST.md)
- [testUpdateToExternalListenerCausesRollingRestartUsingExternalClients](../io.strimzi.systemtest.kafka.dynamicconfiguration.DynamicConfST.md)
- [testUserOperatorMetrics](../io.strimzi.systemtest.metrics.MetricsST.md)
