/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.pipeliner;

import 6bc6660d778dec84d62bc72b295ffd7b.picocli.CommandLine;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verifyica.pipeliner.common.Console;
import org.verifyica.pipeliner.common.MessageSupplier;
import org.verifyica.pipeliner.common.Validator;
import org.verifyica.pipeliner.common.ValidatorException;
import org.verifyica.pipeliner.common.Version;
import org.verifyica.pipeliner.core.Executable;
import org.verifyica.pipeliner.core.Pipeline;
import org.verifyica.pipeliner.core.parser.PipelineParser;

public class Pipeliner
implements Runnable {
    private static final String PIPELINER_TIMESTAMPS = "PIPELINER_TIMESTAMPS";
    private static final String PIPELINER_TRACE = "PIPELINER_TRACE";
    private static final String PIPELINER_LOG = "PIPELINER_LOG";
    private static final String PIPELINER_MINIMAL = "PIPELINER_MINIMAL";
    private final Console console;
    @CommandLine.Option(names={"--version"}, description={"show version"})
    private boolean showVersion;
    @CommandLine.Option(names={"--timestamps"}, description={"enable timestamps"})
    private boolean timestamps;
    @CommandLine.Option(names={"--trace"}, description={"enable trace logging"})
    private boolean trace;
    @CommandLine.Option(names={"--log"}, description={"enable file logging"})
    private boolean log;
    @CommandLine.Option(names={"--minimal"}, description={"enable minimal output"})
    private boolean minimal;
    @CommandLine.Parameters(description={"filenames"})
    private List<String> filenames;
    @CommandLine.Option(names={"-E"}, description={"specify environment variables in key=value format"}, split=",")
    private Map<String, String> commandLineEnvironmentVariables = new HashMap<String, String>();
    @CommandLine.Option(names={"-P"}, description={"specify property variables in key=value format"}, split=",")
    private Map<String, String> commandLineProperties = new HashMap<String, String>();
    private Validator validator = new Validator();
    private List<File> files;
    private List<Pipeline> pipelines;
    @CommandLine.Option(names={"--suppress-timestamps"}, description={"DEPRECATED"})
    private Boolean suppressTimestamps;

    public Pipeliner() {
        this.console = new Console();
        this.files = new ArrayList<File>();
        this.pipelines = new ArrayList<Pipeline>();
    }

    @Override
    public void run() {
        Object environmentVariable;
        if (this.timestamps) {
            this.console.enableTimestamps(this.timestamps);
        } else {
            environmentVariable = System.getenv(PIPELINER_TIMESTAMPS);
            if (environmentVariable != null) {
                this.timestamps = "true".equals(((String)environmentVariable).trim()) || "1".equals(((String)environmentVariable).trim());
                this.console.enableTimestamps(this.timestamps);
            }
        }
        if (this.trace) {
            this.console.enableTrace(this.trace);
        } else {
            environmentVariable = System.getenv(PIPELINER_TRACE);
            if (environmentVariable != null) {
                this.trace = "true".equals(((String)environmentVariable).trim()) || "1".equals(((String)environmentVariable).trim());
                this.console.enableTrace(this.trace);
            }
        }
        if (this.log) {
            this.console.enableLogging(this.log);
        } else {
            environmentVariable = System.getenv(PIPELINER_LOG);
            if (environmentVariable != null) {
                this.log = "true".equals(((String)environmentVariable).trim()) || "1".equals(((String)environmentVariable).trim());
                this.console.enableLogging(this.log);
            }
        }
        if (this.minimal) {
            this.console.enableMinimal(this.minimal);
        } else {
            environmentVariable = System.getenv(PIPELINER_MINIMAL);
            if (environmentVariable != null) {
                this.log = "true".equals(((String)environmentVariable).trim()) || "1".equals(((String)environmentVariable).trim());
                this.console.enableMinimal(this.log);
            }
        }
        try {
            this.console.initialize();
            if (this.suppressTimestamps != null) {
                this.console.log("@info Verifyica Pipeliner " + Version.getVersion() + " (https://github.com/verifyica-team/pipeliner)");
                this.console.error("option [--suppress-timestamps] has been deprecated. Timestamps are disabled by default");
                this.console.closeAndExit(1);
            }
            if (this.showVersion) {
                if (this.minimal) {
                    System.out.print(Version.getVersion());
                } else {
                    this.console.log("@info Verifyica Pipeliner " + Version.getVersion() + " (https://github.com/verifyica-team/pipeliner)");
                }
                this.console.closeAndExit(0);
            }
            this.console.log("@info Verifyica Pipeliner " + Version.getVersion() + " (https://github.com/verifyica-team/pipeliner)");
            if (this.commandLineEnvironmentVariables != null) {
                try {
                    for (String string : this.commandLineEnvironmentVariables.keySet()) {
                        this.validator.notNull((Object)string, MessageSupplier.of("environment variable is null")).notBlank(string, MessageSupplier.of("environment variable is blank")).isValidEnvironmentVariable(string, MessageSupplier.of("environment variable [%s] is invalid", string));
                    }
                }
                catch (ValidatorException e) {
                    this.console.error("command line " + e.getMessage());
                    this.console.closeAndExit(1);
                }
            }
            if (this.commandLineProperties != null) {
                try {
                    for (String string : this.commandLineProperties.keySet()) {
                        this.validator.notNull((Object)string, MessageSupplier.of("property option is null")).notBlank(string, MessageSupplier.of("property option is blank")).isValidProperty(string, MessageSupplier.of("property option [%s] is invalid", string));
                    }
                }
                catch (ValidatorException e) {
                    this.console.error("command line " + e.getMessage());
                    this.console.closeAndExit(1);
                }
                HashMap temp = new HashMap();
                for (String commandLineProperty : this.commandLineProperties.keySet()) {
                    temp.put(commandLineProperty, this.commandLineProperties.get(commandLineProperty));
                    temp.put("INPUT_" + commandLineProperty, this.commandLineProperties.get(commandLineProperty));
                }
                this.commandLineProperties.clear();
                this.commandLineProperties.putAll(temp);
            }
            if (this.filenames == null || this.filenames.isEmpty()) {
                this.console.error("no filename(s) provided");
                this.console.closeAndExit(1);
            }
            try {
                for (String string : this.filenames) {
                    if (string.trim().isEmpty()) {
                        this.console.error("no filename(s) provided");
                        this.console.closeAndExit(1);
                    }
                    this.console.log("@info filename=[%s]", string);
                    File file = new File(string);
                    this.validator.isValidFile(file, MessageSupplier.of("file either doesn't exit, not a file, or not accessible"));
                    this.files.add(file);
                }
            }
            catch (ValidatorException e) {
                this.console.error(e.getMessage());
                this.console.closeAndExit(1);
            }
            try {
                PipelineParser pipelineParser = new PipelineParser(this.console);
                for (File file : this.files) {
                    Pipeline pipeline = pipelineParser.parse(file.getAbsolutePath());
                    pipeline.getEnvironmentVariables().putAll(this.commandLineEnvironmentVariables);
                    pipeline.getProperties().putAll(this.commandLineProperties);
                    this.pipelines.add(pipeline);
                }
                for (Pipeline pipeline : this.pipelines) {
                    pipeline.execute(Executable.Mode.ENABLED, this.console);
                }
                for (Pipeline pipeline : this.pipelines) {
                    if (pipeline.getExitCode() == 0) continue;
                    this.console.closeAndExit(pipeline.getExitCode());
                }
            }
            catch (ValidatorException e) {
                this.console.error(e.getMessage());
                this.console.closeAndExit(1);
            }
            catch (Throwable t) {
                this.console.error("error [%s] exit-code=[%d]", t.getMessage(), 1);
                if (this.trace) {
                    t.printStackTrace(System.out);
                }
                this.console.closeAndExit(1);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            this.console.closeAndExit(1);
        }
    }

    public static void main(String[] args) {
        new CommandLine(new Pipeliner()).execute(args);
    }
}

