/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.pipeliner.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.verifyica.pipeliner.common.Console;
import org.verifyica.pipeliner.common.Stopwatch;
import org.verifyica.pipeliner.core.Executable;
import org.verifyica.pipeliner.core.Job;

public class Pipeline
implements Executable {
    private final String reference;
    private String name;
    private String id;
    private final Map<String, String> environmentVariables = new LinkedHashMap<String, String>();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Map<String, String> options = new LinkedHashMap<String, String>();
    private final List<Job> jobs = new ArrayList<Job>();
    private int exitCode;
    private final Stopwatch stopwatch = new Stopwatch();

    public Pipeline() {
        this.reference = "pipeline";
    }

    public String getReference() {
        return this.reference;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name.trim();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setId(String id) {
        if (id != null) {
            this.id = id.trim();
        }
    }

    public String getId() {
        return this.id != null ? this.id : this.reference;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public List<Job> getJobs() {
        return this.jobs;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public void execute(Executable.Mode mode, Console console) {
        if (mode == Executable.Mode.ENABLED) {
            this.stopwatch.reset();
            console.log(this);
            for (Job job2 : this.getJobs()) {
                if (job2.isEnabled()) {
                    job2.execute(Executable.Mode.ENABLED, console);
                    continue;
                }
                job2.execute(Executable.Mode.SKIPPED_OR_DISABLED, console);
            }
        } else {
            throw new RuntimeException("A pipeline can't be skipped");
        }
        this.getJobs().stream().filter(job -> job.getExitCode() != 0).findFirst().ifPresent(job -> this.setExitCode(job.getExitCode()));
        console.log("%s exit-code=[%d] ms=[%d]", this, this.getExitCode(), this.stopwatch.elapsedTime().toMillis());
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    public String toString() {
        return String.format("@pipeline name=[%s] id=[%s] ref=[%s]", this.getName() == null ? "" : this.getName(), this.getId(), this.getReference());
    }
}

