/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.pipeliner.core.parser;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.verifyica.pipeliner.common.Console;
import org.verifyica.pipeliner.common.ValidatorException;
import org.verifyica.pipeliner.core.Job;
import org.verifyica.pipeliner.core.Pipeline;
import org.verifyica.pipeliner.core.Step;
import org.verifyica.pipeliner.core.parser.Parser;
import org.verifyica.pipeliner.core.parser.StepParser;

public class JobParser
extends Parser {
    private final StepParser stepParser;

    public JobParser(Console console) {
        super(console);
        this.stepParser = new StepParser(console);
    }

    public Job parseJob(Pipeline pipeline, Object root, int index) throws ValidatorException {
        Object value;
        String name;
        this.console.trace("parsing job[%d] ...", index);
        Job job = new Job(pipeline, index);
        this.validator.isMap(root, "job must be a map");
        Map<String, Object> map = this.converter.toMap(root);
        Object object = map.get("name");
        this.validator.notNull(object, String.format("job[%d] name is required", index)).isString(object, String.format("job[%d] name[%s] is not a string", index, object)).notBlank(this.converter.toString(object), String.format("job[%d] name[%s] is blank", index, object));
        job.setName(this.converter.toString(object));
        object = map.get("id");
        if (object != null) {
            this.validator.isString(object, String.format("job[%d] id is not a string", index)).notBlank(this.converter.toString(object), String.format("job[%d] id is blank", index)).isValidId(this.converter.toString(object), String.format("job[%d] id[%s] is invalid", index, object));
            job.setId(this.converter.toString(object));
        }
        if ((object = map.get("enabled")) != null) {
            this.validator.isString(object, String.format("job[%d] enabled is not a boolean", index)).notBlank(this.converter.toString(object), String.format("job[%d] enabled is blank", index)).isBoolean(object, String.format("job[%d] enabled is not a boolean", index));
            job.setEnabled(this.converter.toBoolean(object));
        }
        if ((object = map.get("env")) != null) {
            this.validator.isMap(object, "pipeline env is not a map");
            for (Map.Entry<String, Object> entry : this.converter.toMap(object).entrySet()) {
                name = entry.getKey();
                value = entry.getValue();
                this.validator.notNull((Object)name, String.format("job[%d] with[%s] must be a string", index, name)).notBlank(name, String.format("job[%d] with is blank", index)).isValidEnvironmentVariable(name, String.format("job[%d] with[%s] is invalid", index, name)).isString(value, String.format("job[%d] with[%s] value must be a string", index, name));
                this.console.trace("job[%d] environment variable [%s] = [%s]", index, name, value);
                job.getEnvironmentVariables().put(name, this.converter.toString(value));
            }
        }
        if ((object = map.get("with")) != null) {
            this.validator.isMap(object, "job with is not a map");
            for (Map.Entry<String, Object> entry : this.converter.toMap(object).entrySet()) {
                name = entry.getKey();
                value = entry.getValue();
                this.validator.notNull((Object)name, String.format("job[%d] with[%s] must be a string", index, name)).notBlank(name, String.format("job[%d] with is blank", index)).isValidProperty(name, String.format("job[%d] with[%s] is invalid", index, name)).isString(value, String.format("job[%d] with[%s] value must be a string", index, name));
                this.console.trace("job[%d] property [%s] = [%s]", index, name, value);
                job.getProperties().put(name, this.converter.toString(value));
                job.getProperties().put("INPUT_" + name, this.converter.toString(value));
            }
        }
        if ((object = map.get("opt")) != null) {
            this.validator.isMap(object, "job opt is not a map");
            for (Map.Entry<String, Object> entry : this.converter.toMap(object).entrySet()) {
                name = entry.getKey();
                value = entry.getValue();
                this.validator.notNull((Object)name, String.format("job[%d] opt[%s] must be a string", index, name)).notBlank(name, String.format("job[%d] opt is blank", index)).isString(value, String.format("job[%d] opt[%s] value must be a string", index, name));
                name = name.trim();
                this.console.trace("job[%d] option [%s] = [%s]", index, name, value);
                job.getOptions().put(name, this.converter.toString(value));
            }
        }
        object = map.get("steps");
        this.validator.notNull(object, String.format("job[%d] steps is required", index)).isList(object, String.format("job[%d] steps must be an array", index));
        this.parseSteps(this.console, job, this.converter.toList(object));
        return job;
    }

    private void parseSteps(Console console, Job job, List<Object> roots) throws ValidatorException {
        console.trace("parsing steps ...", new Object[0]);
        this.validator.condition(!roots.isEmpty(), "jobs must be a non-empty array");
        HashSet<String> currentIds = new HashSet<String>();
        int index = 1;
        for (Object root : roots) {
            Step step = this.stepParser.parseStep(job, root, index);
            if (!currentIds.add(step.getId())) {
                throw new ValidatorException(String.format("duplicate step id[%s]", step.getId()));
            }
            job.getSteps().add(step);
            currentIds.add(step.getId());
            ++index;
        }
    }
}

