/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.pipeliner.core.parser;

import 6bc6660d778dec84d62bc72b295ffd7b.org.yaml.snakeyaml.Yaml;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.verifyica.pipeliner.common.Console;
import org.verifyica.pipeliner.common.ValidatorException;
import org.verifyica.pipeliner.common.YamlStringConstructor;
import org.verifyica.pipeliner.core.Job;
import org.verifyica.pipeliner.core.Pipeline;
import org.verifyica.pipeliner.core.parser.JobParser;
import org.verifyica.pipeliner.core.parser.Parser;

public class PipelineParser
extends Parser {
    private final JobParser jobParser;

    public PipelineParser(Console console) {
        super(console);
        this.jobParser = new JobParser(console);
    }

    public Pipeline parse(String filename) throws ValidatorException, IOException {
        this.console.trace("parsing pipeline ...", new Object[0]);
        Yaml yaml = new Yaml(new YamlStringConstructor());
        try (InputStream inputStream = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
            Object value;
            String name;
            Object root = yaml.load(inputStream);
            Pipeline pipeline = new Pipeline();
            this.validator.notNull(root, "pipeline is null").isMap(root, "pipeline is not a map");
            Object object = this.converter.toMap(root).get("pipeline");
            this.validator.notNull(object, "pipeline is required").isMap(object, "pipeline must be a map");
            Map<String, Object> map = this.converter.toMap(object);
            object = map.get("name");
            this.validator.notNull(object, "pipeline name is required").isString(object, "pipeline name is not a string").notBlank(this.converter.toString(object), "pipeline name [] is blank");
            pipeline.setName(this.converter.toString(object));
            object = map.get("id");
            if (object != null) {
                this.validator.isString(object, "pipeline id is not a string");
                String string = this.converter.toString(object);
                this.validator.notBlank(string, "pipeline id [] is blank").isValidId(string, String.format("pipeline id [%s] is invalid", string));
                pipeline.setId(string);
            }
            if ((object = map.get("env")) != null) {
                this.validator.isMap(object, "pipeline env is not a map");
                for (Map.Entry<String, Object> entry : this.converter.toMap(object).entrySet()) {
                    name = entry.getKey();
                    value = entry.getValue();
                    this.validator.notNull((Object)name, String.format("pipeline env[%s] must be a string", name)).notBlank(name, "pipeline env is blank").isValidEnvironmentVariable(name, String.format("pipeline env[%s] is invalid", name)).isString(value, String.format("pipeline with[%s] value must be a string", name));
                    this.console.trace("pipeline environment variable [%s] = [%s]", name, value);
                    pipeline.getEnvironmentVariables().put(name, this.converter.toString(value));
                }
            }
            if ((object = map.get("with")) != null) {
                this.validator.isMap(object, "pipeline with is not a map");
                for (Map.Entry<String, Object> entry : this.converter.toMap(object).entrySet()) {
                    name = entry.getKey();
                    value = entry.getValue();
                    this.validator.notNull((Object)name, String.format("pipeline with[%s] must be a string", name)).notBlank(name, "pipeline with is blank").isValidProperty(name, String.format("pipeline with[%s] is invalid", name)).isString(value, String.format("pipeline with[%s] value must be a string", name));
                    this.console.trace("pipeline property [%s] = [%s]", name, value);
                    pipeline.getProperties().put(name, this.converter.toString(value));
                    pipeline.getProperties().put("INPUT_" + name, this.converter.toString(value));
                }
            }
            if ((object = map.get("opt")) != null) {
                this.validator.isMap(object, "pipeline opt is not a map");
                for (Map.Entry<String, Object> entry : this.converter.toMap(object).entrySet()) {
                    name = entry.getKey();
                    value = entry.getValue();
                    this.validator.notNull((Object)name, String.format("pipeline opt[%s] must be a string", name)).notBlank(name, "pipeline opt is blank").isString(value, String.format("pipeline opt[%s] value must be a string", name));
                    name = name.trim();
                    this.console.trace("pipeline option [%s] = [%s]", name, value);
                    pipeline.getOptions().put(name, this.converter.toString(value));
                }
            }
            object = map.get("jobs");
            this.validator.notNull(object, "jobs are required").isList(object, "jobs must be an array");
            this.parseJobs(this.console, pipeline, this.converter.toList(object));
            Pipeline pipeline2 = pipeline;
            return pipeline2;
        }
    }

    private void parseJobs(Console console, Pipeline pipeline, List<Object> roots) throws ValidatorException {
        console.trace("parsing jobs ...", new Object[0]);
        this.validator.condition(!roots.isEmpty(), "jobs must be a non-empty array");
        HashSet<String> currentIds = new HashSet<String>();
        int index = 1;
        for (Object root : roots) {
            Job job = this.jobParser.parseJob(pipeline, root, index);
            if (!currentIds.add(job.getId())) {
                throw new ValidatorException(String.format("duplicate job id[%s]", job.getId()));
            }
            pipeline.getJobs().add(job);
            ++index;
        }
    }
}

