/*
 * Copyright Kroxylicious Authors.
 *
 * Licensed under the Apache Software License version 2.0, available at http://www.apache.org/licenses/LICENSE-2.0
 */

package io.kroxylicious.kubernetes.operator.assertj;

import org.assertj.core.api.InstanceOfAssertFactory;

import io.kroxylicious.kubernetes.api.common.Condition;
import io.kroxylicious.kubernetes.api.v1alpha1.KafkaProxyStatus;
import io.kroxylicious.kubernetes.api.v1alpha1.kafkaproxystatus.Clusters;

public class AssertFactory {
    public static InstanceOfAssertFactory<KafkaProxyStatus, KafkaProxyStatusAssert> status() {
        return new InstanceOfAssertFactory<>(KafkaProxyStatus.class, KafkaProxyStatusAssert::assertThat);
    }

    public static InstanceOfAssertFactory<Condition, ConditionAssert> condition() {
        return new InstanceOfAssertFactory<>(Condition.class, ConditionAssert::assertThat);
    }

    public static InstanceOfAssertFactory<Clusters, ClusterAssert> cluster() {
        return new InstanceOfAssertFactory<>(Clusters.class, ClusterAssert::assertThat);
    }

}
