/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.milyn.annotation.AnnotatedClass;
import org.milyn.annotation.AnnotatedMethod;
import org.milyn.annotation.AnnotationManager;

class AnnotatedMethodImpl
implements AnnotatedMethod {
    private final AnnotatedClass annotatedClass;
    private final Method method;
    private Map<Class<?>, Annotation> classToAnnotationMap;
    private Annotation[] annotations;
    private Annotation[][] parameterAnnotations;

    AnnotatedMethodImpl(AnnotatedClass annotatedClass, Method method) {
        this.annotatedClass = annotatedClass;
        this.method = method;
    }

    private Map<Class<?>, Annotation> getAllAnnotationMap() {
        if (this.classToAnnotationMap == null) {
            this.classToAnnotationMap = this.getAllAnnotationMapCalculated();
        }
        return this.classToAnnotationMap;
    }

    private Map<Class<?>, Annotation> getAllAnnotationMapCalculated() {
        HashMap result = new HashMap();
        Class<?> superClass = this.getAnnotatedClass().getTheClass().getSuperclass();
        if (superClass != null) {
            this.fillAnnotationsForOneMethod(result, AnnotationManager.getAnnotatedClass(superClass).getAnnotatedMethod(this.getMethod().getName(), this.getMethod().getParameterTypes()));
        }
        Object[] objectArray = this.getAnnotatedClass().getTheClass().getInterfaces();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = objectArray[n2];
            this.fillAnnotationsForOneMethod(result, AnnotationManager.getAnnotatedClass(c).getAnnotatedMethod(this.getMethod().getName(), this.getMethod().getParameterTypes()));
            ++n2;
        }
        objectArray = this.getMethod().getDeclaredAnnotations();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object annotation = objectArray[n2];
            result.put(annotation.getClass().getInterfaces()[0], (Annotation)annotation);
            ++n2;
        }
        return result;
    }

    private void fillAnnotationsForOneMethod(HashMap<Class<?>, Annotation> result, AnnotatedMethod annotatedMethod) {
        if (annotatedMethod == null) {
            return;
        }
        this.addAnnotations(result, annotatedMethod.getAllAnnotations());
    }

    private void addAnnotations(Map<Class<?>, Annotation> result, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation != null) {
                result.put(annotation.getClass().getInterfaces()[0], annotation);
            }
            ++n2;
        }
    }

    @Override
    public Annotation[] getAllAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.getAllAnnotationsCalculated();
        }
        return this.annotations;
    }

    private Annotation[] getAllAnnotationsCalculated() {
        Collection<Annotation> values = this.getAllAnnotationMap().values();
        return values.toArray(new Annotation[0]);
    }

    @Override
    public AnnotatedClass getAnnotatedClass() {
        return this.annotatedClass;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.getAllAnnotationMap().get(annotationClass);
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    private void fillAnnotationsForParameters(Map<Class<?>, Annotation>[] result, Annotation[][] paramAnnotations) {
        int i = 0;
        while (i < paramAnnotations.length) {
            Annotation[] annontations = paramAnnotations[i];
            Map<Class<?>, Annotation> map = result[i];
            if (map == null) {
                result[i] = map = new HashMap();
            }
            this.addAnnotations(map, annontations);
            ++i;
        }
    }

    private Annotation[][] getParameterAnnotationsCalculated() {
        AnnotatedClass aClass;
        AnnotatedMethod aMethod22;
        Map[] mapResult = new Map[this.method.getParameterAnnotations().length];
        Class<?> superClass = this.getAnnotatedClass().getTheClass().getSuperclass();
        if (superClass != null && (aMethod22 = (aClass = AnnotationManager.getAnnotatedClass(superClass)).getAnnotatedMethod(this.getMethod().getName(), this.getMethod().getParameterTypes())) != null) {
            Annotation[][] paramAnnotations = aMethod22.getParameterAnnotations();
            this.fillAnnotationsForParameters(mapResult, paramAnnotations);
        }
        Class<?>[] classArray = this.getAnnotatedClass().getTheClass().getInterfaces();
        int paramAnnotations = classArray.length;
        int aMethod22 = 0;
        while (aMethod22 < paramAnnotations) {
            Class<?> c = classArray[aMethod22];
            AnnotatedClass aClass2 = AnnotationManager.getAnnotatedClass(c);
            AnnotatedMethod aMethod = aClass2.getAnnotatedMethod(this.getMethod().getName(), this.getMethod().getParameterTypes());
            if (aMethod != null) {
                Annotation[][] paramAnnotations2 = aMethod.getParameterAnnotations();
                this.fillAnnotationsForParameters(mapResult, paramAnnotations2);
            }
            ++aMethod22;
        }
        this.fillAnnotationsForParameters(mapResult, this.method.getParameterAnnotations());
        Annotation[][] result = new Annotation[mapResult.length][];
        Annotation[] arrayTemplate = new Annotation[]{};
        int i = 0;
        while (i < mapResult.length) {
            result[i] = mapResult[i].values().toArray(arrayTemplate);
            ++i;
        }
        return result;
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            this.parameterAnnotations = this.getParameterAnnotationsCalculated();
        }
        return this.parameterAnnotations;
    }
}

