/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.Smooks;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationList;
import org.milyn.cdr.SmooksResourceConfigurationStore;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.container.ExecutionContext;
import org.milyn.expression.ExpressionEvaluator;
import org.milyn.io.StreamUtils;
import org.milyn.net.URIUtil;
import org.milyn.profile.DefaultProfileSet;
import org.milyn.resource.URIResourceLocator;
import org.milyn.util.ClassUtil;
import org.milyn.xml.DomUtils;
import org.milyn.xml.LocalDTDEntityResolver;
import org.milyn.xml.LocalEntityResolver;
import org.milyn.xml.XmlUtil;
import org.milyn.xml.XsdDOMValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public final class XMLConfigDigester {
    public static final String DTD_V10 = "http://www.milyn.org/dtd/smooksres-list-1.0.dtd";
    public static final String XSD_V10 = "http://www.milyn.org/xsd/smooks-1.0.xsd";
    public static final String XSD_V11 = "http://www.milyn.org/xsd/smooks-1.1.xsd";
    private static Log logger = LogFactory.getLog(XMLConfigDigester.class);
    private final SmooksResourceConfigurationList list;
    private final Stack<SmooksConfig> configStack = new Stack();
    private final Map<String, Smooks> extendedConfigDigesters = new HashMap<String, Smooks>();
    private static ThreadLocal<Boolean> extentionDigestOn = new ThreadLocal();

    private XMLConfigDigester(SmooksResourceConfigurationList list) {
        this.list = list;
        this.configStack.push(new SmooksConfig("root-config"));
    }

    public static SmooksResourceConfigurationList digestConfig(InputStream stream, String baseURI) throws SAXException, IOException, URISyntaxException, SmooksConfigurationException {
        SmooksResourceConfigurationList list = new SmooksResourceConfigurationList(baseURI);
        XMLConfigDigester.setExtentionDigestOff();
        XMLConfigDigester digester = new XMLConfigDigester(list);
        digester.digestConfigRecursively(new InputStreamReader(stream), baseURI);
        return list;
    }

    private void digestConfigRecursively(Reader stream, String baseURI) throws IOException, SAXException, URISyntaxException, SmooksConfigurationException {
        String streamData = StreamUtils.readStream(stream);
        try {
            Document configDoc = XmlUtil.parseStream(new StringReader(streamData), (EntityResolver)this.getDTDEntityResolver(), XmlUtil.VALIDATION_TYPE.DTD, true);
            logger.warn((Object)"Using a deprecated Smooks configuration DTD 'http://www.milyn.org/dtd/smooksres-list-1.0.dtd'.  Update configuration to use XSD 'http://www.milyn.org/xsd/smooks-1.0.xsd'.");
            this.digestV10DTDValidatedConfig(configDoc);
            logger.warn((Object)"Using a deprecated Smooks configuration DTD 'http://www.milyn.org/dtd/smooksres-list-1.0.dtd'.  Update configuration to use XSD 'http://www.milyn.org/xsd/smooks-1.0.xsd'.");
        }
        catch (Exception exception) {
            Document configDoc;
            try {
                configDoc = XmlUtil.parseStream(new StringReader(streamData));
            }
            catch (ParserConfigurationException ee) {
                throw new SAXException("Unable to parse Smooks configuration.", ee);
            }
            XsdDOMValidator validator = new XsdDOMValidator(configDoc);
            String defaultNS = validator.getDefaultNamespace().toString();
            validator.validate();
            this.configStack.peek().defaultNS = defaultNS;
            if (XSD_V10.equals(defaultNS)) {
                if (validator.getNamespaces().size() > 1) {
                    throw new SmooksConfigurationException("Unsupported use of multiple configuration namespaces from inside a v1.0 Smooks configuration. Configuration extension not supported from a v1.0 configuration.  Use the v1.1 configuration namespace.");
                }
                this.digestV10XSDValidatedConfig(baseURI, configDoc);
            }
            if (XSD_V11.equals(defaultNS)) {
                this.digestV11XSDValidatedConfig(baseURI, configDoc);
            }
            throw new SAXException("Cannot parse Smooks configuration.  Unsupported default Namespace '" + defaultNS + "'.");
        }
        if (this.list.isEmpty()) {
            throw new SAXException("Invalid Content Delivery Resource archive definition file: 0 Content Delivery Resource definitions.");
        }
    }

    private void digestV10DTDValidatedConfig(Document configDoc) throws SAXException {
        int cdrIndex = 1;
        Element currentElement = (Element)XmlUtil.getNode(configDoc, "/smooks-resource-list");
        String defaultSelector = DomUtils.getAttributeValue(currentElement, "default-selector");
        String defaultNamespace = DomUtils.getAttributeValue(currentElement, "default-namespace");
        String defaultUseragent = DomUtils.getAttributeValue(currentElement, "default-useragent");
        String defaultPath = DomUtils.getAttributeValue(currentElement, "default-path");
        String resourceSelector = "/smooks-resource-list/smooks-resource[" + cdrIndex + "]";
        while ((currentElement = (Element)XmlUtil.getNode(configDoc, resourceSelector)) != null) {
            SmooksResourceConfiguration resourceConfig;
            String selector = DomUtils.getAttributeValue(currentElement, "selector");
            String namespace = DomUtils.getAttributeValue(currentElement, "namespace");
            String useragents = DomUtils.getAttributeValue(currentElement, "useragent");
            String path = DomUtils.getAttributeValue(currentElement, "path");
            try {
                resourceConfig = new SmooksResourceConfiguration(selector != null ? selector : defaultSelector, namespace != null ? namespace : defaultNamespace, useragents != null ? useragents : defaultUseragent, path != null ? path : defaultPath);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException("Invalid unit definition.", e);
            }
            this.digestParameters(currentElement, resourceConfig);
            this.list.add(resourceConfig);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding smooks-resource config from [" + this.list.getName() + "]: " + resourceConfig));
            }
            resourceSelector = "/smooks-resource-list/smooks-resource[" + ++cdrIndex + "]";
        }
    }

    private void digestV10XSDValidatedConfig(String baseURI, Document configDoc) throws SAXException, URISyntaxException, SmooksConfigurationException {
        Element currentElement = configDoc.getDocumentElement();
        String defaultSelector = DomUtils.getAttributeValue(currentElement, "default-selector");
        String defaultNamespace = DomUtils.getAttributeValue(currentElement, "default-selector-namespace");
        String defaultProfile = DomUtils.getAttributeValue(currentElement, "default-target-profile");
        NodeList configNodes = currentElement.getChildNodes();
        int i = 0;
        while (i < configNodes.getLength()) {
            if (configNodes.item(i).getNodeType() == 1) {
                Element configElement = (Element)configNodes.item(i);
                this.assertElementPermitted(configElement);
                if (DomUtils.getName(configElement).equals("profiles")) {
                    this.digestProfiles(configElement);
                } else if (DomUtils.getName(configElement).equals("import")) {
                    this.digestImport(configElement, new URI(baseURI));
                } else if (DomUtils.getName(configElement).equals("resource-config")) {
                    this.digestResourceConfig(configElement, defaultSelector, defaultNamespace, defaultProfile, null);
                }
            }
            ++i;
        }
    }

    private void digestV11XSDValidatedConfig(String baseURI, Document configDoc) throws SAXException, URISyntaxException, SmooksConfigurationException {
        Element currentElement = configDoc.getDocumentElement();
        String defaultSelector = DomUtils.getAttributeValue(currentElement, "default-selector");
        String defaultNamespace = DomUtils.getAttributeValue(currentElement, "default-selector-namespace");
        String defaultProfile = DomUtils.getAttributeValue(currentElement, "default-target-profile");
        String defaultConditionRef = DomUtils.getAttributeValue(currentElement, "default-condition-ref");
        NodeList configNodes = currentElement.getChildNodes();
        int i = 0;
        while (i < configNodes.getLength()) {
            if (configNodes.item(i).getNodeType() == 1) {
                Element configElement = (Element)configNodes.item(i);
                this.assertElementPermitted(configElement);
                String elementName = DomUtils.getName(configElement);
                String namespaceURI = configElement.getNamespaceURI();
                if (namespaceURI == null || namespaceURI.equals(XSD_V11)) {
                    if (elementName.equals("params")) {
                        this.digestParams(configElement);
                    } else if (elementName.equals("conditions")) {
                        this.digestConditions(configElement);
                    } else if (elementName.equals("profiles")) {
                        this.digestProfiles(configElement);
                    } else if (elementName.equals("import")) {
                        this.digestImport(configElement, new URI(baseURI));
                    } else if (elementName.equals("reader")) {
                        this.digestReaderConfig(configElement, defaultProfile);
                    } else if (elementName.equals("resource-config")) {
                        this.digestResourceConfig(configElement, defaultSelector, defaultNamespace, defaultProfile, defaultConditionRef);
                    }
                } else {
                    this.digestExtendedResourceConfig(configElement, defaultSelector, defaultNamespace, defaultProfile, defaultConditionRef);
                }
            }
            ++i;
        }
    }

    private void digestParams(Element paramsElement) {
        NodeList paramNodes = paramsElement.getElementsByTagName("param");
        if (paramNodes.getLength() > 0) {
            SmooksResourceConfiguration globalParamsConfig = new SmooksResourceConfiguration("global-parameters");
            this.digestParameters(paramsElement, globalParamsConfig);
            this.list.add(globalParamsConfig);
        }
    }

    private void assertElementPermitted(Element configElement) {
        String elementName;
        if (XMLConfigDigester.isExtensionConfig() && !(elementName = DomUtils.getName(configElement)).equals("import") && !elementName.equals("resource-config")) {
            throw new SmooksConfigurationException("Configuration element '" + elementName + "' not supported in an extension configuration.");
        }
    }

    private void digestImport(Element importElement, URI baseURI) throws SAXException, URISyntaxException, SmooksConfigurationException {
        String file = DomUtils.getAttributeValue(importElement, "file");
        if (file == null) {
            throw new IllegalStateException("Invalid resource import.  'file' attribute must be specified.");
        }
        URIResourceLocator resourceLocator = new URIResourceLocator();
        resourceLocator.setBaseURI(baseURI);
        try {
            URI fileURI = resourceLocator.resolveURI(file);
            this.pushConfig(file, fileURI);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Importing resource configuration '" + file + "' from inside '" + this.configStack.peek().configFile + "'."));
                }
                InputStream resourceStream = resourceLocator.getResource(file);
                try {
                    List importParams = DomUtils.getElements(importElement, "param", null);
                    if (!importParams.isEmpty()) {
                        String importConfig = StreamUtils.readStreamAsString(resourceStream);
                        for (Element importParam : importParams) {
                            String paramName = DomUtils.getAttributeValue(importParam, "name");
                            String paramValue = XmlUtil.serialize(importParam.getChildNodes());
                            importConfig = importConfig.replaceAll("@" + paramName + "@", paramValue);
                        }
                        this.digestConfigRecursively(new StringReader(importConfig), URIUtil.getParent(fileURI).toString());
                    } else {
                        this.digestConfigRecursively(new InputStreamReader(resourceStream), URIUtil.getParent(fileURI).toString());
                    }
                }
                finally {
                    resourceStream.close();
                }
            }
            finally {
                this.popConfig();
            }
        }
        catch (IOException e) {
            throw new SmooksConfigurationException("Failed to load Smooks configuration resource <import> '" + file + "': " + e.getMessage(), e);
        }
    }

    private void digestReaderConfig(Element configElement, String defaultProfile) {
        String profiles = DomUtils.getAttributeValue(configElement, "targetProfile");
        String readerClass = DomUtils.getAttributeValue(configElement, "class");
        SmooksResourceConfiguration resourceConfig = new SmooksResourceConfiguration("org.xml.sax.driver", profiles != null ? profiles : defaultProfile, readerClass);
        this.configureHandlers(configElement, resourceConfig);
        this.configureFeatures(configElement, resourceConfig);
        this.configureParams(configElement, resourceConfig);
        this.list.add(resourceConfig);
    }

    private void configureHandlers(Element configElement, SmooksResourceConfiguration resourceConfig) {
        Element handlersElement = DomUtils.getElement(configElement, "handlers", 1);
        if (handlersElement != null) {
            NodeList handlers = handlersElement.getChildNodes();
            int i = 0;
            while (i < handlers.getLength()) {
                if (handlers.item(i).getNodeType() == 1) {
                    Element handler = (Element)handlers.item(i);
                    String handlerClass = handler.getAttribute("class");
                    resourceConfig.setParameter("sax-handler", handlerClass);
                }
                ++i;
            }
        }
    }

    private void configureFeatures(Element configElement, SmooksResourceConfiguration resourceConfig) {
        Element featuresElement = DomUtils.getElement(configElement, "features", 1);
        if (featuresElement != null) {
            NodeList features = featuresElement.getChildNodes();
            int i = 0;
            while (i < features.getLength()) {
                if (features.item(i).getNodeType() == 1) {
                    Element feature = (Element)features.item(i);
                    String uri = feature.getAttribute("feature");
                    if (DomUtils.getName(feature).equals("setOn")) {
                        resourceConfig.setParameter("feature-on", uri);
                    } else {
                        resourceConfig.setParameter("feature-off", uri);
                    }
                }
                ++i;
            }
        }
    }

    private void configureParams(Element configElement, SmooksResourceConfiguration resourceConfig) {
        Element paramsElement = DomUtils.getElement(configElement, "params", 1);
        if (paramsElement != null) {
            NodeList params = paramsElement.getChildNodes();
            int i = 0;
            while (i < params.getLength()) {
                if (params.item(i).getNodeType() == 1) {
                    Element param = (Element)params.item(i);
                    String name = param.getAttribute("name");
                    String value = DomUtils.getAllText(param, true);
                    resourceConfig.setParameter(name, value);
                }
                ++i;
            }
        }
    }

    private void digestResourceConfig(Element configElement, String defaultSelector, String defaultNamespace, String defaultProfile, String defaultConditionRef) throws SAXException {
        SmooksResourceConfiguration resourceConfig;
        String selector = DomUtils.getAttributeValue(configElement, "selector");
        String namespace = DomUtils.getAttributeValue(configElement, "selector-namespace");
        String profiles = DomUtils.getAttributeValue(configElement, "target-profile");
        Element resourceElement = XMLConfigDigester.getElementByTagName(configElement, "resource");
        Element conditionElement = XMLConfigDigester.getElementByTagName(configElement, "condition");
        String resource = null;
        try {
            if (resourceElement != null) {
                resource = DomUtils.getAllText(resourceElement, true);
            }
            resourceConfig = new SmooksResourceConfiguration(selector != null ? selector : defaultSelector, namespace != null ? namespace : defaultNamespace, profiles != null ? profiles : defaultProfile, resource);
            if (resourceElement != null) {
                resourceConfig.setResourceType(DomUtils.getAttributeValue(resourceElement, "type"));
            }
            if (conditionElement != null) {
                ExpressionEvaluator evaluator = this.digestCondition(conditionElement);
                resourceConfig.setConditionEvaluator(evaluator);
            } else if (defaultConditionRef != null) {
                ExpressionEvaluator evaluator = this.getConditionEvaluator(defaultConditionRef);
                resourceConfig.setConditionEvaluator(evaluator);
            }
        }
        catch (IllegalArgumentException e) {
            throw new SAXException("Invalid unit definition.", e);
        }
        this.digestParameters(configElement, resourceConfig);
        this.list.add(resourceConfig);
        if (resource == null) {
            if (resourceConfig.getParameters("resdata") != null) {
                logger.warn((Object)("Resource 'null' for resource config: " + resourceConfig + ".  This is probably an error because the configuration contains a 'resdata' param, which suggests it is following the old DTD based configuration model.  The new model requires the resource to be specified in the <resource> element."));
            } else {
                logger.debug((Object)("Resource 'null' for resource config: " + resourceConfig + ". This is not invalid!"));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding smooks-resource config from [" + this.list.getName() + "]: " + resourceConfig));
        }
    }

    private void digestExtendedResourceConfig(Element configElement, String defaultSelector, String defaultNamespace, String defaultProfile, String defaultConditionRef) {
        String configNamespace = configElement.getNamespaceURI();
        Smooks configDigester = this.getExtenededConfigDigester(configNamespace);
        ExecutionContext executionContext = configDigester.createExecutionContext();
        Element conditionElement = DomUtils.getElement(configElement, "condition", 1);
        ExtensionContext extentionContext = conditionElement != null && (conditionElement.getNamespaceURI().equals(XSD_V10) || conditionElement.getNamespaceURI().equals(XSD_V11)) ? new ExtensionContext(this, defaultSelector, defaultNamespace, defaultProfile, this.digestCondition(conditionElement)) : (defaultConditionRef != null ? new ExtensionContext(this, defaultSelector, defaultNamespace, defaultProfile, this.getConditionEvaluator(defaultConditionRef)) : new ExtensionContext(this, defaultSelector, defaultNamespace, defaultProfile, null));
        ExtensionContext.setExtensionContext(extentionContext, executionContext);
        configDigester.filterSource(executionContext, new DOMSource(configElement), null);
        List<SmooksResourceConfiguration> resources = extentionContext.getResources();
        for (SmooksResourceConfiguration resource : resources) {
            this.list.add(resource);
        }
    }

    private Smooks getExtenededConfigDigester(String configNamespace) {
        Smooks smooks = this.extendedConfigDigesters.get(configNamespace);
        if (smooks == null) {
            URI namespaceURI;
            try {
                namespaceURI = new URI(configNamespace);
            }
            catch (URISyntaxException e) {
                throw new SmooksConfigurationException("Unable to parse extended config namespace URI '" + configNamespace + "'.", e);
            }
            String resourcePath = "/META-INF" + namespaceURI.getPath() + "-smooks.xml";
            File resourceFile = new File(resourcePath);
            String baseURI = resourceFile.getParent().replace('\\', '/');
            this.assertExtendedConfigOK(configNamespace, resourcePath);
            smooks = new Smooks();
            XMLConfigDigester.setExtentionDigestOn();
            try {
                try {
                    SmooksResourceConfigurationStore configStore = smooks.getApplicationContext().getStore();
                    SmooksResourceConfigurationList extConfigList = new SmooksResourceConfigurationList(baseURI);
                    XMLConfigDigester configDigester = new XMLConfigDigester(extConfigList);
                    configDigester.digestConfigRecursively(new InputStreamReader(ClassUtil.getResourceAsStream(resourcePath, this.getClass())), baseURI);
                    configStore.addSmooksResourceConfigurationList(extConfigList);
                }
                catch (Exception e) {
                    throw new SmooksConfigurationException("Failed to construct Smooks instance for processing extended configuration resource '" + resourcePath + "'.", e);
                }
            }
            finally {
                XMLConfigDigester.setExtentionDigestOff();
            }
            this.extendedConfigDigesters.put(configNamespace, smooks);
        }
        return smooks;
    }

    private void assertExtendedConfigOK(String configNamespace, String resourcePath) {
        XsdDOMValidator validator;
        Document configDoc;
        InputStream resourceStream = ClassUtil.getResourceAsStream(resourcePath, this.getClass());
        if (resourceStream == null) {
            throw new SmooksConfigurationException("Unable to locate Smooks digest configuration '" + resourcePath + "' for extended resource configuration namespace '" + configNamespace + "'.  This resource must be available on the classpath.");
        }
        try {
            configDoc = XmlUtil.parseStream(resourceStream);
        }
        catch (Exception e) {
            throw new SmooksConfigurationException("Unable to parse namespace URI '" + configNamespace + "'.", e);
        }
        try {
            validator = new XsdDOMValidator(configDoc);
        }
        catch (SAXException e) {
            throw new SmooksConfigurationException("Unable to create XsdDOMValidator instance for extended resource config '" + resourcePath + "'.", e);
        }
        String defaultNS = validator.getDefaultNamespace().toString();
        if (!XSD_V10.equals(defaultNS) && !XSD_V11.equals(defaultNS)) {
            throw new SmooksConfigurationException("Extended resource configuration '" + resourcePath + "' default namespace must be a valid Smooks configuration namespace.");
        }
        if (validator.getNamespaces().size() > 1) {
            throw new SmooksConfigurationException("Extended resource configuration '" + resourcePath + "' defines configurations from multiple namespaces.  This is not permitted.  Only use configurations from the base Smooks config namespaces e.g. '" + XSD_V11 + "'.");
        }
    }

    private static boolean isExtensionConfig() {
        return extentionDigestOn.get();
    }

    private static void setExtentionDigestOn() {
        extentionDigestOn.set(true);
    }

    private static void setExtentionDigestOff() {
        extentionDigestOn.set(false);
    }

    private static Element getElementByTagName(Element configElement, String name) {
        NodeList elements = configElement.getElementsByTagName(name);
        if (elements.getLength() != 0) {
            return (Element)elements.item(0);
        }
        return null;
    }

    private void digestConditions(Element conditionsElement) {
        NodeList conditions = conditionsElement.getElementsByTagName("condition");
        int i = 0;
        while (i < conditions.getLength()) {
            Element conditionElement = (Element)conditions.item(i);
            String id = DomUtils.getAttributeValue(conditionElement, "id");
            if (id != null) {
                this.addConditionEvaluator(id, this.digestCondition(conditionElement));
            }
            ++i;
        }
    }

    public ExpressionEvaluator digestCondition(Element conditionElement) throws SmooksConfigurationException {
        String evaluatorConditionExpression;
        String idRef = DomUtils.getAttributeValue(conditionElement, "idRef");
        if (idRef != null) {
            return this.getConditionEvaluator(idRef);
        }
        String evaluatorClassName = DomUtils.getAttributeValue(conditionElement, "evaluator");
        if (evaluatorClassName == null || evaluatorClassName.trim().equals("")) {
            evaluatorClassName = "org.milyn.javabean.expression.BeanMapExpressionEvaluator";
        }
        if ((evaluatorConditionExpression = DomUtils.getAllText(conditionElement, true)) == null || evaluatorConditionExpression.trim().equals("")) {
            throw new SmooksConfigurationException("smooks-resource/condition must specify a condition expression as child text e.g. <condition evaluator=\"....\">A + B > C</condition>.");
        }
        return ExpressionEvaluator.Factory.createInstance(evaluatorClassName, evaluatorConditionExpression);
    }

    private void digestProfiles(Element profilesElement) {
        NodeList configNodes = profilesElement.getChildNodes();
        int i = 0;
        while (i < configNodes.getLength()) {
            if (configNodes.item(i).getNodeType() == 1) {
                Element profileNode = (Element)configNodes.item(i);
                String baseProfile = DomUtils.getAttributeValue(profileNode, "base-profile");
                String subProfiles = DomUtils.getAttributeValue(profileNode, "sub-profiles");
                DefaultProfileSet profileSet = new DefaultProfileSet(baseProfile);
                if (subProfiles != null) {
                    profileSet.addProfiles(subProfiles.split(","));
                }
                this.list.add(profileSet);
            }
            ++i;
        }
    }

    private void digestParameters(Element resourceConfigElement, SmooksResourceConfiguration resourceConfig) {
        NodeList configNodes = resourceConfigElement.getElementsByTagName("param");
        int i = 0;
        while (i < configNodes.getLength()) {
            Element paramNode = (Element)configNodes.item(i);
            String paramName = DomUtils.getAttributeValue(paramNode, "name");
            String paramType = DomUtils.getAttributeValue(paramNode, "type");
            String paramValue = DomUtils.getAllText(paramNode, true);
            Parameter paramInstance = resourceConfig.setParameter(paramName, paramType, paramValue);
            paramInstance.setXML(paramNode);
            ++i;
        }
    }

    private LocalEntityResolver getDTDEntityResolver() {
        return new LocalDTDEntityResolver();
    }

    public String getCurrentPath() {
        StringBuilder pathBuilder = new StringBuilder();
        int i = this.configStack.size() - 1;
        while (i >= 0) {
            pathBuilder.insert(0, "]");
            pathBuilder.insert(0, ((SmooksConfig)this.configStack.get(i)).configFile);
            pathBuilder.insert(0, "/[");
            --i;
        }
        return pathBuilder.toString();
    }

    private void pushConfig(String file, URI fileURI) {
        for (SmooksConfig smooksConfig : this.configStack) {
            if (!fileURI.equals(smooksConfig.fileURI)) continue;
            throw new SmooksConfigurationException("Invalid circular reference to config file '" + fileURI + "' from inside config file '" + this.getCurrentPath() + "'.");
        }
        SmooksConfig config = new SmooksConfig(file);
        config.parent = this.configStack.peek();
        config.fileURI = fileURI;
        this.configStack.push(config);
    }

    private void popConfig() {
        SmooksConfig parentConfig;
        SmooksConfig currentConfig = this.configStack.pop();
        if (XSD_V11.equals(currentConfig.defaultNS) && !this.configStack.isEmpty() && (parentConfig = this.configStack.peek()).defaultNS.equals(XSD_V10)) {
            this.configStack.push(currentConfig);
            throw new SmooksConfigurationException("Unsupported import of a v1.1 configuration from inside a v1.0 configuration.  Path to configuration: '" + this.getCurrentPath() + "'.");
        }
    }

    public void addConditionEvaluator(String id, ExpressionEvaluator evaluator) {
        this.assertUniqueConditionId(id);
        this.configStack.peek().conditionEvaluators.put(id, evaluator);
    }

    public ExpressionEvaluator getConditionEvaluator(String idRef) {
        SmooksConfig smooksConfig = this.configStack.peek();
        while (smooksConfig != null) {
            ExpressionEvaluator evaluator = (ExpressionEvaluator)smooksConfig.conditionEvaluators.get(idRef);
            if (evaluator != null) {
                return evaluator;
            }
            smooksConfig = smooksConfig.parent;
        }
        throw new SmooksConfigurationException("Unknown condition idRef '" + idRef + "'.");
    }

    private void assertUniqueConditionId(String id) {
        if (this.configStack.peek().conditionEvaluators.containsKey(id)) {
            throw new SmooksConfigurationException("Duplicate condition ID '" + id + "'.");
        }
    }

    private static class SmooksConfig {
        private String defaultNS;
        private SmooksConfig parent;
        private final String configFile;
        private final Map<String, ExpressionEvaluator> conditionEvaluators = new HashMap<String, ExpressionEvaluator>();
        public URI fileURI;

        private SmooksConfig(String configFile) {
            this.configFile = configFile;
        }
    }
}

