package com.redhat.installer.tests;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;

import static junit.framework.TestCase.assertEquals;


/**
 * Created by thauser on 2/3/14.
 */
public abstract class DataValidatorTester {
    public static AutomatedInstallData idata;
    public DataValidator dv;


    @BeforeClass
    public static void initial() throws Exception {
        idata = new AutomatedInstallData();
    }

    @AfterClass
    public static void destroy() throws Exception {
        FileUtils.deleteDirectory(TestUtils.INSTALL_PATH_FILE);
        TestUtils.destroyIdataSingleton();
        idata = null;
    }

    @After
    public void end() throws Exception{
        FileUtils.deleteDirectory(TestUtils.INSTALL_PATH_FILE);
        idata.getVariables().clear();
        dv = null;
    }

    /**
     * Convenience method to expect the value Status.OK from a validateData call
     */
    public void assertOk(){
        assertEquals(DataValidator.Status.OK, dv.validateData(idata));
    }

    /**
     * Convenience method to expect the value Status.ERROR from a validateData call
     */
    public void assertError(){
        assertEquals(DataValidator.Status.ERROR, dv.validateData(idata));
    }

    /**
     * Convenience method to expect the value Status.SKIP from a validateData call
     */
    public void assertSkip(){
        assertEquals(DataValidator.Status.SKIP, dv.validateData(idata));
    }

    /**
     * Convenience method to expect the value Status.WARNING from a validateData call
     */
    public void assertWarning(){
        assertEquals(DataValidator.Status.WARNING, dv.validateData(idata));
    }

    /**
     * Convenience method to expect the value Status.FAIL from a validateData call
     */
    public void assertFail(){
        assertEquals(DataValidator.Status.FAIL, dv.validateData(idata));
    }

    /**
     * Convenience method to expect the given key from the langpack on a DataValidator.getErrorMessageId() call
     * @param key
     */
    public void assertLangpackError(String key){
        assertEquals(idata.langpack.getString(key), dv.getErrorMessageId());
    }

    /**
     * Convenience method to expect the given key from the langpack on a DataValidator.getWarningMessageId() call
     * @param key
     */
    public void assertLangpackWarning(String key){
        assertEquals(idata.langpack.getString(key), dv.getWarningMessageId());
    }
}
