package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import org.apache.commons.lang.SystemUtils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class TomcatModifySetenv {

    private static AbstractUIProcessHandler mHandler;
    private static AutomatedInstallData idata;
    private static final String linuxFileText = "export CATALINA_OPTS=\"$CATALINA_OPTS -Xmx512M -Dorg.kie.server.id=tomcat-kieserver -Dorg.kie.server.location=http://localhost:8080/kie-server/services/rest/server -Dorg.kie.server.controller=http://localhost:8080/controller/rest/controller -Dorg.jbpm.server.ext.disabled=true -Dorg.jbpm.ui.server.ext.disabled=true -Dorg.jbpm.case.server.ext.disabled=true\"";
    private static final String windowsFileText = "set \"CATALINA_OPTS=%CATALINA_OPTS% -Xmx512M -Dorg.kie.server.id=tomcat-kieserver -Dorg.kie.server.location=http://localhost:8080/kie-server/services/rest/server -Dorg.kie.server.controller=http://localhost:8080/controller/rest/controller -Dorg.jbpm.server.ext.disabled=true -Dorg.jbpm.ui.server.ext.disabled=true -Dorg.jbpm.case.server.ext.disabled=true\"";

    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        mHandler = handler;
        idata = AutomatedInstallData.getInstance();
        return modifyTomcatSetenv();
    }

    private static boolean modifyTomcatSetenv() {
        try {
            Path setenvPath;
            String textToWrite;
            if (SystemUtils.IS_OS_WINDOWS) {
                setenvPath = Paths.get(idata.getInstallPath() + "/bin/setenv.bat");
                textToWrite = windowsFileText;
            } else {
                setenvPath = Paths.get(idata.getInstallPath() + "/bin/setenv.sh");
                textToWrite = linuxFileText;
            }

            Files.write(setenvPath, textToWrite.getBytes(), Files.exists(setenvPath) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
        } catch (IOException e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.setenv.writefailed"), false);
            ProcessPanelHelper.printExceptionToLog(e.getStackTrace());
            return false;
        }
        return true;
    }
}
