package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;

import org.jboss.dmr.ModelNode;
import org.jsoup.select.Elements;
import org.jsoup.nodes.Element;
import java.util.List;

/**
 * Created by mvaghela on 16/06/15.
 */
public class SystemProperties extends PostInstallation {

    @Override
    protected Class getClassName() {
        return SystemProperties.class;
    }

    @Override
    protected boolean performOperation() {
        return setSystemProperties();
    }

    protected boolean setSystemProperties(){
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        Elements element = (Elements)idata.getAttribute("system-properties");
        boolean result = true;

        for(Element property : element) {
            String propertyName = property.attr("name");
            String propertyValue = property.attr("value");
            idata.setVariable(propertyName, propertyValue);
            //TODO: log this somehow.
            result = result && serverCommands.addSystemProperty(propertyName, propertyValue);
        }
        return result;
    }
}
