#!/bin/bash

# Git clone the other repositories
# usage ./git-all.sh username [git command]

printUsage() {
    echo
    echo "Usage:"
    echo "  $0 <additional git options> [--repo-list=<list-of-repositories>|--target-repo=<repository>] [--add-upstream-remote]"
    echo "For example:"
    echo "  $0"
    echo "  $0 --bare"
    echo "  $0 --repo-list=droolsjbpm-knowledge,drools"
    echo "  $0 --target-repo=drools-wb"
    echo "In case you are cloning your forks, the following option will create a second remote called upstream"
    echo "pointing to kiegroup. It can be useful for keeping your forks up to date:"
    echo "  $0 --add-upstream-remote"
    echo
}

# removes the first argument
for arg in "$@"; do
    user=$arg
    shift
    break
done

startDateTime=`date +%s`

GIT_ARG_LINE=("$@")

rm community_repository-list.txt
rm repository-list.txt
# default repository list is stored in the repository-list.txt file
curl -o community_repository-list.txt https://raw.githubusercontent.com/kiegroup/droolsjbpm-build-bootstrap/master/script/repository-list.txt
sed -i -e 's/^/kiegroup\//' community_repository-list.txt
cat *repository*list.txt > repository-list.txt
rm community_repository-list.txt

REPOSITORY_LIST=`cat "repository-list.txt"`
GERRIT_PREFIX="ssh://${user}@code.engineering.redhat.com/"
CURRENT_DIR=`pwd`


echo "Git arg. line=${GIT_ARG_LINE[@]}"
for repository in $REPOSITORY_LIST ; do
    echo
    if [ -d $repository ] ; then
        echo "==============================================================================="
        echo "This directory already exists: $repository"
        echo "==============================================================================="
    else
        echo "==============================================================================="
        echo "Repository: $repository"
        echo "==============================================================================="
        gitUrlPrefix=${GERRIT_PREFIX}
        echo -- prefix ${GERRIT_PREFIX} --
        echo -- repository ${repository} --
        echo -- ${GERRIT_PREFIX}${repository}.git -- ${repository} --
        git clone ${gitUrlPrefix}${repository}.git ${repository}
    fi

    cd ${repository}
    git "${GIT_ARG_LINE[@]}"
    cd ${CURRENT_DIR}

    returnCode=$?
    if [ $returnCode != 0 ] ; then
        exit $returnCode
    fi
done

echo
echo Disk size:

for repository in `cat "repository-list.txt"` ; do
    du -sh $repository
done

endDateTime=`date +%s`
spentSeconds=`expr $endDateTime - $startDateTime`

echo
echo "Total time: ${spentSeconds}s"
