
package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.EmbeddedController;
import com.redhat.installer.asconfiguration.ascontroller.EmbeddedServerCommands;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import com.redhat.installer.logging.InstallationLogger;
import org.jboss.as.cli.CommandContext;
import org.jboss.dmr.ModelNode;

import java.util.List;

/**
 * @author dcheung@redhat.com, dmondega@redhat.com, thauser@redhat.com
 */
public abstract class PostInstallation {
    protected static final String DESCRIPTOR = "xml-file";
    protected static EmbeddedServerCommands serverCommands;
    protected static AbstractUIProcessHandler mHandler;
    protected static ArgumentParser parser;
    protected static String xmlDescriptor;
    protected static String[] arguments;

    protected abstract Class getClassName();
    protected abstract boolean performOperation();

    public boolean run(AbstractUIProcessHandler handler, String[] args) {
        initPostInstallation(handler, args, getClassName());
        boolean result = performOperation();
        serverCommands = null;
        return result;
    }

    /**
     * PostInstallation cleanup: write to log, print errors to panel, checks for failures, terminate the
     *                           connection to the server, and return the result of the installation
     *
     */
    protected static boolean installResult(List<ModelNode> results) {
        boolean failed = false;
        if (results == null){
            return failed;
        }
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        List<ModelNode> failures = ServerCommandsHelper.findFailures(results);
        if (!failures.isEmpty()) {
            failed = true;
            // errors
            // print the failed command(s)
            for (ModelNode failure : failures) {
                // command that failed
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("postinstall.processpanel.command.failure"), ServerCommandsHelper.getCommand(failure)), true);
                // ModelNode result
                ProcessPanelHelper.printToPanel(mHandler, failure.toString(), true);
            }
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.success"), false);
        }
        return !failed;
    }

    /**
     * Gives a ServerCommands instance back that is appropriate for the current server execution.
     *
     * @param caller The classname of the class that is getting the ServerCommands, to instantiate the logger correctly.
     * @return
     **/
    public static EmbeddedServerCommands initServerCommands(Class caller) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        EmbeddedServerCommands serverCommands = new EmbeddedServerCommands();
        boolean isDomain = idata.getAttribute("embedded.domain") != null;
        if (isDomain) {
            serverCommands.setCommandContext((CommandContext) idata.getAttribute("embedded.domain"));
            serverCommands.setIsDomain(true);
            if (EmbeddedController.isSlave()){
                serverCommands.setIsSlave(true);
            }
        } else {
            serverCommands.setCommandContext((CommandContext) idata.getAttribute("embedded.standalone"));
            serverCommands.setIsDomain(false);
        }
        serverCommands.setLogger(InstallationLogger.getLogger());
        return serverCommands;
    }

    protected static void initPostInstallation(AbstractUIProcessHandler handler, String[] args, Class c) {
        mHandler = handler;
        serverCommands = initServerCommands(c);
        arguments = args;
        parser = new ArgumentParser();
        parser.parse(args);
        if (parser.hasProperty(DESCRIPTOR)) {
            xmlDescriptor = parser.getStringProperty(DESCRIPTOR);
        }
    }


}
