package com.redhat.installer.asconfiguration.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SetBxmsUserRoles implements PanelAction {

    private static Map<String,String> roleMap = new LinkedHashMap<>();
    static {
        roleMap.put("role.administrator", "admin");
        roleMap.put("role.kieserver", "kie-server");
        roleMap.put("role.restall", "rest-all");
        roleMap.put("role.analyst", "analyst");
        roleMap.put("role.developer", "developer");
        roleMap.put("role.user", "user");
        roleMap.put("role.manager", "manager");
        roleMap.put("role.processadmin", "process-admin");
    }

    @Override
    public void executeAction(AutomatedInstallData adata, AbstractUIHandler handler) {
        String finalRolesString = getSelectedRoles(adata);
        adata.setVariable("user.final.roles", finalRolesString);
    }

    private String getSelectedRoles(AutomatedInstallData adata){
        List<String> selectedRoles = new ArrayList<>(0);
        for (String var : roleMap.keySet()){
            String value = adata.getVariable(var);
            if (value != null && Boolean.parseBoolean(value)){
                selectedRoles.add(roleMap.get(var));
            }
        }
        return selectedRoles.stream().distinct().collect(Collectors.joining(","));
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {

    }
}
