/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.HashSet;

import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.MetaDataType;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import static org.junit.Assert.assertEquals;
import static org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories.bpmn2;
import static org.powermock.api.mockito.PowerMockito.when;

@RunWith(MockitoJUnitRunner.class)
public class DataObjectPropertyWriterTest {

    public static final String NAME = "name";

    private DataObjectPropertyWriter tested;

    private DataObjectReference reference = bpmn2.createDataObjectReference();

    @Mock
    private VariableScope variableScope;

    @Mock
    private ExtensionAttributeValue extensionAttributeValue;

    @Mock
    private FeatureMap valueMap;

    @Mock
    private MetaDataType metaDataType;

    @Before
    public void setUp() {
        when(extensionAttributeValue.getValue()).thenReturn(valueMap);
        when(metaDataType.getName()).thenReturn(CustomElement.name.name());
        tested = new DataObjectPropertyWriter(reference, variableScope, new HashSet<>());
    }

    @Test
    public void setName() {
        tested.setName(NAME);
        assertEquals(NAME, reference.getDataObjectRef().getName());
        tested.setName(NAME);
        assertEquals(NAME, reference.getDataObjectRef().getName());
    }

    @Test
    public void setType() {
        tested.setType(NAME);
        assertEquals(NAME, reference.getDataObjectRef().getItemSubjectRef().getStructureRef());
    }

    @Test
    public void getDataObjects() {
        assertEquals(0, tested.getDataObjects().size());
    }

    @Test
    public void getElement() {
        assertEquals(reference, tested.getElement());
    }
}