/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.xml.security.Init;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.element.EncryptedKey;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.SecurityProcess;
import org.jboss.ws.extensions.security.element.Signature;
import org.jboss.ws.extensions.security.element.Timestamp;
import org.jboss.ws.extensions.security.element.Token;
import org.jboss.ws.extensions.security.element.UsernameToken;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.nonce.NonceFactory;
import org.jboss.ws.extensions.security.operation.DecryptionOperation;
import org.jboss.ws.extensions.security.operation.ReceiveUsernameOperation;
import org.jboss.ws.extensions.security.operation.RequireEncryptionOperation;
import org.jboss.ws.extensions.security.operation.RequireOperation;
import org.jboss.ws.extensions.security.operation.RequireSignatureOperation;
import org.jboss.ws.extensions.security.operation.SignatureVerificationOperation;
import org.jboss.ws.extensions.security.operation.TimestampVerificationOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityDecoder {
    private Element headerElement;
    private Calendar now = null;
    private SecurityHeader header;
    private Document message;
    private NonceFactory nonceFactory;
    private SecurityStore store;
    private HashSet<String> signedIds = new HashSet();
    private HashSet<String> encryptedIds = new HashSet();

    public SecurityDecoder(SecurityStore store, NonceFactory nonceFactory) {
        Init.init();
        this.store = store;
        this.nonceFactory = nonceFactory;
    }

    public SecurityDecoder(SecurityStore store, Calendar now, NonceFactory nonceFactory) {
        this(store, nonceFactory);
        this.now = now;
    }

    private Element getHeader(Document message) throws WSSecurityException {
        Element header = Util.findElement(message.getDocumentElement(), "Security", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (header == null) {
            throw new WSSecurityException("Expected security header was not found");
        }
        return header;
    }

    private void detachHeader() {
        this.headerElement.getParentNode().removeChild(this.headerElement);
    }

    private void decode() throws WSSecurityException {
        Timestamp timestamp = this.header.getTimestamp();
        if (timestamp != null) {
            TimestampVerificationOperation operation = this.now == null ? new TimestampVerificationOperation() : new TimestampVerificationOperation(this.now);
            operation.process(this.message, timestamp);
        }
        for (Token token : this.header.getTokens()) {
            if (!(token instanceof UsernameToken)) continue;
            new ReceiveUsernameOperation(this.header, this.store, this.nonceFactory != null ? this.nonceFactory.getStore() : null).process(this.message, token);
        }
        this.signedIds.clear();
        this.encryptedIds.clear();
        SignatureVerificationOperation signatureVerifier = new SignatureVerificationOperation(this.header, this.store);
        DecryptionOperation decrypter = new DecryptionOperation(this.header, this.store);
        for (SecurityProcess process : this.header.getSecurityProcesses()) {
            Collection<String> ids;
            if (process instanceof Signature) {
                ids = signatureVerifier.process(this.message, process);
                if (ids == null) continue;
                this.signedIds.addAll(ids);
                continue;
            }
            if (!(process instanceof EncryptedKey) || (ids = decrypter.process(this.message, process)) == null) continue;
            this.encryptedIds.addAll(ids);
        }
    }

    public void verify(List<RequireOperation> requireOperations) throws WSSecurityException {
        if (requireOperations == null) {
            return;
        }
        for (RequireOperation op : requireOperations) {
            HashSet<String> processedIds = null;
            if (op instanceof RequireSignatureOperation) {
                processedIds = this.signedIds;
            } else if (op instanceof RequireEncryptionOperation) {
                processedIds = this.encryptedIds;
            }
            op.process(this.message, this.header, processedIds);
        }
    }

    public void decode(Document message) throws WSSecurityException {
        this.decode(message, this.getHeader(message));
    }

    public void decode(Document message, Element headerElement) throws WSSecurityException {
        this.headerElement = headerElement;
        this.header = new SecurityHeader(this.headerElement, this.store);
        this.message = message;
        this.decode();
    }

    public void complete() {
        this.detachHeader();
    }
}

