/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.adapter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.model.adapter.IModelObjectAdapter;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.osgi.framework.Bundle;

public class ModelObjectAdapterExtensionPoint {
    static String POINT_ID = "org.jboss.tools.common.model.modelObjectAdapter";
    static ModelObjectAdapterExtensionPoint instance;
    IExtensionPoint point = null;
    Map<String, Class> adapters = new HashMap<String, Class>();

    public static ModelObjectAdapterExtensionPoint getInstance() {
        if (instance == null) {
            instance = new ModelObjectAdapterExtensionPoint();
            instance.init();
        }
        return instance;
    }

    private ModelObjectAdapterExtensionPoint() {
    }

    private void init() {
        this.point = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID);
        IExtension[] es = this.point.getExtensions();
        int i = 0;
        while (i < es.length) {
            IConfigurationElement[] cs = es[i].getConfigurationElements();
            int j = 0;
            while (j < cs.length) {
                block6: {
                    Bundle bundle = Platform.getBundle((String)es[i].getNamespaceIdentifier());
                    String iclassname = cs[j].getAttribute("iclass");
                    String classname = cs[j].getAttribute("class");
                    Class cls = null;
                    try {
                        cls = bundle.loadClass(classname);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ModelPlugin.getPluginLog().logError("Cannot load editor class " + classname + " from " + es[i].getNamespaceIdentifier());
                        break block6;
                    }
                    if (!IModelObjectAdapter.class.isAssignableFrom(cls)) {
                        ModelPlugin.getPluginLog().logInfo("Class " + classname + " must implement IModelObjectAdapter");
                    } else {
                        this.adapters.put(iclassname, cls);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public IModelObjectAdapter getAdapter(String iclassname) {
        Class cls = this.adapters.get(iclassname);
        try {
            if (cls != null) {
                return (IModelObjectAdapter)cls.newInstance();
            }
        }
        catch (InstantiationException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return null;
    }
}

