/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.util.List;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Namespace;
import org.teiid.query.sql.lang.Criteria;

public class MappingRecursiveElement
extends MappingElement {
    List criteriaGroups;
    Criteria criteriaNode;

    public MappingRecursiveElement(String name, String mappingClass) {
        super(name);
        this.setProperty(MappingNodeConstants.Properties.IS_RECURSIVE, Boolean.TRUE);
        this.setProperty(MappingNodeConstants.Properties.RECURSION_ROOT_MAPPING_CLASS, mappingClass);
    }

    public MappingRecursiveElement(String name, Namespace namespace, String mappingClass) {
        super(name, namespace);
        this.setProperty(MappingNodeConstants.Properties.IS_RECURSIVE, Boolean.TRUE);
        this.setProperty(MappingNodeConstants.Properties.RECURSION_ROOT_MAPPING_CLASS, mappingClass);
    }

    @Override
    public void acceptVisitor(MappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    public MappingRecursiveElement setCriteria(String criteria) {
        if (criteria != null && criteria.length() > 0) {
            criteria = criteria.trim();
            this.setProperty(MappingNodeConstants.Properties.RECURSION_CRITERIA, criteria);
        }
        return this;
    }

    public MappingRecursiveElement setRecursionLimit(int depth, boolean execeptionOnBreach) {
        this.setProperty(MappingNodeConstants.Properties.RECURSION_LIMIT, new Integer(depth));
        this.setProperty(MappingNodeConstants.Properties.EXCEPTION_ON_RECURSION_LIMIT, execeptionOnBreach);
        return this;
    }

    public String getMappingClass() {
        return (String)this.getProperty(MappingNodeConstants.Properties.RECURSION_ROOT_MAPPING_CLASS);
    }

    public String getCriteria() {
        return (String)this.getProperty(MappingNodeConstants.Properties.RECURSION_CRITERIA);
    }

    public int getRecursionLimit() {
        Integer limit = (Integer)this.getProperty(MappingNodeConstants.Properties.RECURSION_LIMIT);
        if (limit != null) {
            return limit;
        }
        return MappingNodeConstants.Defaults.DEFAULT_RECURSION_LIMIT;
    }

    public boolean throwExceptionOnRecurrsionLimit() {
        Boolean breached = (Boolean)this.getProperty(MappingNodeConstants.Properties.EXCEPTION_ON_RECURSION_LIMIT);
        if (breached != null) {
            return breached;
        }
        return MappingNodeConstants.Defaults.DEFAULT_EXCEPTION_ON_RECURSION_LIMIT;
    }

    public void setGroupsInCriteria(List criteriaGroups) {
        this.criteriaGroups = criteriaGroups;
    }

    public List getGroupsInCriteria() {
        return this.criteriaGroups;
    }

    public void setCriteriaNode(Criteria node) {
        this.criteriaNode = node;
    }

    public Criteria getCriteriaNode() {
        return this.criteriaNode;
    }
}

