/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.List;
import java.util.Map;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.xml.WhileInstruction;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.util.VariableContext;

public class JoinedWhileInstruction
extends WhileInstruction {
    private Integer mappingClassNumber;
    private ElementSymbol mappingClassSymbol;
    private String originalResultSet;

    public JoinedWhileInstruction(String rsName, Integer mappingClassNumber, ElementSymbol mappingClassSymbol, String originalResultSet) {
        super(rsName);
        this.mappingClassNumber = mappingClassNumber;
        this.mappingClassSymbol = mappingClassSymbol;
        this.originalResultSet = originalResultSet;
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        Map previousValues;
        List values = context.getCurrentRow(this.getResultSetName());
        if (values == null) {
            env.incrementCurrentProgramCounter();
            return context;
        }
        List outputElements = context.getOutputElements(this.getResultSetName());
        int index = outputElements.indexOf(this.mappingClassSymbol);
        Object value = values.get(index);
        VariableContext varContext = context.getVariableContext();
        if (value == null) {
            if (Boolean.TRUE.equals(this.getFirst(varContext))) {
                context.getNextRow(this.getResultSetName());
            }
            this.setFirst(varContext, Boolean.TRUE);
            env.incrementCurrentProgramCounter();
            return context;
        }
        boolean canConsume = true;
        if (!Boolean.TRUE.equals(this.getFirst(varContext)) && (previousValues = this.getPreviousValues(varContext)) != null) {
            for (int i = 0; i < index - 1 && canConsume; ++i) {
                Object previousValue = previousValues.get(outputElements.get(i));
                Object currentValue = values.get(i);
                if (previousValue != null) {
                    if (previousValue.equals(currentValue)) continue;
                    canConsume = false;
                    continue;
                }
                if (currentValue == null) continue;
                canConsume = false;
            }
        }
        if (!value.equals(this.mappingClassNumber) || !canConsume) {
            this.setFirst(varContext, Boolean.TRUE);
            env.incrementCurrentProgramCounter();
            return context;
        }
        this.setPreviousValues(varContext, context.getReferenceValues());
        this.pushProgram(env, context, values);
        this.setFirst(varContext, Boolean.FALSE);
        return context;
    }

    @Override
    Boolean getFirst(VariableContext varContext) {
        return (Boolean)varContext.getValue(new ElementSymbol("$" + this.getResultSetName() + "$" + this.originalResultSet + "$first"));
    }

    @Override
    void setFirst(VariableContext varContext, Boolean value) {
        varContext.setValue(new ElementSymbol("$" + this.getResultSetName() + "$" + this.originalResultSet + "$first"), value);
    }

    @Override
    public String toString() {
        return "JOINED " + this.originalResultSet + " " + super.toString();
    }

    @Override
    public PlanNode getDescriptionProperties() {
        return new PlanNode("JOINED LOOP");
    }
}

