/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language.visitor;

import org.teiid.connector.DataPlugin;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.Argument;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Delete;
import org.teiid.language.DerivedColumn;
import org.teiid.language.DerivedTable;
import org.teiid.language.Exists;
import org.teiid.language.Function;
import org.teiid.language.GroupBy;
import org.teiid.language.In;
import org.teiid.language.Insert;
import org.teiid.language.IsNull;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Not;
import org.teiid.language.OrderBy;
import org.teiid.language.ScalarSubquery;
import org.teiid.language.SearchedCase;
import org.teiid.language.SearchedWhenClause;
import org.teiid.language.Select;
import org.teiid.language.SetClause;
import org.teiid.language.SetQuery;
import org.teiid.language.SortSpecification;
import org.teiid.language.SubqueryComparison;
import org.teiid.language.SubqueryIn;
import org.teiid.language.Update;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.language.visitor.LanguageObjectVisitor;

public class DelegatingHierarchyVisitor
extends HierarchyVisitor {
    private LanguageObjectVisitor postVisitor = null;
    private LanguageObjectVisitor preVisitor = null;

    public DelegatingHierarchyVisitor(LanguageObjectVisitor preProcessingDelegate, LanguageObjectVisitor postProcessingDelegate) {
        if (preProcessingDelegate == null && postProcessingDelegate == null) {
            throw new IllegalArgumentException(DataPlugin.Util.getString("DelegatingHierarchyVisitor.The_pre-_and_post-processing_visitors_cannot_both_be_null._1"));
        }
        this.preVisitor = preProcessingDelegate;
        this.postVisitor = postProcessingDelegate;
    }

    protected LanguageObjectVisitor getPostVisitor() {
        return this.postVisitor;
    }

    protected LanguageObjectVisitor getPreVisitor() {
        return this.preVisitor;
    }

    @Override
    public void visit(AggregateFunction obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(BatchedUpdates obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Comparison obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(AndOr obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Delete obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(ColumnReference obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Call obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Exists obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Function obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(NamedTable obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(GroupBy obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(In obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(DerivedTable obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Insert obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(IsNull obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Join obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Like obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Limit obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Literal obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Not obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(OrderBy obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(SortSpecification obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Argument obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Select obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(ScalarSubquery obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(SearchedCase obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(DerivedColumn obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(SubqueryComparison obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(SubqueryIn obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(SetQuery obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(Update obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(SetClause obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    @Override
    public void visit(SearchedWhenClause obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public static void preOrderVisit(LanguageObjectVisitor behaviorVisitor, LanguageObject object) {
        DelegatingHierarchyVisitor hierarchyVisitor = new DelegatingHierarchyVisitor(behaviorVisitor, null);
        object.acceptVisitor(hierarchyVisitor);
    }

    public static void postOrderVisit(LanguageObjectVisitor behaviorVisitor, LanguageObject object) {
        DelegatingHierarchyVisitor hierarchyVisitor = new DelegatingHierarchyVisitor(null, behaviorVisitor);
        object.acceptVisitor(hierarchyVisitor);
    }
}

