/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.Set;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.ArithmeticOperator;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ArithmeticOperand
implements DynamicOperand {
    private static final long serialVersionUID = 1L;
    private final Set<SelectorName> selectorNames;
    private final ArithmeticOperator operator;
    private final DynamicOperand left;
    private final DynamicOperand right;
    private final int hc;

    public ArithmeticOperand(DynamicOperand left, ArithmeticOperator operator, DynamicOperand right) {
        CheckArg.isNotNull((Object)((Object)operator), (String)"operator");
        this.selectorNames = SelectorName.nameSetFrom(left.selectorNames(), right.selectorNames());
        this.operator = operator;
        this.left = left;
        this.right = right;
        this.hc = HashCode.compute((Object[])new Object[]{left, operator, right});
    }

    @Override
    public Set<SelectorName> selectorNames() {
        return this.selectorNames;
    }

    public ArithmeticOperator operator() {
        return this.operator;
    }

    public DynamicOperand left() {
        return this.left;
    }

    public DynamicOperand right() {
        return this.right;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArithmeticOperand) {
            ArithmeticOperand that = (ArithmeticOperand)obj;
            return this.operator() == that.operator() && this.left().equals(that.left()) && this.right().equals(that.right());
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

