/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.plugins.types.MutableCompositeMetaType;
import org.jboss.metatype.spi.values.MetaMapper;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;

public class WorkerPoolStatisticsMetadataMapper
extends MetaMapper<WorkerPoolStatisticsMetadata> {
    private static final String MAX_THREADS = "maxThreads";
    private static final String HIGHEST_QUEUED = "highestQueued";
    private static final String QUEUED = "queued";
    private static final String QUEUE_NAME = "queueName";
    private static final String TOTAL_SUBMITTED = "totalSubmitted";
    private static final String TOTAL_COMPLETED = "totalCompleted";
    private static final String HIGHEST_ACTIVE_THREADS = "highestActiveThreads";
    private static final String ACTIVE_THREADS = "activeThreads";
    private static final MutableCompositeMetaType metaType;
    private static final MetaValueFactory metaValueFactory;

    public Type mapToType() {
        return WorkerPoolStatisticsMetadata.class;
    }

    public MetaType getMetaType() {
        return metaType;
    }

    public MetaValue createMetaValue(MetaType metaType, WorkerPoolStatisticsMetadata object) {
        if (object == null) {
            return null;
        }
        if (metaType instanceof CompositeMetaType) {
            CompositeMetaType composite = (CompositeMetaType)metaType;
            CompositeValueSupport transaction = new CompositeValueSupport(composite);
            transaction.set(ACTIVE_THREADS, (MetaValue)SimpleValueSupport.wrap((int)object.getActiveThreads()));
            transaction.set(HIGHEST_ACTIVE_THREADS, (MetaValue)SimpleValueSupport.wrap((int)object.getHighestActiveThreads()));
            transaction.set(TOTAL_COMPLETED, (MetaValue)SimpleValueSupport.wrap((long)object.getTotalCompleted()));
            transaction.set(TOTAL_SUBMITTED, (MetaValue)SimpleValueSupport.wrap((long)object.getTotalSubmitted()));
            transaction.set(QUEUE_NAME, (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)object.getQueueName())));
            transaction.set(QUEUED, (MetaValue)SimpleValueSupport.wrap((int)object.getQueued()));
            transaction.set(HIGHEST_QUEUED, (MetaValue)SimpleValueSupport.wrap((int)object.getHighestQueued()));
            transaction.set(MAX_THREADS, (MetaValue)SimpleValueSupport.wrap((int)object.getMaxThreads()));
            return transaction;
        }
        throw new IllegalArgumentException("Cannot convert Worker Pool Statistics " + object);
    }

    public WorkerPoolStatisticsMetadata unwrapMetaValue(MetaValue metaValue) {
        if (metaValue == null) {
            return null;
        }
        if (metaValue instanceof CompositeValue) {
            CompositeValue compositeValue = (CompositeValue)metaValue;
            WorkerPoolStatisticsMetadata stats = new WorkerPoolStatisticsMetadata();
            stats.setActiveThreads((Integer)metaValueFactory.unwrap(compositeValue.get(ACTIVE_THREADS)));
            stats.setHighestActiveThreads((Integer)metaValueFactory.unwrap(compositeValue.get(HIGHEST_ACTIVE_THREADS)));
            stats.setTotalCompleted((Long)metaValueFactory.unwrap(compositeValue.get(TOTAL_COMPLETED)));
            stats.setTotalSubmitted((Long)metaValueFactory.unwrap(compositeValue.get(TOTAL_SUBMITTED)));
            stats.setQueueName((String)metaValueFactory.unwrap(compositeValue.get(QUEUE_NAME)));
            stats.setQueued((Integer)metaValueFactory.unwrap(compositeValue.get(QUEUED)));
            stats.setHighestQueued((Integer)metaValueFactory.unwrap(compositeValue.get(HIGHEST_QUEUED)));
            stats.setMaxThreads((Integer)metaValueFactory.unwrap(compositeValue.get(MAX_THREADS)));
            return stats;
        }
        throw new IllegalStateException("Unable to unwrap transaction " + metaValue);
    }

    static {
        metaValueFactory = MetaValueFactory.getInstance();
        metaType = new MutableCompositeMetaType(WorkerPoolStatisticsMetadata.class.getName(), "The Worker Pool statistics");
        metaType.addItem(ACTIVE_THREADS, "ActiveThreads", (MetaType)SimpleMetaType.INTEGER_PRIMITIVE);
        metaType.addItem(HIGHEST_ACTIVE_THREADS, "HighestActiveThreads", (MetaType)SimpleMetaType.INTEGER_PRIMITIVE);
        metaType.addItem(TOTAL_COMPLETED, "TotalCompleted", (MetaType)SimpleMetaType.LONG_PRIMITIVE);
        metaType.addItem(TOTAL_SUBMITTED, "TotalSubmitted", (MetaType)SimpleMetaType.LONG_PRIMITIVE);
        metaType.addItem(QUEUE_NAME, "QueueName", (MetaType)SimpleMetaType.STRING);
        metaType.addItem(QUEUED, "Queued", (MetaType)SimpleMetaType.INTEGER_PRIMITIVE);
        metaType.addItem(HIGHEST_QUEUED, "HighestQueued", (MetaType)SimpleMetaType.INTEGER_PRIMITIVE);
        metaType.addItem(MAX_THREADS, "MaxThreads", (MetaType)SimpleMetaType.INTEGER_PRIMITIVE);
        metaType.freeze();
    }
}

