/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.HostInfo;
import org.teiid.net.ServerConnection;
import org.teiid.net.socket.ServerDiscovery;
import org.teiid.net.socket.SingleInstanceCommunicationException;
import org.teiid.net.socket.SocketServerInstance;
import org.teiid.net.socket.SocketServerInstanceFactory;
import org.teiid.net.socket.SocketServerInstanceImpl;

public class SocketServerConnection
implements ServerConnection {
    private static final int FAILOVER_PING_INTERVAL = 1000;
    private SocketServerInstanceFactory connectionFactory;
    private ServerDiscovery serverDiscovery;
    private static Logger log = Logger.getLogger("org.teiid.client.sockets");
    private boolean secure;
    private Properties connProps;
    private SocketServerInstance serverInstance;
    private LogonResult logonResult;
    private Map<HostInfo, LogonResult> logonResults = new ConcurrentHashMap<HostInfo, LogonResult>();
    private ILogon logon;
    private boolean closed;
    private boolean failOver;
    private long lastPing = System.currentTimeMillis();
    private int pingFailOverInterval = 1000;

    public SocketServerConnection(SocketServerInstanceFactory connectionFactory, boolean secure, ServerDiscovery serverDiscovery, Properties connProps) throws CommunicationException, ConnectionException {
        this.connectionFactory = connectionFactory;
        this.serverDiscovery = serverDiscovery;
        this.connProps = connProps;
        this.secure = secure;
        this.logon = this.getService(ILogon.class);
        this.failOver = Boolean.valueOf(connProps.getProperty("autoFailover"));
        this.failOver |= Boolean.valueOf(connProps.getProperty("admin")).booleanValue();
        this.selectServerInstance();
    }

    public synchronized SocketServerInstance selectServerInstance() throws CommunicationException, ConnectionException {
        if (this.closed) {
            throw new CommunicationException(JDBCPlugin.Util.getString("SocketServerConnection.closed"));
        }
        if (this.serverInstance != null && (!this.failOver || this.serverInstance.isOpen())) {
            return this.serverInstance;
        }
        List<HostInfo> hostKeys = new ArrayList<HostInfo>(this.serverDiscovery.getKnownHosts(this.logonResult, null));
        boolean discoverHosts = true;
        this.closeServerInstance();
        ArrayList<HostInfo> hostCopy = new ArrayList<HostInfo>(hostKeys);
        int knownHosts = hostKeys.size();
        while (hostKeys.size() > 0) {
            HostInfo hostInfo = this.serverDiscovery.selectNextInstance(hostKeys);
            Exception ex = null;
            try {
                if (!hostInfo.isResolved()) {
                    hostInfo = new HostInfo(hostInfo.getHostName(), new InetSocketAddress(hostInfo.getInetAddress(), hostInfo.getPortNumber()));
                }
                ILogon newLogon = this.connect(hostInfo);
                if (this.logonResult == null) {
                    try {
                        List<HostInfo> updatedHosts;
                        this.logonResult = newLogon.logon(this.connProps);
                        this.logonResults.put(this.serverInstance.getHostInfo(), this.logonResult);
                        this.connectionFactory.connected(this.serverInstance, this.logonResult.getSessionToken());
                        this.serverDiscovery.connectionSuccessful(hostInfo);
                        if (discoverHosts && (updatedHosts = this.serverDiscovery.getKnownHosts(this.logonResult, this.serverInstance)).size() > 1 && new HashSet<HostInfo>(updatedHosts).size() > new HashSet<HostInfo>(hostCopy).size()) {
                            hostKeys = updatedHosts;
                            this.closeServerInstance();
                            discoverHosts = false;
                            continue;
                        }
                    }
                    catch (LogonException e) {
                        throw new ConnectionException(e, e.getMessage());
                    }
                    catch (TeiidComponentException e) {
                        if (e.getCause() instanceof CommunicationException) {
                            throw (CommunicationException)e.getCause();
                        }
                        throw new CommunicationException(e, JDBCPlugin.Util.getString("PlatformServerConnectionFactory.Unable_to_find_a_component_used_in_logging_on_to"));
                    }
                }
                return this.serverInstance;
            }
            catch (IOException e) {
                ex = e;
            }
            catch (SingleInstanceCommunicationException e) {
                ex = e;
            }
            this.serverDiscovery.markInstanceAsBad(hostInfo);
            if (knownHosts == 1) {
                if (ex instanceof UnknownHostException) {
                    throw new SingleInstanceCommunicationException(ex, JDBCPlugin.Util.getString("SocketServerInstance.Connection_Error.Unknown_Host", hostInfo.getHostName()));
                }
                throw new SingleInstanceCommunicationException(ex, JDBCPlugin.Util.getString("SocketServerInstance.Connection_Error.Connect_Failed", hostInfo.getHostName(), String.valueOf(hostInfo.getPortNumber()), ex.getMessage()));
            }
            log.log(Level.FINE, "Unable to connect to host", ex);
        }
        throw new CommunicationException(JDBCPlugin.Util.getString("SocketServerInstancePool.No_valid_host_available", ((Object)hostCopy).toString()));
    }

    private ILogon connect(HostInfo hostInfo) throws CommunicationException, IOException {
        hostInfo.setSsl(this.secure);
        this.serverInstance = this.connectionFactory.getServerInstance(hostInfo);
        this.logonResult = this.logonResults.get(hostInfo);
        ILogon newLogon = this.serverInstance.getService(ILogon.class);
        if (this.logonResult != null) {
            try {
                newLogon.assertIdentity(this.logonResult.getSessionToken());
            }
            catch (TeiidException e) {
                this.disconnect();
            }
        }
        return newLogon;
    }

    @Override
    public <T> T getService(Class<T> iface) {
        return iface.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new SocketServerInstanceImpl.RemoteInvocationHandler(iface){

            @Override
            protected SocketServerInstance getInstance() throws CommunicationException {
                if (SocketServerConnection.this.failOver && System.currentTimeMillis() - SocketServerConnection.this.lastPing > (long)SocketServerConnection.this.pingFailOverInterval) {
                    try {
                        ResultsFuture<?> future = SocketServerConnection.this.selectServerInstance().getService(ILogon.class).ping();
                        future.get();
                    }
                    catch (SingleInstanceCommunicationException e) {
                        SocketServerConnection.this.closeServerInstance();
                    }
                    catch (CommunicationException e) {
                        throw e;
                    }
                    catch (InvalidSessionException e) {
                        SocketServerConnection.this.disconnect();
                        SocketServerConnection.this.closeServerInstance();
                    }
                    catch (Exception e) {
                        SocketServerConnection.this.closeServerInstance();
                    }
                }
                SocketServerConnection.this.lastPing = System.currentTimeMillis();
                try {
                    return SocketServerConnection.this.selectServerInstance();
                }
                catch (ConnectionException e) {
                    throw new CommunicationException(e);
                }
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return super.invoke(proxy, method, args);
                }
                catch (Exception e) {
                    if (ExceptionUtil.getExceptionOfType(e, InvalidSessionException.class) != null) {
                        SocketServerConnection.this.disconnect();
                    }
                    throw e;
                }
            }
        }));
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.serverInstance != null) {
            this.logoff();
        }
        for (Map.Entry<HostInfo, LogonResult> logonEntry : this.logonResults.entrySet()) {
            try {
                this.connect(logonEntry.getKey());
                this.logoff();
            }
            catch (Exception exception) {}
        }
        this.closed = true;
        this.serverDiscovery.shutdown();
    }

    private void logoff() {
        this.disconnect();
        try {
            ResultsFuture<?> writeFuture = this.serverInstance.getService(ILogon.class).logoff();
            writeFuture.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeServerInstance();
    }

    private void disconnect() {
        this.logonResults.remove(this.serverInstance.getHostInfo());
        if (this.logonResult != null) {
            this.connectionFactory.disconnected(this.serverInstance, this.logonResult.getSessionToken());
            this.logonResult = null;
        }
    }

    private synchronized ResultsFuture<?> isOpen() throws CommunicationException, InvalidSessionException, TeiidComponentException {
        if (this.closed) {
            throw new CommunicationException();
        }
        return this.logon.ping();
    }

    @Override
    public boolean isOpen(long msToTest) {
        try {
            ResultsFuture<?> future = this.isOpen();
            future.get(msToTest, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (Throwable th) {
            return false;
        }
    }

    @Override
    public LogonResult getLogonResult() {
        return this.logonResult;
    }

    synchronized void closeServerInstance() {
        if (this.serverInstance != null) {
            this.serverInstance.shutdown();
            this.serverInstance = null;
        }
    }

    @Override
    public boolean isSameInstance(ServerConnection otherService) throws CommunicationException {
        if (!(otherService instanceof SocketServerConnection)) {
            return false;
        }
        try {
            return this.selectServerInstance().getHostInfo().equals(((SocketServerConnection)otherService).selectServerInstance().getHostInfo());
        }
        catch (ConnectionException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public void cleanUp() {
        this.closeServerInstance();
    }

    public void setFailOver(boolean failOver) {
        this.failOver = failOver;
    }

    public void setFailOverPingInterval(int pingFailOverInterval) {
        this.pingFailOverInterval = pingFailOverInterval;
    }
}

