/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers.path;

import java.util.Set;
import java.util.TreeSet;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.model.helpers.path.ActionsTree;

public class SelectActionForwardPathSupport
extends SpecialWizardSupport
implements StrutsConstants {
    Set<String> tiles = new TreeSet<String>();
    ActionsTree actions = null;
    int tools = 6;

    public String getTitle() {
        if (this.p != null && this.p.getProperty("title") != null) {
            return this.p.getProperty("title");
        }
        return super.getTitle();
    }

    protected void reset() {
        this.getProperties().put("contextProcess", this.getTarget());
        try {
            this.tools = Integer.parseInt(this.p.getProperty("tools"));
        }
        catch (Exception e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
        }
        this.loadTiles();
        this.loadSelection();
    }

    private void loadTiles() {
        Set ts;
        this.tiles.clear();
        if ((this.tools & 4) != 0 && (ts = (Set)this.p.get("tiles")) != null) {
            this.tiles.addAll(ts);
        }
        this.actions = (ActionsTree)this.p.get("actionsTree");
    }

    private void loadSelection() {
        String p = this.getProperties().getProperty("selectedPath");
        if (p == null || p.length() == 0) {
            this.getProperties().remove("selectedObject");
            this.getProperties().remove("selectedTile");
            this.getProperties().remove("selectedAction");
            return;
        }
        if (this.tiles.contains(p)) {
            this.getProperties().setProperty("selectedTab", "Tiles");
            this.getProperties().setProperty("selectedTile", p);
            this.getProperties().remove("selectedObject");
        } else if (this.actions != null && this.isAction(p)) {
            XModelObject o = (XModelObject)this.getProperties().get("selectedAction");
            if (o != null && p.equals(this.actions.getPath(o))) {
                return;
            }
            this.getProperties().setProperty("selectedTab", "Actions");
            XModelObject xModelObject = o = this.actions == null ? null : this.actions.find(p);
            if (o != null) {
                this.getProperties().put("selectedAction", o);
            } else {
                this.getProperties().remove("selectedAction");
            }
        } else {
            this.getProperties().setProperty("selectedTab", "Pages");
            XModelObject so = StrutsProcessStructureHelper.instance.getPhysicalPage(this.getTarget(), p);
            if (so == null && (so = this.findInProcess(p)) != null) {
                so = StrutsProcessStructureHelper.instance.getPhysicalPage(so);
            }
            if (so != null) {
                this.getProperties().put("selectedObject", so);
                while (so != null && so.getFileType() != 3) {
                    so = so.getParent();
                }
                if (so != null) {
                    this.getProperties().put("selectedFileSystem", so);
                }
            }
        }
    }

    private boolean isAction(String path) {
        return StrutsProcessStructureHelper.instance.getUrlPattern(this.getTarget()).isActionUrl(path);
    }

    private XModelObject findInProcess(String p) {
        XModelObject[] cs = this.getTarget().getChildren();
        int i = 0;
        while (i < cs.length) {
            if (p.equals(cs[i].getAttributeValue("path")) && "page".equals(cs[i].getAttributeValue("type"))) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }

    public String getStepImplementingClass(int stepId) {
        String pkg = "org.jboss.tools.struts.ui.wizard.selectpath.";
        return this.tools == 7 ? String.valueOf(pkg) + "SelectGlobalForwardPathStep" : (this.tools == 3 ? String.valueOf(pkg) + "SelectExceptionPathStep" : (this.tools == 2 ? String.valueOf(pkg) + "SelectURLPathStep" : (this.tools == 1 ? String.valueOf(pkg) + "SelectActionPathStep" : String.valueOf(pkg) + "SelectActionForwardPathStep")));
    }

    public void action(String name) throws XModelException {
        if (OK.equals(name) || FINISH.equals(name)) {
            this.setFinished(true);
            this.setStepId(-1);
        } else if (CANCEL.equals(name)) {
            this.setStepId(-1);
            this.getProperties().remove("selectedPath");
            this.setFinished(true);
        }
    }

    public boolean isActionEnabled(String name) {
        if (name.equals(OK)) {
            String pn;
            String tab = this.getProperties().getProperty("selectedTab");
            String string = "Actions".equals(tab) ? "selectedAction" : (pn = "Pages".equals(tab) ? "selectedObject" : "selectedTile");
            return this.getProperties().get(pn) != null;
        }
        return true;
    }
}

